/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.rabbitmq;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqInjectAdapter;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqSpanDecorator;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqTracingUtils;
import io.opentracing.propagation.Format;
import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.util.ReflectionUtils;

public class RabbitMqSendTracingHelper {
    private static final Field FIELD_REPLY_TIMEOUT = ReflectionUtils.findField(RabbitTemplate.class, (String)"replyTimeout");
    private final Tracer tracer;
    private final MessageConverter messageConverter;
    private final RabbitMqSpanDecorator spanDecorator;
    private Scope scope;
    private boolean nullResponseMeansError;
    private RabbitTemplate rabbitTemplate;

    public RabbitMqSendTracingHelper nullResponseMeansTimeout(RabbitTemplate rabbitTemplate) {
        this.nullResponseMeansError = true;
        this.rabbitTemplate = rabbitTemplate;
        return this;
    }

    public <T> T doWithTracingHeadersMessage(String exchange, String routingKey, Object message, ProceedFunction<T> proceedCallback) throws Throwable {
        if (routingKey != null && routingKey.startsWith("amq.rabbitmq.reply-to.")) {
            Message convertedMessage = this.convertMessageIfNecessary(message);
            this.spanDecorator.onSendReply(convertedMessage.getMessageProperties(), exchange, routingKey, this.tracer.activeSpan());
            return proceedCallback.apply(convertedMessage);
        }
        Message messageWithTracingHeaders = this.doBefore(exchange, routingKey, message);
        try {
            T resp = proceedCallback.apply(messageWithTracingHeaders);
            if (resp == null && this.nullResponseMeansError) {
                Span span = this.scope.span();
                this.spanDecorator.onError(null, span);
                long replyTimeout = (Long)ReflectionUtils.getField((Field)FIELD_REPLY_TIMEOUT, (Object)this.rabbitTemplate);
                span.log("Timeout: AMQP request message handler hasn't sent reply AMQP message in " + replyTimeout + "ms");
            }
            T t = resp;
            return t;
        }
        catch (AmqpException ex) {
            this.spanDecorator.onError((Exception)((Object)ex), this.scope.span());
            throw ex;
        }
        finally {
            this.scope.close();
        }
    }

    private Message doBefore(String exchange, String routingKey, Object message) {
        Message convertedMessage = this.convertMessageIfNecessary(message);
        MessageProperties messageProperties = convertedMessage.getMessageProperties();
        this.scope = RabbitMqTracingUtils.buildSendSpan(this.tracer, messageProperties);
        this.tracer.inject(this.scope.span().context(), Format.Builtin.TEXT_MAP, (Object)new RabbitMqInjectAdapter(messageProperties));
        this.spanDecorator.onSend(messageProperties, exchange, routingKey, this.scope.span());
        return convertedMessage;
    }

    private Message convertMessageIfNecessary(Object object) {
        if (object instanceof Message) {
            return (Message)object;
        }
        return this.messageConverter.toMessage(object, new MessageProperties());
    }

    @ConstructorProperties(value={"tracer", "messageConverter", "spanDecorator"})
    public RabbitMqSendTracingHelper(Tracer tracer, MessageConverter messageConverter, RabbitMqSpanDecorator spanDecorator) {
        this.tracer = tracer;
        this.messageConverter = messageConverter;
        this.spanDecorator = spanDecorator;
    }

    static {
        FIELD_REPLY_TIMEOUT.setAccessible(true);
    }

    public static interface ProceedFunction<T> {
        public T apply(Message var1) throws Throwable;
    }
}

