/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.autoconfig;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.web.autoconfig.TracerAutoConfiguration;
import io.opentracing.contrib.spring.web.client.TracingRestTemplateInterceptor;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
public class RestTemplateAutoConfiguration {
    private static final Log log = LogFactory.getLog(RestTemplateAutoConfiguration.class);
    @Autowired(required=false)
    private Set<RestTemplate> restTemplates;
    @Autowired
    private Tracer tracer;

    @PostConstruct
    public void init() {
        if (this.restTemplates != null) {
            for (RestTemplate restTemplate : this.restTemplates) {
                this.registerTracingInterceptor(restTemplate);
            }
        }
    }

    private void registerTracingInterceptor(RestTemplate restTemplate) {
        ArrayList<TracingRestTemplateInterceptor> interceptors = restTemplate.getInterceptors();
        for (ClientHttpRequestInterceptor clientHttpRequestInterceptor : interceptors) {
            if (!(clientHttpRequestInterceptor instanceof TracingRestTemplateInterceptor)) continue;
            return;
        }
        log.info((Object)("Adding " + TracingRestTemplateInterceptor.class.getSimpleName() + " to rest template"));
        interceptors = new ArrayList<TracingRestTemplateInterceptor>(interceptors);
        interceptors.add(new TracingRestTemplateInterceptor(this.tracer));
        restTemplate.setInterceptors(interceptors);
    }
}

