/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.config.client;

import io.pivotal.spring.cloud.config.client.ConfigClientOAuth2Properties;
import io.pivotal.spring.cloud.config.client.OAuth2AuthorizedClientHttpRequestInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ConfigClientProperties.class})
@EnableConfigurationProperties(value={ConfigClientOAuth2Properties.class})
public class ConfigClientOAuth2BootstrapConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ConfigServicePropertySourceLocator.class})
    @ConditionalOnProperty(prefix="spring.cloud.config.client.oauth2", name={"client-id", "client-secret", "access-token-uri"})
    public ConfigServicePropertySourceLocator configServicePropertySourceLocator(ConfigClientProperties configClientProperties, ConfigClientOAuth2Properties configClientOAuth2Properties) {
        ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"config-client").clientId(configClientOAuth2Properties.getClientId()).clientSecret(configClientOAuth2Properties.getClientSecret()).tokenUri(configClientOAuth2Properties.getAccessTokenUri()).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).build();
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getInterceptors().add(new OAuth2AuthorizedClientHttpRequestInterceptor(clientRegistration));
        ConfigServicePropertySourceLocator configServicePropertySourceLocator = new ConfigServicePropertySourceLocator(configClientProperties);
        configServicePropertySourceLocator.setRestTemplate(restTemplate);
        return configServicePropertySourceLocator;
    }
}

