/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.config.client;

import io.pivotal.spring.cloud.config.client.ConfigResourceClient;
import java.net.URI;
import java.util.Optional;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

class OAuth2ConfigResourceClient
implements ConfigResourceClient {
    private final ConfigClientProperties configClientProperties;
    private final RestTemplate restTemplate;

    protected OAuth2ConfigResourceClient(RestTemplate restTemplate, ConfigClientProperties configClientProperties) {
        this.restTemplate = restTemplate;
        this.configClientProperties = configClientProperties;
    }

    @Override
    public Resource getPlainTextResource(String profile, String label, String path) {
        return this.getResource(profile, label, path, ResourceType.PLAINTEXT);
    }

    @Override
    public Resource getBinaryResource(String path) {
        return this.getBinaryResource(null, null, path);
    }

    @Override
    public Resource getBinaryResource(String profile, String label, String path) {
        return this.getResource(profile, label, path, ResourceType.BINARY);
    }

    private Resource getResource(String profile, String label, String path, ResourceType resourceType) {
        Assert.isTrue((this.configClientProperties.getName() != null && !this.configClientProperties.getName().isEmpty() ? 1 : 0) != 0, (String)"Spring application name is undefined.");
        Assert.notEmpty((Object[])this.configClientProperties.getUri(), (String)"Config server URI is undefined");
        Assert.hasText((String)this.configClientProperties.getUri()[0], (String)"Config server URI is undefined.");
        Assert.hasText((String)Optional.ofNullable(label).orElse(this.configClientProperties.getLabel()), (String)"label is undefined");
        if (profile == null && ((profile = this.configClientProperties.getProfile()) == null || profile.isEmpty())) {
            profile = "default";
        }
        if (label == null) {
            label = this.configClientProperties.getLabel();
        }
        UriComponentsBuilder urlBuilder = UriComponentsBuilder.fromHttpUrl((String)this.configClientProperties.getUri()[0]).pathSegment(new String[]{this.configClientProperties.getName()}).pathSegment(new String[]{profile}).pathSegment(new String[]{label}).pathSegment(new String[]{path});
        RequestEntity.HeadersBuilder requestBuilder = RequestEntity.get((URI)urlBuilder.build().toUri());
        if (StringUtils.hasText((String)this.configClientProperties.getToken())) {
            requestBuilder.header("X-Config-Token", new String[]{this.configClientProperties.getToken()});
        }
        if (resourceType == ResourceType.BINARY) {
            requestBuilder.accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM});
        }
        ResponseEntity forEntity = this.restTemplate.exchange(requestBuilder.build(), Resource.class);
        return (Resource)forEntity.getBody();
    }

    private static enum ResourceType {
        BINARY,
        PLAINTEXT;

    }
}

