/*
 * Decompiled with CFR 0.152.
 */
package reactor.test.subscriber;

import java.util.function.Predicate;
import reactor.test.subscriber.ConditionalTestSubscriber;
import reactor.test.subscriber.DefaultConditionalTestSubscriber;
import reactor.test.subscriber.DefaultTestSubscriber;
import reactor.test.subscriber.TestSubscriber;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public final class TestSubscriberBuilder {
    long initialRequest = Long.MAX_VALUE;
    Context context = Context.empty();
    TestSubscriber.FusionRequirement fusionRequirement = TestSubscriber.FusionRequirement.NONE;
    int requestedFusionMode = 0;
    int expectedFusionMode = 0;

    TestSubscriberBuilder() {
    }

    public TestSubscriberBuilder contextPut(Object key, Object value) {
        this.context = this.context.put(key, value);
        return this;
    }

    public TestSubscriberBuilder contextPutAll(ContextView toAdd) {
        this.context = this.context.putAll(toAdd);
        return this;
    }

    public TestSubscriberBuilder initialRequest(long initialRequest) {
        this.initialRequest = initialRequest;
        return this;
    }

    public TestSubscriberBuilder initialRequestUnbounded() {
        this.initialRequest = Long.MAX_VALUE;
        return this;
    }

    public TestSubscriberBuilder requireFusion(int exactMode) {
        return this.requireFusion(exactMode, exactMode);
    }

    public TestSubscriberBuilder requireFusion(int requestedMode, int negotiatedMode) {
        this.fusionRequirement = requestedMode == negotiatedMode && negotiatedMode == 0 ? TestSubscriber.FusionRequirement.NONE : TestSubscriber.FusionRequirement.FUSEABLE;
        this.requestedFusionMode = requestedMode;
        this.expectedFusionMode = negotiatedMode;
        return this;
    }

    public TestSubscriberBuilder requireNotFuseable() {
        this.fusionRequirement = TestSubscriber.FusionRequirement.NOT_FUSEABLE;
        this.requestedFusionMode = 0;
        this.expectedFusionMode = 0;
        return this;
    }

    public <T> ConditionalTestSubscriber<T> buildConditional(Predicate<? super T> tryOnNext) {
        return new DefaultConditionalTestSubscriber<T>(this, tryOnNext);
    }

    public <T> TestSubscriber<T> build() {
        return new DefaultTestSubscriber(this);
    }
}

