/*
 * Decompiled with CFR 0.152.
 */
package reactor.test;

import java.time.Duration;
import java.util.Collection;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import reactor.core.Fuseable;
import reactor.core.publisher.Signal;

public final class ValueFormatters {
    public static final ToStringConverter DURATION_CONVERTER = new ClassBasedToStringConverter<Duration>(Duration.class, d -> true, d -> d.toString().replaceFirst("PT", "").toLowerCase());
    static final Extractor<Signal> DEFAULT_SIGNAL_EXTRACTOR = new Extractor<Signal>(){

        @Override
        public Class<Signal> getTargetClass() {
            return Signal.class;
        }

        @Override
        public boolean matches(Signal value) {
            return value.isOnNext() && value.hasValue();
        }

        @Override
        public String prefix(Signal original) {
            return "onNext(";
        }

        @Override
        public String suffix(Signal original) {
            return ")";
        }

        @Override
        public Stream<Object> explode(Signal original) {
            return Stream.of(original.get());
        }
    };
    static final Extractor<Iterable> DEFAULT_ITERABLE_EXTRACTOR = new Extractor<Iterable>(){

        @Override
        public Class<Iterable> getTargetClass() {
            return Iterable.class;
        }

        @Override
        public boolean matches(Iterable value) {
            return !(value instanceof Fuseable.QueueSubscription);
        }

        @Override
        public String prefix(Iterable original) {
            return "[";
        }

        @Override
        public String suffix(Iterable original) {
            return "]";
        }

        @Override
        public Stream<Object> explode(Iterable original) {
            Spliterator spliterator = original.spliterator();
            return StreamSupport.stream(spliterator, false);
        }
    };

    private ValueFormatters() {
    }

    public static <T> ToStringConverter forClass(Class<T> tClass, Function<T, String> tToString) {
        return new ClassBasedToStringConverter<Object>(tClass, t -> true, tToString);
    }

    public static <T> ToStringConverter forClassMatching(Class<T> tClass, Predicate<T> tPredicate, Function<T, String> tToString) {
        return new ClassBasedToStringConverter<T>(tClass, tPredicate, tToString);
    }

    public static ToStringConverter filtering(Predicate<Object> predicate, Function<Object, String> anyToString) {
        return new PredicateBasedToStringConverter(predicate, anyToString);
    }

    public static Extractor<Signal> signalExtractor() {
        return DEFAULT_SIGNAL_EXTRACTOR;
    }

    public static Extractor<Iterable> iterableExtractor() {
        return DEFAULT_ITERABLE_EXTRACTOR;
    }

    public static <T> Extractor<T[]> arrayExtractor(final Class<T[]> arrayClass) {
        if (!arrayClass.isArray()) {
            throw new IllegalArgumentException("arrayClass must be array");
        }
        return new Extractor<T[]>(){

            @Override
            public Class<T[]> getTargetClass() {
                return arrayClass;
            }

            @Override
            public boolean matches(T[] value) {
                return true;
            }

            @Override
            public String prefix(T[] original) {
                return "[";
            }

            @Override
            public String suffix(T[] original) {
                return "]";
            }

            @Override
            public Stream<Object> explode(T[] original) {
                return Stream.of(original);
            }
        };
    }

    static Object @Nullable [] convertVarArgs(@Nullable ToStringConverter toStringConverter, @Nullable Collection<Extractor<?>> extractors, Object ... args) {
        if (args == null) {
            return null;
        }
        Object[] convertedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            String converted;
            Object arg = args[i];
            if (arg == null || toStringConverter == null) {
                converted = String.valueOf(arg);
            } else if (toStringConverter.test(arg)) {
                converted = (String)toStringConverter.apply(arg);
            } else if (extractors == null) {
                converted = String.valueOf(arg);
            } else {
                converted = null;
                for (Extractor<?> extractor : extractors) {
                    if (!extractor.test(arg)) continue;
                    converted = extractor.apply(arg, toStringConverter);
                    break;
                }
                if (converted == null) {
                    converted = String.valueOf(arg);
                }
            }
            convertedArgs[i] = converted;
        }
        return convertedArgs;
    }

    static class ClassBasedToStringConverter<T>
    implements ToStringConverter {
        private final Class<T> tClass;
        private final Predicate<T> tPredicate;
        private final Function<T, String> function;

        ClassBasedToStringConverter(Class<T> aClass, Predicate<T> predicate, Function<T, String> function) {
            this.tClass = aClass;
            this.tPredicate = predicate;
            this.function = function;
        }

        @Override
        public boolean test(Object o) {
            if (this.tClass.isInstance(o)) {
                return this.tPredicate.test(this.tClass.cast(o));
            }
            return false;
        }

        @Override
        public String apply(Object o) {
            T t;
            if (this.tClass.isInstance(o) && this.tPredicate.test(t = this.tClass.cast(o))) {
                return this.function.apply(t);
            }
            return String.valueOf(o);
        }
    }

    static class PredicateBasedToStringConverter
    implements ToStringConverter {
        private final Predicate<Object> predicate;
        private final Function<Object, String> function;

        PredicateBasedToStringConverter(Predicate<Object> predicate, Function<Object, String> function) {
            this.predicate = predicate;
            this.function = function;
        }

        @Override
        public boolean test(Object o) {
            return this.predicate.test(o);
        }

        @Override
        public String apply(Object o) {
            if (this.predicate.test(o)) {
                return this.function.apply(o);
            }
            return String.valueOf(o);
        }
    }

    public static interface Extractor<CONTAINER>
    extends Predicate<Object>,
    BiFunction<Object, Function<Object, String>, String> {
        public Class<CONTAINER> getTargetClass();

        default public boolean matches(CONTAINER value) {
            return true;
        }

        default public String prefix(CONTAINER original) {
            return "[";
        }

        default public String suffix(CONTAINER original) {
            return "]";
        }

        public Stream<Object> explode(CONTAINER var1);

        @Override
        default public boolean test(Object o) {
            Class<CONTAINER> containerClass = this.getTargetClass();
            if (containerClass.isInstance(o)) {
                CONTAINER container = containerClass.cast(o);
                return this.matches(container);
            }
            return false;
        }

        @Override
        default public @Nullable String apply(Object target, Function<Object, String> contentFormatter) {
            CONTAINER container;
            Class<CONTAINER> containerClass = this.getTargetClass();
            if (containerClass.isInstance(target) && this.matches(container = containerClass.cast(target))) {
                return this.explode(container).map(contentFormatter).collect(Collectors.joining(", ", this.prefix(container), this.suffix(container)));
            }
            return String.valueOf(target);
        }
    }

    public static interface ToStringConverter
    extends Predicate<Object>,
    Function<Object, String> {
    }
}

