/*
 * Decompiled with CFR 0.152.
 */
package reactor.blockhound;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import reactor.blockhound.BlockHound;
import reactor.blockhound.shaded.net.bytebuddy.jar.asm.ClassReader;
import reactor.blockhound.shaded.net.bytebuddy.jar.asm.ClassVisitor;
import reactor.blockhound.shaded.net.bytebuddy.jar.asm.ClassWriter;
import reactor.blockhound.shaded.net.bytebuddy.jar.asm.FieldVisitor;
import reactor.blockhound.shaded.net.bytebuddy.jar.asm.MethodVisitor;

class InstrumentationUtils {
    InstrumentationUtils() {
    }

    static void injectBootstrapClasses(Instrumentation instrumentation, String ... classNames) throws IOException {
        File tempJarFile = File.createTempFile("BlockHound", ".jar");
        tempJarFile.deleteOnExit();
        ClassLoader classLoader = BlockHound.class.getClassLoader();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(tempJarFile));){
            for (String className : classNames) {
                String classFile = className.replace(".", "/") + ".class";
                try (InputStream inputStream = classLoader.getResourceAsStream(classFile);){
                    ZipEntry entry = new ZipEntry(classFile);
                    zipOutputStream.putNextEntry(entry);
                    ClassReader cr = new ClassReader(inputStream);
                    ClassWriter cw = new ClassWriter(cr, 0);
                    cr.accept(new MakePublicClassVisitor(cw), 0);
                    zipOutputStream.write(cw.toByteArray());
                }
                zipOutputStream.closeEntry();
            }
        }
        instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(tempJarFile));
    }

    static class MakePublicClassVisitor
    extends ClassVisitor {
        MakePublicClassVisitor(ClassWriter cw) {
            super(458752, cw);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access | 1, name, signature, superName, interfaces);
        }

        @Override
        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            switch (name) {
                case "blockingMethodConsumer": 
                case "threadPredicate": 
                case "IS_ALLOWED": {
                    access |= 1;
                }
            }
            return super.visitField(access, name, descriptor, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            switch (name) {
                case "checkBlocking": {
                    access |= 1;
                }
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
    }
}

