/*
 * Decompiled with CFR 0.152.
 */
package reactor.blockhound;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Set;
import reactor.blockhound.shaded.net.bytebuddy.jar.asm.ClassReader;
import reactor.blockhound.shaded.net.bytebuddy.jar.asm.ClassVisitor;
import reactor.blockhound.shaded.net.bytebuddy.jar.asm.ClassWriter;
import reactor.blockhound.shaded.net.bytebuddy.jar.asm.MethodVisitor;
import reactor.blockhound.shaded.net.bytebuddy.jar.asm.Type;

class NativeWrappingClassFileTransformer
implements ClassFileTransformer {
    static final Type BLOCK_HOUND_RUNTIME_TYPE = Type.getType("Lreactor/blockhound/BlockHoundRuntime;");
    private final Map<String, Map<String, Set<String>>> blockingMethods;

    NativeWrappingClassFileTransformer(Map<String, Map<String, Set<String>>> blockingMethods) {
        this.blockingMethods = blockingMethods;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        Map<String, Set<String>> blockingMethodsOfClass = this.blockingMethods.get(className);
        if (blockingMethodsOfClass == null) {
            return null;
        }
        ClassReader cr = new ClassReader(classfileBuffer);
        ClassWriter cw = new ClassWriter(cr, 1);
        try {
            cr.accept(new NativeWrappingClassVisitor(cw, blockingMethodsOfClass, className), 0);
            classfileBuffer = cw.toByteArray();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        return classfileBuffer;
    }

    static class NativeWrappingClassVisitor
    extends ClassVisitor {
        private final String className;
        private final Map<String, Set<String>> methods;

        NativeWrappingClassVisitor(ClassVisitor cw, Map<String, Set<String>> methods, String internalClassName) {
            super(458752, cw);
            this.className = internalClassName;
            this.methods = methods;
        }

        @Override
        public MethodVisitor visitMethod(final int access, final String name, final String descriptor, String signature, String[] exceptions) {
            if ((access & 0x100) == 0) {
                return super.visitMethod(access, name, descriptor, signature, exceptions);
            }
            Set<String> descriptors = this.methods.get(name);
            if (descriptors == null || !descriptors.contains(descriptor)) {
                return super.visitMethod(access, name, descriptor, signature, exceptions);
            }
            super.visitMethod(0x112 | access & 8, "$$BlockHound$$_" + name, descriptor, signature, exceptions);
            MethodVisitor delegatingMethodVisitor = super.visitMethod(access & 0xFFFFFEFF, name, descriptor, signature, exceptions);
            delegatingMethodVisitor.visitCode();
            return new MethodVisitor(458752, delegatingMethodVisitor){

                @Override
                public void visitEnd() {
                    boolean isStatic;
                    Type returnType = Type.getReturnType(descriptor);
                    Type[] argumentTypes = Type.getArgumentTypes(descriptor);
                    boolean bl = isStatic = (access & 8) != 0;
                    if (!isStatic) {
                        this.visitVarInsn(25, 0);
                    }
                    int index = isStatic ? 0 : 1;
                    for (Type argumentType : argumentTypes) {
                        this.visitVarInsn(argumentType.getOpcode(21), index);
                        index += argumentType.getSize();
                    }
                    this.visitMethodInsn(isStatic ? 184 : 183, className, "$$BlockHound$$_" + name, descriptor, false);
                    this.visitInsn(returnType.getOpcode(172));
                    this.visitMaxs(0, 0);
                    super.visitEnd();
                }
            };
        }
    }
}

