/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent;

import io.pyroscope.http.AggregationType;
import io.pyroscope.http.Units;
import java.util.EnumSet;
import java.util.Optional;

public enum EventType {
    CPU("cpu", Units.SAMPLES, AggregationType.SUM),
    ALLOC("alloc", Units.OBJECTS, AggregationType.SUM),
    LOCK("lock", Units.SAMPLES, AggregationType.SUM),
    WALL("wall", Units.SAMPLES, AggregationType.SUM),
    ITIMER("itimer", Units.SAMPLES, AggregationType.SUM);

    public final String id;
    public final Units units;
    public final AggregationType aggregationType;

    private EventType(String id, Units units, AggregationType aggregationType) {
        this.id = id;
        this.units = units;
        this.aggregationType = aggregationType;
    }

    public static EventType fromId(String id) throws IllegalArgumentException {
        Optional<EventType> maybeEventType = EnumSet.allOf(EventType.class).stream().filter(eventType -> eventType.id.equals(id)).findAny();
        return maybeEventType.orElseThrow(IllegalArgumentException::new);
    }
}

