/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public final class OverfillQueue<E> {
    private final ArrayBlockingQueue<E> innerQueue;
    private final ReentrantLock lock = new ReentrantLock(false);
    private final Condition notEmpty = this.lock.newCondition();

    public OverfillQueue(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be >= 1");
        }
        this.innerQueue = new ArrayBlockingQueue(capacity);
    }

    public void put(E element) throws InterruptedException {
        block5: {
            this.lock.lockInterruptibly();
            try {
                boolean offerSuccessful = this.innerQueue.offer(element);
                if (offerSuccessful) {
                    this.notEmpty.signal();
                    break block5;
                }
                this.innerQueue.poll();
                offerSuccessful = this.innerQueue.offer(element);
                if (offerSuccessful) {
                    this.notEmpty.signal();
                    break block5;
                }
                throw new RuntimeException("innerQueue.offer was not successful");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public E take() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            E result;
            while ((result = this.innerQueue.poll()) == null) {
                this.notEmpty.await();
            }
            E e = result;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }
}

