/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent.impl;

import io.pyroscope.http.Format;
import io.pyroscope.javaagent.Snapshot;
import io.pyroscope.javaagent.api.Exporter;
import io.pyroscope.javaagent.api.Logger;
import io.pyroscope.javaagent.config.Config;
import io.pyroscope.javaagent.impl.ExponentialBackoff;
import io.pyroscope.javaagent.util.zip.GzipSink;
import io.pyroscope.labels.Pyroscope;
import io.pyroscope.okhttp3.Credentials;
import io.pyroscope.okhttp3.HttpUrl;
import io.pyroscope.okhttp3.MediaType;
import io.pyroscope.okhttp3.MultipartBody;
import io.pyroscope.okhttp3.OkHttpClient;
import io.pyroscope.okhttp3.Request;
import io.pyroscope.okhttp3.RequestBody;
import io.pyroscope.okhttp3.Response;
import io.pyroscope.okhttp3.ResponseBody;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Random;

public class PyroscopeExporter
implements Exporter {
    private static final Duration TIMEOUT = Duration.ofSeconds(10L);
    private static final MediaType PROTOBUF = MediaType.parse("application/x-protobuf");
    final Config config;
    final Logger logger;
    final OkHttpClient client;

    public PyroscopeExporter(Config config, Logger logger) {
        this.config = config;
        this.logger = logger;
        this.client = new OkHttpClient.Builder().connectTimeout(TIMEOUT).readTimeout(TIMEOUT).callTimeout(TIMEOUT).build();
    }

    @Override
    public void export(Snapshot snapshot) {
        try {
            this.uploadSnapshot(snapshot);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    private void uploadSnapshot(Snapshot snapshot) throws InterruptedException {
        HttpUrl url = this.urlForSnapshot(snapshot);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(1000, 30000, new Random());
        boolean retry = true;
        int tries = 0;
        while (retry) {
            RequestBody requestBody;
            ++tries;
            if (this.config.format == Format.JFR) {
                byte[] labels = snapshot.labels.toByteArray();
                this.logger.log(Logger.Level.DEBUG, "Upload attempt %d to %s. %s %s JFR: %s, labels: %s", tries, url.toString(), snapshot.started.toString(), snapshot.ended.toString(), snapshot.data.length, labels.length);
                MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
                RequestBody jfrBody = RequestBody.create(snapshot.data);
                if (this.config.compressionLevelJFR != 0) {
                    jfrBody = GzipSink.gzip(jfrBody, this.config.compressionLevelJFR);
                }
                bodyBuilder.addFormDataPart("jfr", "jfr", jfrBody);
                if (labels.length > 0) {
                    RequestBody labelsBody = RequestBody.create(labels, PROTOBUF);
                    if (this.config.compressionLevelLabels != 0) {
                        labelsBody = GzipSink.gzip(labelsBody, this.config.compressionLevelLabels);
                    }
                    bodyBuilder.addFormDataPart("labels", "labels", labelsBody);
                }
                requestBody = bodyBuilder.build();
            } else {
                this.logger.log(Logger.Level.DEBUG, "Upload attempt %d to %s. collapsed: %s", tries, url.toString(), snapshot.data.length);
                requestBody = RequestBody.create(snapshot.data);
            }
            Request.Builder request = new Request.Builder().post(requestBody).url(url);
            this.config.httpHeaders.forEach((k, v) -> request.header((String)k, (String)v));
            PyroscopeExporter.addAuthHeader(request, url, this.config);
            try (Response response = this.client.newCall(request.build()).execute();){
                int status = response.code();
                if (status >= 400) {
                    ResponseBody body = response.body();
                    String responseBody = body == null ? "" : body.string();
                    this.logger.log(Logger.Level.ERROR, "Error uploading snapshot: %s %s", status, responseBody);
                    retry = PyroscopeExporter.shouldRetry(status);
                } else {
                    retry = false;
                }
            }
            catch (IOException e) {
                this.logger.log(Logger.Level.ERROR, "Error uploading snapshot: %s", e.getMessage());
            }
            if (!retry) continue;
            if (this.config.ingestMaxTries >= 0 && tries >= this.config.ingestMaxTries) {
                this.logger.log(Logger.Level.ERROR, "Gave up uploading profiling snapshot after %d tries", tries);
                break;
            }
            int backoff = exponentialBackoff.error();
            this.logger.log(Logger.Level.DEBUG, "Backing off for %s ms", backoff);
            Thread.sleep(backoff);
        }
    }

    private static boolean shouldRetry(int status) {
        return status == 429 || status / 100 == 5;
    }

    private static void addAuthHeader(Request.Builder request, HttpUrl url, Config config) {
        if (config.tenantID != null && !config.tenantID.isEmpty()) {
            request.header("X-Scope-OrgID", config.tenantID);
        }
        if (config.basicAuthUser != null && !config.basicAuthUser.isEmpty() && config.basicAuthPassword != null && !config.basicAuthPassword.isEmpty()) {
            request.header("Authorization", Credentials.basic(config.basicAuthUser, config.basicAuthPassword));
            return;
        }
        String u = url.username();
        String p = url.password();
        if (!u.isEmpty() && !p.isEmpty()) {
            request.header("Authorization", Credentials.basic(u, p));
            return;
        }
        if (config.authToken != null && !config.authToken.isEmpty()) {
            request.header("Authorization", "Bearer " + config.authToken);
            return;
        }
    }

    private HttpUrl urlForSnapshot(Snapshot snapshot) {
        Instant started = snapshot.started;
        Instant finished = snapshot.ended;
        HttpUrl.Builder builder = HttpUrl.parse(this.config.serverAddress).newBuilder().addPathSegment("ingest").addQueryParameter("name", this.nameWithStaticLabels()).addQueryParameter("units", snapshot.eventType.units.id).addQueryParameter("aggregationType", snapshot.eventType.aggregationType.id).addQueryParameter("sampleRate", Long.toString(this.config.profilingIntervalInHertz())).addQueryParameter("from", Long.toString(started.getEpochSecond())).addQueryParameter("until", Long.toString(finished.getEpochSecond())).addQueryParameter("spyName", "javaspy");
        if (this.config.format == Format.JFR) {
            builder.addQueryParameter("format", "jfr");
        }
        return builder.build();
    }

    private String nameWithStaticLabels() {
        return this.config.timeseries.newBuilder().addLabels(this.config.labels).addLabels(Pyroscope.getStaticLabels()).build().toString();
    }
}

