/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import io.qameta.allure.DefaultConfiguration;
import io.qameta.allure.Extension;
import io.qameta.allure.allure1.Allure1Plugin;
import io.qameta.allure.allure2.Allure2Plugin;
import io.qameta.allure.category.CategoriesPlugin;
import io.qameta.allure.category.CategoriesTrendPlugin;
import io.qameta.allure.context.FreemarkerContext;
import io.qameta.allure.context.JacksonContext;
import io.qameta.allure.context.MarkdownContext;
import io.qameta.allure.context.RandomUidContext;
import io.qameta.allure.context.ReportInfoContext;
import io.qameta.allure.core.AttachmentsPlugin;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.MarkdownDescriptionsPlugin;
import io.qameta.allure.core.Plugin;
import io.qameta.allure.core.TestsResultsPlugin;
import io.qameta.allure.duration.DurationPlugin;
import io.qameta.allure.duration.DurationTrendPlugin;
import io.qameta.allure.environment.Allure1EnvironmentPlugin;
import io.qameta.allure.executor.ExecutorPlugin;
import io.qameta.allure.ga.GaPlugin;
import io.qameta.allure.history.HistoryPlugin;
import io.qameta.allure.history.HistoryTrendPlugin;
import io.qameta.allure.idea.IdeaLinksPlugin;
import io.qameta.allure.influxdb.InfluxDbExportPlugin;
import io.qameta.allure.launch.LaunchPlugin;
import io.qameta.allure.mail.MailPlugin;
import io.qameta.allure.owner.OwnerPlugin;
import io.qameta.allure.prometheus.PrometheusExportPlugin;
import io.qameta.allure.retry.RetryPlugin;
import io.qameta.allure.retry.RetryTrendPlugin;
import io.qameta.allure.severity.SeverityPlugin;
import io.qameta.allure.status.StatusChartPlugin;
import io.qameta.allure.suites.SuitesPlugin;
import io.qameta.allure.summary.SummaryPlugin;
import io.qameta.allure.tags.TagsPlugin;
import io.qameta.allure.timeline.TimelinePlugin;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationBuilder.class);
    private static final String ALLURE_VERSION_TXT_PATH = "/allure-version.txt";
    private static final String UNDEFINED = "Undefined";
    private static final List<Extension> BUNDLED_EXTENSIONS = Arrays.asList(new Extension[]{new MarkdownDescriptionsPlugin(), new TagsPlugin(), new RetryPlugin(), new RetryTrendPlugin(), new SeverityPlugin(), new OwnerPlugin(), new IdeaLinksPlugin(), new HistoryPlugin(), new HistoryTrendPlugin(), new CategoriesPlugin(), new CategoriesTrendPlugin(), new DurationPlugin(), new DurationTrendPlugin(), new StatusChartPlugin(), new TimelinePlugin(), new SuitesPlugin(), new TestsResultsPlugin(), new AttachmentsPlugin(), new MailPlugin(), new InfluxDbExportPlugin(), new PrometheusExportPlugin(), new SummaryPlugin(), new ExecutorPlugin(), new LaunchPlugin(), new Allure1Plugin(), new Allure1EnvironmentPlugin(), new Allure2Plugin(), new GaPlugin()});
    private final List<Extension> extensions = new ArrayList<Extension>();
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final String uuid;
    private final String version;
    private String reportName;
    private String reportLanguage;

    @Deprecated
    public ConfigurationBuilder() {
        this(ConfigurationBuilder.getVersion());
    }

    private ConfigurationBuilder(String version) {
        this.version = version;
        this.uuid = UUID.randomUUID().toString();
    }

    @Deprecated
    public ConfigurationBuilder useDefault() {
        return this.withExtensions(Arrays.asList(new Extension[]{new ReportInfoContext(this.version, this.uuid), new JacksonContext(), new MarkdownContext(), new FreemarkerContext(), new RandomUidContext(), new MarkdownDescriptionsPlugin(), new TagsPlugin(), new RetryPlugin(), new RetryTrendPlugin(), new SeverityPlugin(), new OwnerPlugin(), new IdeaLinksPlugin(), new HistoryPlugin(), new HistoryTrendPlugin(), new CategoriesPlugin(), new CategoriesTrendPlugin(), new DurationPlugin(), new DurationTrendPlugin(), new StatusChartPlugin(), new TimelinePlugin(), new SuitesPlugin(), new TestsResultsPlugin(), new AttachmentsPlugin(), new MailPlugin(), new InfluxDbExportPlugin(), new PrometheusExportPlugin(), new SummaryPlugin(), new ExecutorPlugin(), new LaunchPlugin(), new Allure1Plugin(), new Allure1EnvironmentPlugin(), new Allure2Plugin(), new GaPlugin()}));
    }

    public static ConfigurationBuilder bundled() {
        return ConfigurationBuilder.empty().withExtensions(BUNDLED_EXTENSIONS);
    }

    public static ConfigurationBuilder empty() {
        String allureVersion = ConfigurationBuilder.getVersion();
        return new ConfigurationBuilder(allureVersion).withExtensions(Arrays.asList(new ReportInfoContext(allureVersion), new JacksonContext(), new MarkdownContext(), new FreemarkerContext(), new RandomUidContext()));
    }

    @Deprecated
    public ConfigurationBuilder fromExtensions(List<Extension> extensions) {
        return this.withExtensions(extensions);
    }

    public ConfigurationBuilder withExtensions(List<Extension> extensions) {
        this.extensions.addAll(extensions);
        return this;
    }

    @Deprecated
    public ConfigurationBuilder fromPlugins(List<Plugin> plugins) {
        return this.withPlugins(plugins);
    }

    public ConfigurationBuilder withPlugins(List<Plugin> plugins) {
        this.plugins.addAll(plugins);
        plugins.stream().map(Plugin::getExtensions).forEach(this::withExtensions);
        return this;
    }

    public ConfigurationBuilder withReportName(String reportName) {
        this.reportName = reportName;
        return this;
    }

    public ConfigurationBuilder withReportLanguage(String reportLanguage) {
        this.reportLanguage = reportLanguage;
        return this;
    }

    public Configuration build() {
        return new DefaultConfiguration(this.uuid, this.version, this.reportName, this.reportLanguage, Collections.unmodifiableList(this.extensions), Collections.unmodifiableList(this.plugins));
    }

    private static String getVersion() {
        return ConfigurationBuilder.getVersionFromFile().orElse(ConfigurationBuilder.getVersionFromManifest().orElse(UNDEFINED));
    }

    private static Optional<String> getVersionFromFile() {
        try {
            return Optional.of(IOUtils.resourceToString((String)ALLURE_VERSION_TXT_PATH, (Charset)StandardCharsets.UTF_8)).map(String::trim).filter(v -> !v.isEmpty()).filter(v -> !"#project.version#".equals(v));
        }
        catch (IOException e) {
            LOGGER.debug("Could not read {} resource", (Object)ALLURE_VERSION_TXT_PATH, (Object)e);
            return Optional.empty();
        }
    }

    private static Optional<String> getVersionFromManifest() {
        return Optional.of(ConfigurationBuilder.class).map(Class::getPackage).map(Package::getImplementationVersion);
    }
}

