/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.prometheus;

import io.qameta.allure.CommonMetricAggregator2;
import io.qameta.allure.category.CategoriesMetric;
import io.qameta.allure.metric.Metric;
import io.qameta.allure.metric.StatusMetric;
import io.qameta.allure.metric.TimeMetric;
import io.qameta.allure.prometheus.PrometheusMetricLine;
import io.qameta.allure.retry.RetryMetric;
import java.util.Arrays;
import java.util.List;

public class PrometheusExportPlugin
extends CommonMetricAggregator2 {
    private static final String ALLURE_PROMETHEUS_LABELS = "allure.prometheus.labels";

    public PrometheusExportPlugin() {
        super("prometheusData.txt");
    }

    public List<Metric> getMetrics() {
        String labels = PrometheusExportPlugin.getPrometheusLabels();
        StatusMetric statusMetric = new StatusMetric((status, count) -> new PrometheusMetricLine("launch_status", status.value(), String.valueOf(count), labels));
        TimeMetric timeMetric = new TimeMetric((key, time) -> new PrometheusMetricLine("launch_time", (String)key, String.valueOf(time), labels));
        CategoriesMetric categoriesMetric = new CategoriesMetric((category, count) -> new PrometheusMetricLine("launch_problems", (String)category, String.valueOf(count), labels));
        RetryMetric retryMetric = new RetryMetric((key, count) -> new PrometheusMetricLine("launch_retries", (String)key, String.valueOf(count), labels));
        return Arrays.asList(statusMetric, timeMetric, categoriesMetric, retryMetric);
    }

    public static String getPrometheusLabels() {
        if (System.getProperties().getProperty(ALLURE_PROMETHEUS_LABELS) != null) {
            return System.getProperties().getProperty(ALLURE_PROMETHEUS_LABELS);
        }
        return System.getenv(ALLURE_PROMETHEUS_LABELS);
    }
}

