/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.tags;

import io.qameta.allure.Aggregator2;
import io.qameta.allure.ReportStorage;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.Label;
import io.qameta.allure.entity.LabelName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TagsPlugin
implements Aggregator2 {
    private static final Pattern LABEL_TAG = Pattern.compile("^@?allure\\.label\\.(?<name>.+)[:=](?<value>.+)$");
    public static final String TAGS_BLOCK_NAME = "tags";

    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, ReportStorage reportStorage) {
        launchesResults.stream().map(LaunchResults::getAllResults).flatMap(Collection::stream).forEach(result -> {
            Set tags = (Set)result.findAllLabels(LabelName.TAG, Collectors.toSet());
            List extraLabels = tags.stream().filter(Objects::nonNull).filter(tag -> LABEL_TAG.matcher((CharSequence)tag).matches()).map(TagsPlugin::createFromTag).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            if (!extraLabels.isEmpty()) {
                ArrayList labels = new ArrayList(result.getLabels());
                labels.addAll(extraLabels);
                result.setLabels(labels);
            }
            Set filteredTags = tags.stream().filter(Objects::nonNull).filter(tag -> !LABEL_TAG.matcher((CharSequence)tag).matches()).map(String::trim).filter(s -> !"".equals(s)).collect(Collectors.toSet());
            result.addExtraBlock(TAGS_BLOCK_NAME, new HashSet(filteredTags));
        });
    }

    public static Optional<Label> createFromTag(String tag) {
        Matcher label = LABEL_TAG.matcher(tag);
        if (label.matches()) {
            String name = label.group("name");
            String value = label.group("value");
            return Optional.of(new Label().setName(name).setValue(value.replace("_", " ")));
        }
        return Optional.empty();
    }
}

