/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.util;

import io.qameta.allure.model.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.aspectj.lang.reflect.MethodSignature;

public final class AspectUtils {
    private AspectUtils() {
        throw new IllegalStateException("Do not instance");
    }

    public static Parameter[] getParameters(MethodSignature signature, Object ... args) {
        return (Parameter[])IntStream.range(0, args.length).mapToObj(index -> {
            String name = signature.getParameterNames()[index];
            String value = AspectUtils.objectToString(args[index]);
            return new Parameter().withName(name).withValue(value);
        }).toArray(Parameter[]::new);
    }

    public static Map<String, Object> getParametersMap(MethodSignature signature, Object ... args) {
        String[] parameterNames = signature.getParameterNames();
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (int i = 0; i < Math.max(parameterNames.length, args.length); ++i) {
            params.put(parameterNames[i], args[i]);
        }
        return params;
    }

    public static String objectToString(Object object) {
        if (Objects.nonNull(object) && object instanceof Object[]) {
            return Arrays.toString((Object[])object);
        }
        return Objects.toString(object);
    }
}

