/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.util;

import io.qameta.allure.model.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AspectUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AspectUtils.class);

    private AspectUtils() {
        throw new IllegalStateException("Do not instance");
    }

    public static Parameter[] getParameters(MethodSignature signature, Object ... args) {
        return (Parameter[])IntStream.range(0, args.length).mapToObj(index -> {
            String name = signature.getParameterNames()[index];
            String value = AspectUtils.objectToString(args[index]);
            return new Parameter().setName(name).setValue(value);
        }).toArray(Parameter[]::new);
    }

    public static Map<String, Object> getParametersMap(MethodSignature signature, Object ... args) {
        String[] parameterNames = signature.getParameterNames();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("method", signature.getName());
        for (int i = 0; i < Math.max(parameterNames.length, args.length); ++i) {
            params.put(parameterNames[i], args[i]);
            params.put(Integer.toString(i), args[i]);
        }
        return params;
    }

    public static String objectToString(Object object) {
        try {
            if (Objects.nonNull(object) && object instanceof Object[]) {
                return Arrays.toString((Object[])object);
            }
            return Objects.toString(object);
        }
        catch (Exception e) {
            LOGGER.error("Could not convert object to string", (Throwable)e);
            return "<NPE>";
        }
    }
}

