/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.kotlin.internal;

import io.qameta.allure.kotlin.model.FixtureResult;
import io.qameta.allure.kotlin.model.StepResult;
import io.qameta.allure.kotlin.model.TestResult;
import io.qameta.allure.kotlin.model.TestResultContainer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u0004\u0018\u0001H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u0007H\u0086\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u0007J%\u0010\u0014\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u0002H\t\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/qameta/allure/kotlin/internal/AllureStorage;", "", "()V", "lock", "Ljava/util/concurrent/locks/ReadWriteLock;", "storage", "", "", "get", "T", "uuid", "(Ljava/lang/String;)Ljava/lang/Object;", "getContainer", "Lio/qameta/allure/kotlin/model/TestResultContainer;", "getFixture", "Lio/qameta/allure/kotlin/model/FixtureResult;", "getStep", "Lio/qameta/allure/kotlin/model/StepResult;", "getTestResult", "Lio/qameta/allure/kotlin/model/TestResult;", "put", "item", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "", "allure-kotlin-commons"})
public final class AllureStorage {
    @NotNull
    private final Map<String, Object> storage = new ConcurrentHashMap();
    @NotNull
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    @Nullable
    public final TestResultContainer getContainer(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return (TestResultContainer)this.get(uuid);
    }

    @Nullable
    public final TestResult getTestResult(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return (TestResult)this.get(uuid);
    }

    @Nullable
    public final FixtureResult getFixture(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return (FixtureResult)this.get(uuid);
    }

    @Nullable
    public final StepResult getStep(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return (StepResult)this.get(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> T get(@NotNull String uuid) {
        Object object;
        block3: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            this.lock.readLock().lock();
            try {
                object = this.storage.get(uuid);
                if (object != null) break block3;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> T put(@NotNull String uuid, @NotNull T item) {
        Map<String, Object> map;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter(item, (String)"item");
        this.lock.writeLock().lock();
        try {
            map = this.storage;
            boolean bl = false;
            map.put(uuid, item);
            map = item;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return (T)map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.lock.writeLock().lock();
        try {
            this.storage.remove(uuid);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

