/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.kotlin.util;

import io.qameta.allure.kotlin.util.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010(\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r*\u0006\u0012\u0002\b\u00030\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/qameta/allure/kotlin/util/ServiceLoaderUtils;", "", "()V", "LOGGER", "Ljava/util/logging/Logger;", "load", "", "T", "type", "Ljava/lang/Class;", "classLoader", "Ljava/lang/ClassLoader;", "hasNextSafely", "", "", "allure-kotlin-commons"})
public final class ServiceLoaderUtils {
    @NotNull
    public static final ServiceLoaderUtils INSTANCE = new ServiceLoaderUtils();
    @NotNull
    private static final Logger LOGGER;

    private ServiceLoaderUtils() {
    }

    @JvmStatic
    @NotNull
    public static final <T> List<T> load(@NotNull Class<T> type, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        List loaded = new ArrayList();
        Iterator<T> iterator = ServiceLoader.load(type, classLoader).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"load(type, classLoader).iterator()");
        Iterator<T> iterator2 = iterator;
        while (INSTANCE.hasNextSafely(iterator2)) {
            try {
                T next = iterator2.next();
                loaded.add(next);
                LogUtils.debug$default(LOGGER, Intrinsics.stringPlus((String)"Found ", type), null, 2, null);
            }
            catch (Exception e) {
                LogUtils.error(LOGGER, "Could not load " + type + ": " + e, e);
            }
        }
        return loaded;
    }

    private final boolean hasNextSafely(Iterator<?> $this$hasNextSafely) {
        boolean bl;
        try {
            bl = $this$hasNextSafely.hasNext();
        }
        catch (Exception e) {
            LogUtils.error(LOGGER, "iterator.hasNext() failed", e);
            bl = false;
        }
        return bl;
    }

    static {
        boolean $i$f$loggerFor = false;
        Logger logger = Logger.getLogger(ServiceLoaderUtils.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(T::class.java.name)");
        LOGGER = logger;
    }
}

