/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointModifier;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public interface InjectionPointsTransformer
extends BuildExtension {
    public boolean appliesTo(Type var1);

    public void transform(TransformationContext var1);

    public static final class Transformation {
        private final InjectionPointModifier.TransformationContextImpl transformationContext;
        private final Set<AnnotationInstance> modified;

        Transformation(InjectionPointModifier.TransformationContextImpl transformationContext) {
            this.transformationContext = transformationContext;
            this.modified = new HashSet<AnnotationInstance>(transformationContext.getQualifiers());
        }

        public Transformation add(AnnotationInstance annotation) {
            this.modified.add(annotation);
            return this;
        }

        public Transformation addAll(Collection<AnnotationInstance> annotations) {
            this.modified.addAll(annotations);
            return this;
        }

        public Transformation addAll(AnnotationInstance ... annotations) {
            Collections.addAll(this.modified, annotations);
            return this;
        }

        public Transformation add(Class<? extends Annotation> annotationType, AnnotationValue ... values) {
            this.add(DotNames.create(annotationType.getName()), values);
            return this;
        }

        public Transformation add(DotName name, AnnotationValue ... values) {
            this.add(AnnotationInstance.create((DotName)name, (AnnotationTarget)this.transformationContext.getTarget(), (AnnotationValue[])values));
            return this;
        }

        public Transformation remove(Predicate<AnnotationInstance> predicate) {
            this.modified.removeIf(predicate);
            return this;
        }

        public Transformation removeAll() {
            this.modified.clear();
            return this;
        }

        public void done() {
            this.transformationContext.setQualifiers(this.modified);
        }
    }

    public static interface TransformationContext
    extends BuildExtension.BuildContext {
        public AnnotationTarget getTarget();

        public Collection<AnnotationInstance> getQualifiers();

        public Collection<AnnotationInstance> getAllAnnotations();

        public Transformation transform();
    }
}

