/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.CreationalContextImpl;
import io.quarkus.arc.CurrentInjectionPointProvider;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableObserverMethod;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Hashes;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.spi.EventContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class ObserverGenerator
extends AbstractGenerator {
    static final String OBSERVER_SUFFIX = "_Observer";
    private final AnnotationLiteralProcessor annotationLiterals;
    private final Predicate<DotName> applicationClassPredicate;
    private final BeanProcessor.PrivateMembersCollector privateMembers;

    public ObserverGenerator(AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> applicationClassPredicate, BeanProcessor.PrivateMembersCollector privateMembers) {
        this.annotationLiterals = annotationLiterals;
        this.applicationClassPredicate = applicationClassPredicate;
        this.privateMembers = privateMembers;
    }

    Collection<ResourceOutput.Resource> generate(ObserverInfo observer, ReflectionRegistration reflectionRegistration) {
        ClassInfo declaringClass = observer.getObserverMethod().declaringClass();
        String declaringClassBase = declaringClass.enclosingClass() != null ? DotNames.simpleName(declaringClass.enclosingClass()) + "_" + DotNames.simpleName(declaringClass) : DotNames.simpleName(declaringClass);
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(observer.getObserverMethod().name()).append("_").append(observer.getObserverMethod().returnType().name().toString());
        for (org.jboss.jandex.Type paramType : observer.getObserverMethod().parameters()) {
            sigBuilder.append(paramType.name().toString());
        }
        String baseName = declaringClassBase + OBSERVER_SUFFIX + "_" + observer.getObserverMethod().name() + "_" + Hashes.sha1(sigBuilder.toString());
        String targetPackage = DotNames.packageName(declaringClass.name());
        String generatedName = ObserverGenerator.generatedNameFromTarget(targetPackage, baseName, "");
        boolean isApplicationClass = this.applicationClassPredicate.test(observer.getObserverMethod().declaringClass().name());
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.OBSERVER : null);
        ClassCreator observerCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{InjectableObserverMethod.class}).build();
        FieldCreator observedType = (FieldCreator)observerCreator.getFieldCreator("observedType", Type.class).setModifiers(18);
        FieldCreator observedQualifiers = null;
        if (!observer.getQualifiers().isEmpty()) {
            observedQualifiers = (FieldCreator)observerCreator.getFieldCreator("qualifiers", Set.class).setModifiers(18);
        }
        HashMap<InjectionPointInfo, String> injectionPointToProviderField = new HashMap<InjectionPointInfo, String>();
        this.initMaps(observer, injectionPointToProviderField);
        this.createProviderFields(observerCreator, observer, injectionPointToProviderField);
        this.createConstructor(classOutput, observerCreator, observer, baseName, injectionPointToProviderField, this.annotationLiterals);
        this.implementGetObservedType(observerCreator, observedType.getFieldDescriptor());
        if (observedQualifiers != null) {
            this.implementGetObservedQualifiers(observerCreator, observedQualifiers.getFieldDescriptor());
        }
        this.implementGetBeanClass(observerCreator, observer.getDeclaringBean().getTarget().get().asClass().name());
        this.implementNotify(observer, observerCreator, injectionPointToProviderField, reflectionRegistration, isApplicationClass);
        if (observer.getPriority() != 2500) {
            this.implementGetPriority(observerCreator, observer);
        }
        if (observer.isAsync()) {
            this.implementIsAsync(observerCreator);
        }
        observerCreator.close();
        return classOutput.getResources();
    }

    protected void initMaps(ObserverInfo observer, Map<InjectionPointInfo, String> injectionPointToProvider) {
        int providerIdx = 1;
        for (InjectionPointInfo injectionPoint : observer.getInjection().injectionPoints) {
            if (injectionPoint.getRequiredType().name().equals((Object)DotNames.EVENT_METADATA)) continue;
            injectionPointToProvider.put(injectionPoint, "observerProviderSupplier" + providerIdx++);
        }
    }

    protected void implementGetObservedType(ClassCreator observerCreator, FieldDescriptor observedTypeField) {
        MethodCreator getObservedType = (MethodCreator)observerCreator.getMethodCreator("getObservedType", Type.class, new Class[0]).setModifiers(1);
        getObservedType.returnValue(getObservedType.readInstanceField(observedTypeField, getObservedType.getThis()));
    }

    protected void implementGetObservedQualifiers(ClassCreator observerCreator, FieldDescriptor observedQualifiersField) {
        MethodCreator getObservedQualifiers = (MethodCreator)observerCreator.getMethodCreator("getObservedQualifiers", Set.class, new Class[0]).setModifiers(1);
        getObservedQualifiers.returnValue(getObservedQualifiers.readInstanceField(observedQualifiersField, getObservedQualifiers.getThis()));
    }

    protected void implementGetBeanClass(ClassCreator observerCreator, DotName beanClass) {
        MethodCreator getBeanClass = (MethodCreator)observerCreator.getMethodCreator("getBeanClass", Class.class, new Class[0]).setModifiers(1);
        getBeanClass.returnValue(getBeanClass.loadClass(beanClass.toString()));
    }

    protected void implementGetPriority(ClassCreator observerCreator, ObserverInfo observer) {
        MethodCreator getPriority = (MethodCreator)observerCreator.getMethodCreator("getPriority", Integer.TYPE, new Class[0]).setModifiers(1);
        getPriority.returnValue(getPriority.load(observer.getPriority()));
    }

    protected void implementIsAsync(ClassCreator observerCreator) {
        MethodCreator isAsync = (MethodCreator)observerCreator.getMethodCreator("isAsync", Boolean.TYPE, new Class[0]).setModifiers(1);
        isAsync.returnValue(isAsync.load(true));
    }

    protected void implementNotify(ObserverInfo observer, ClassCreator observerCreator, Map<InjectionPointInfo, String> injectionPointToProviderField, ReflectionRegistration reflectionRegistration, boolean isApplicationClass) {
        boolean skipRelease;
        MethodCreator notify = (MethodCreator)observerCreator.getMethodCreator("notify", Void.TYPE, new Class[]{EventContext.class}).setModifiers(1);
        AssignableResultHandle declaringProviderInstanceHandle = notify.createVariable(Object.class);
        AssignableResultHandle ctxHandle = notify.createVariable(CreationalContextImpl.class);
        ResultHandle declaringProviderSupplierHandle = notify.readInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)"declaringProviderSupplier", (String)Supplier.class.getName()), notify.getThis());
        ResultHandle declaringProviderHandle = notify.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, declaringProviderSupplierHandle, new ResultHandle[0]);
        boolean bl = skipRelease = observer.getDeclaringBean().getScope().isNormal() && observer.getInjection().injectionPoints.isEmpty();
        if (Reception.IF_EXISTS == observer.getReception()) {
            BeanInfo declaringBean = observer.getDeclaringBean();
            if (declaringBean != null && !BuiltinScope.DEPENDENT.is(declaringBean.getScope())) {
                ResultHandle container = notify.invokeStaticMethod(MethodDescriptors.ARC_CONTAINER, new ResultHandle[0]);
                ResultHandle scope = notify.loadClass(declaringBean.getScope().getDotName().toString());
                ResultHandle context = notify.invokeInterfaceMethod(MethodDescriptors.ARC_CONTAINER_GET_ACTIVE_CONTEXT, container, new ResultHandle[]{scope});
                notify.ifNull(context).trueBranch().returnValue(null);
                notify.assign(declaringProviderInstanceHandle, notify.invokeInterfaceMethod(MethodDescriptors.CONTEXT_GET_IF_PRESENT, context, new ResultHandle[]{declaringProviderHandle}));
                BranchResult doesNotExist = notify.ifNull((ResultHandle)declaringProviderInstanceHandle);
                doesNotExist.trueBranch().returnValue(null);
                BytecodeCreator isNotPresent = doesNotExist.falseBranch();
                isNotPresent.assign(ctxHandle, skipRelease ? isNotPresent.loadNull() : isNotPresent.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{declaringProviderHandle}));
            }
        } else {
            notify.assign(ctxHandle, skipRelease ? notify.loadNull() : notify.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{declaringProviderHandle}));
            notify.assign(declaringProviderInstanceHandle, notify.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, declaringProviderHandle, new ResultHandle[]{ctxHandle}));
            if (observer.getDeclaringBean().getScope().isNormal()) {
                notify.assign(declaringProviderInstanceHandle, notify.invokeInterfaceMethod(MethodDescriptors.CLIENT_PROXY_GET_CONTEXTUAL_INSTANCE, (ResultHandle)declaringProviderInstanceHandle, new ResultHandle[0]));
            }
        }
        ResultHandle[] referenceHandles = new ResultHandle[observer.getObserverMethod().parameters().size()];
        short eventParamPosition = observer.getEventParameter().position();
        Iterator<InjectionPointInfo> injectionPointsIterator = observer.getInjection().injectionPoints.iterator();
        for (int i = 0; i < observer.getObserverMethod().parameters().size(); ++i) {
            ResultHandle referenceHandle;
            if (i == eventParamPosition) {
                referenceHandles[i] = notify.invokeInterfaceMethod(MethodDescriptors.EVENT_CONTEXT_GET_EVENT, notify.getMethodParam(0), new ResultHandle[0]);
                continue;
            }
            if (i == observer.getEventMetadataParameterPosition()) {
                referenceHandles[i] = notify.invokeInterfaceMethod(MethodDescriptors.EVENT_CONTEXT_GET_METADATA, notify.getMethodParam(0), new ResultHandle[0]);
                continue;
            }
            ResultHandle childCtxHandle = notify.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD, new ResultHandle[]{ctxHandle});
            ResultHandle providerSupplierHandle = notify.readInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)injectionPointToProviderField.get(injectionPointsIterator.next()), (String)Supplier.class.getName()), notify.getThis());
            ResultHandle providerHandle = notify.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, providerSupplierHandle, new ResultHandle[0]);
            referenceHandles[i] = referenceHandle = notify.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, providerHandle, new ResultHandle[]{childCtxHandle});
        }
        if (Modifier.isPrivate(observer.getObserverMethod().flags())) {
            this.privateMembers.add(isApplicationClass, String.format("Observer method %s#%s()", observer.getObserverMethod().declaringClass().name(), observer.getObserverMethod().name()));
            ResultHandle paramTypesArray = notify.newArray(Class.class, notify.load(referenceHandles.length));
            ResultHandle argsArray = notify.newArray(Object.class, notify.load(referenceHandles.length));
            for (int i = 0; i < referenceHandles.length; ++i) {
                notify.writeArrayValue(paramTypesArray, i, notify.loadClass(((org.jboss.jandex.Type)observer.getObserverMethod().parameters().get(i)).name().toString()));
                notify.writeArrayValue(argsArray, i, referenceHandles[i]);
            }
            reflectionRegistration.registerMethod(observer.getObserverMethod());
            notify.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{notify.loadClass(observer.getObserverMethod().declaringClass().name().toString()), notify.load(observer.getObserverMethod().name()), paramTypesArray, declaringProviderInstanceHandle, argsArray});
        } else {
            notify.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)observer.getObserverMethod()), (ResultHandle)declaringProviderInstanceHandle, referenceHandles);
        }
        if (!skipRelease) {
            notify.invokeInterfaceMethod(MethodDescriptors.CREATIONAL_CTX_RELEASE, (ResultHandle)ctxHandle, new ResultHandle[0]);
        }
        if (BuiltinScope.DEPENDENT.is(observer.getDeclaringBean().getScope())) {
            notify.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_BEAN_DESTROY, declaringProviderHandle, new ResultHandle[]{declaringProviderInstanceHandle, ctxHandle});
        }
        notify.returnValue(null);
    }

    protected void createProviderFields(ClassCreator observerCreator, ObserverInfo observer, Map<InjectionPointInfo, String> injectionPointToProvider) {
        observerCreator.getFieldCreator("declaringProviderSupplier", Supplier.class).setModifiers(18);
        for (String provider : injectionPointToProvider.values()) {
            observerCreator.getFieldCreator(provider, Supplier.class).setModifiers(18);
        }
    }

    protected void createConstructor(ClassOutput classOutput, ClassCreator observerCreator, ObserverInfo observer, String baseName, Map<InjectionPointInfo, String> injectionPointToProviderField, AnnotationLiteralProcessor annotationLiterals) {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        parameterTypes.add(Supplier.class.getName());
        for (InjectionPointInfo injectionPoint : observer.getInjection().injectionPoints) {
            if (BuiltinBean.resolve(injectionPoint) != null) continue;
            parameterTypes.add(Supplier.class.getName());
        }
        MethodCreator constructor = observerCreator.getMethodCreator("<init>", "V", parameterTypes.toArray(new String[0]));
        constructor.invokeSpecialMethod(MethodDescriptors.OBJECT_CONSTRUCTOR, constructor.getThis(), new ResultHandle[0]);
        int paramIdx = 0;
        constructor.writeInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)"declaringProviderSupplier", (String)Supplier.class.getName()), constructor.getThis(), constructor.getMethodParam(0));
        ++paramIdx;
        for (InjectionPointInfo injectionPoint : observer.getInjection().injectionPoints) {
            Object builtinBean = null;
            if (injectionPoint.getResolvedBean() == null) {
                builtinBean = BuiltinBean.resolve(injectionPoint);
            }
            if (builtinBean != null) {
                ((BuiltinBean)((Object)builtinBean)).getGenerator().generate(new BuiltinBean.GeneratorContext(classOutput, observer.getDeclaringBean().getDeployment(), injectionPoint, observerCreator, constructor, injectionPointToProviderField.get(injectionPoint), annotationLiterals, observer));
                continue;
            }
            if (injectionPoint.getResolvedBean().getAllInjectionPoints().stream().anyMatch(ip -> BuiltinBean.INJECTION_POINT.getRawTypeDotName().equals((Object)ip.getRequiredType().name()))) {
                ResultHandle requiredQualifiersHandle = BeanGenerator.collectQualifiers(classOutput, observerCreator, observer.getDeclaringBean().getDeployment(), constructor, injectionPoint, annotationLiterals);
                ResultHandle annotationsHandle = BeanGenerator.collectAnnotations(classOutput, observerCreator, observer.getDeclaringBean().getDeployment(), constructor, injectionPoint, annotationLiterals);
                ResultHandle javaMemberHandle = BeanGenerator.getJavaMemberHandle(constructor, injectionPoint);
                ResultHandle delegateSupplier = constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{constructor.getMethodParam(paramIdx++)});
                ResultHandle wrapHandle = constructor.newInstance(MethodDescriptor.ofConstructor(CurrentInjectionPointProvider.class, (Class[])new Class[]{InjectableBean.class, Supplier.class, Type.class, Set.class, Set.class, Member.class, Integer.TYPE}), new ResultHandle[]{constructor.getThis(), delegateSupplier, Types.getTypeHandle((BytecodeCreator)constructor, injectionPoint.getRequiredType()), requiredQualifiersHandle, annotationsHandle, javaMemberHandle, constructor.load(injectionPoint.getPosition())});
                constructor.writeInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)injectionPointToProviderField.get(injectionPoint), (String)Supplier.class.getName()), constructor.getThis(), wrapHandle);
                continue;
            }
            constructor.writeInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)injectionPointToProviderField.get(injectionPoint), (String)Supplier.class.getName()), constructor.getThis(), constructor.getMethodParam(paramIdx++));
        }
        constructor.writeInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)"observedType", (String)Type.class.getName()), constructor.getThis(), Types.getTypeHandle((BytecodeCreator)constructor, observer.getObservedType()));
        Set<AnnotationInstance> qualifiers = observer.getQualifiers();
        if (!qualifiers.isEmpty()) {
            ResultHandle qualifiersHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance qualifierAnnotation : qualifiers) {
                BuiltinQualifier qualifier = BuiltinQualifier.of(qualifierAnnotation);
                if (qualifier != null) {
                    constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiersHandle, new ResultHandle[]{qualifier.getLiteralInstance((BytecodeCreator)constructor)});
                    continue;
                }
                ClassInfo qualifierClass = observer.getDeclaringBean().getDeployment().getQualifier(qualifierAnnotation.name());
                constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiersHandle, new ResultHandle[]{annotationLiterals.process((BytecodeCreator)constructor, classOutput, qualifierClass, qualifierAnnotation, Types.getPackageName(observerCreator.getClassName()))});
            }
            ResultHandle unmodifiableQualifiersHandle = constructor.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"unmodifiableSet", Set.class, (Class[])new Class[]{Set.class}), new ResultHandle[]{qualifiersHandle});
            constructor.writeInstanceField(FieldDescriptor.of((String)observerCreator.getClassName(), (String)"qualifiers", (String)Set.class.getName()), constructor.getThis(), unmodifiableQualifiersHandle);
        }
        constructor.returnValue(null);
    }
}

