/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.gizmo.DescriptorUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

final class Methods {
    private static final Logger LOGGER = Logger.getLogger(Methods.class);
    public static final String INIT = "<init>";
    public static final String CLINIT = "<clinit>";
    static final int SYNTHETIC = 4096;
    public static final String TO_STRING = "toString";
    private static final List<String> IGNORED_METHODS = Methods.initIgnoredMethods();

    private static List<String> initIgnoredMethods() {
        ArrayList<String> ignored = new ArrayList<String>();
        ignored.add(INIT);
        ignored.add(CLINIT);
        return ignored;
    }

    private Methods() {
    }

    static boolean isSynthetic(MethodInfo method) {
        return (method.flags() & 0x1000) != 0;
    }

    static void addDelegatingMethods(IndexView index, ClassInfo classInfo, Map<MethodKey, MethodInfo> methods, Set<NameAndDescriptor> methodsFromWhichToRemoveFinal, boolean transformUnproxyableClasses) {
        if (classInfo != null) {
            ClassInfo superClassInfo;
            for (MethodInfo method : classInfo.methods()) {
                if (Methods.skipForClientProxy(method, transformUnproxyableClasses, methodsFromWhichToRemoveFinal)) continue;
                methods.computeIfAbsent(new MethodKey(method), key -> {
                    Type returnType = key.method.returnType();
                    Type[] params = new Type[key.method.parameters().size()];
                    for (int i = 0; i < params.length; ++i) {
                        params[i] = (Type)key.method.parameters().get(i);
                    }
                    List typeVariables = key.method.typeParameters();
                    return MethodInfo.create((ClassInfo)classInfo, (String)key.method.name(), (Type[])params, (Type)returnType, (short)key.method.flags(), (TypeVariable[])typeVariables.toArray(new TypeVariable[0]), (Type[])key.method.exceptions().toArray(Type.EMPTY_ARRAY));
                });
            }
            for (Type interfaceType : classInfo.interfaceTypes()) {
                ClassInfo interfaceClassInfo = IndexClassLookupUtils.getClassByName(index, interfaceType.name());
                if (interfaceClassInfo == null) continue;
                Methods.addDelegatingMethods(index, interfaceClassInfo, methods, methodsFromWhichToRemoveFinal, transformUnproxyableClasses);
            }
            if (classInfo.superClassType() != null && (superClassInfo = IndexClassLookupUtils.getClassByName(index, classInfo.superName())) != null) {
                Methods.addDelegatingMethods(index, superClassInfo, methods, methodsFromWhichToRemoveFinal, transformUnproxyableClasses);
            }
        }
    }

    private static boolean skipForClientProxy(MethodInfo method, boolean transformUnproxyableClasses, Set<NameAndDescriptor> methodsFromWhichToRemoveFinal) {
        if (Modifier.isStatic(method.flags()) || Modifier.isPrivate(method.flags())) {
            return true;
        }
        if (IGNORED_METHODS.contains(method.name())) {
            return true;
        }
        if (method.declaringClass().name().equals((Object)DotNames.OBJECT) && !method.name().equals(TO_STRING)) {
            return true;
        }
        if (Modifier.isFinal(method.flags())) {
            String className = method.declaringClass().name().toString();
            if (!className.startsWith("java.")) {
                if (transformUnproxyableClasses && methodsFromWhichToRemoveFinal != null) {
                    methodsFromWhichToRemoveFinal.add(NameAndDescriptor.fromMethodInfo(method));
                    return false;
                }
                LOGGER.warn((Object)String.format("Final method %s.%s() is ignored during proxy generation and should never be invoked upon the proxy instance!", className, method.name()));
            }
            return true;
        }
        return false;
    }

    static boolean isObjectToString(MethodInfo method) {
        return method.declaringClass().name().equals((Object)DotNames.OBJECT) && method.name().equals(TO_STRING);
    }

    static Set<MethodInfo> addInterceptedMethodCandidates(BeanDeployment beanDeployment, ClassInfo classInfo, Map<MethodKey, Set<AnnotationInstance>> candidates, List<AnnotationInstance> classLevelBindings, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        return Methods.addInterceptedMethodCandidates(beanDeployment, classInfo, candidates, classLevelBindings, bytecodeTransformerConsumer, transformUnproxyableClasses, Methods::skipForSubclass, false);
    }

    static Set<MethodInfo> addInterceptedMethodCandidates(BeanDeployment beanDeployment, ClassInfo classInfo, Map<MethodKey, Set<AnnotationInstance>> candidates, List<AnnotationInstance> classLevelBindings, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses, Predicate<MethodInfo> skipPredicate, boolean ignoreMethodLevelBindings) {
        ClassInfo superClassInfo;
        HashSet<NameAndDescriptor> methodsFromWhichToRemoveFinal = new HashSet<NameAndDescriptor>();
        HashSet<MethodInfo> finalMethodsFoundAndNotChanged = new HashSet<MethodInfo>();
        for (MethodInfo method : classInfo.methods()) {
            if (skipPredicate.test(method)) continue;
            HashSet<Object> merged = new HashSet<Object>();
            if (ignoreMethodLevelBindings) {
                merged.addAll(classLevelBindings);
            } else {
                Collection<AnnotationInstance> methodAnnnotations = beanDeployment.getAnnotations((AnnotationTarget)method);
                List methodLevelBindings = methodAnnnotations.stream().filter(a -> beanDeployment.getInterceptorBinding(a.name()) != null).collect(Collectors.toList());
                merged.addAll(methodLevelBindings);
                for (AnnotationInstance classLevelBinding : classLevelBindings) {
                    if (!methodLevelBindings.isEmpty() && !methodLevelBindings.stream().noneMatch(a -> classLevelBinding.name().equals((Object)a.name()))) continue;
                    merged.add(classLevelBinding);
                }
            }
            if (merged.isEmpty()) continue;
            boolean addToCandidates = true;
            if (Modifier.isFinal(method.flags())) {
                if (transformUnproxyableClasses) {
                    methodsFromWhichToRemoveFinal.add(NameAndDescriptor.fromMethodInfo(method));
                } else {
                    addToCandidates = false;
                    finalMethodsFoundAndNotChanged.add(method);
                }
            }
            if (!addToCandidates) continue;
            candidates.computeIfAbsent(new MethodKey(method), key -> merged);
        }
        if (!methodsFromWhichToRemoveFinal.isEmpty()) {
            bytecodeTransformerConsumer.accept(new BytecodeTransformer(classInfo.name().toString(), new RemoveFinalFromMethod(classInfo.name().toString(), methodsFromWhichToRemoveFinal)));
        }
        if (classInfo.superClassType() != null && (superClassInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), classInfo.superName())) != null) {
            finalMethodsFoundAndNotChanged.addAll(Methods.addInterceptedMethodCandidates(beanDeployment, superClassInfo, candidates, classLevelBindings, bytecodeTransformerConsumer, transformUnproxyableClasses));
        }
        for (DotName i : classInfo.interfaceNames()) {
            ClassInfo interfaceInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), i);
            if (interfaceInfo == null) continue;
            Methods.addInterceptedMethodCandidates(beanDeployment, interfaceInfo, candidates, classLevelBindings, bytecodeTransformerConsumer, transformUnproxyableClasses, Methods::skipForDefaultMethods, true);
        }
        return finalMethodsFoundAndNotChanged;
    }

    private static boolean skipForDefaultMethods(MethodInfo method) {
        if (Methods.skipForSubclass(method)) {
            return true;
        }
        return !Modifier.isInterface(method.declaringClass().flags()) || !Modifier.isPublic(method.flags()) || Modifier.isAbstract(method.flags()) || Modifier.isStatic(method.flags());
    }

    private static boolean skipForSubclass(MethodInfo method) {
        if (Modifier.isStatic(method.flags())) {
            return true;
        }
        if (IGNORED_METHODS.contains(method.name())) {
            return true;
        }
        return method.declaringClass().name().equals((Object)DotNames.OBJECT);
    }

    static boolean isOverriden(MethodInfo method, Collection<MethodInfo> previousMethods) {
        for (MethodInfo other : previousMethods) {
            if (!Methods.matchesSignature(method, other)) continue;
            return true;
        }
        return false;
    }

    static boolean isOverriden(MethodKey method, Collection<MethodKey> previousMethods) {
        return previousMethods.contains(method);
    }

    static boolean matchesSignature(MethodInfo method, MethodInfo subclassMethod) {
        if (!method.name().equals(subclassMethod.name())) {
            return false;
        }
        List parameters = method.parameters();
        List subParameters = subclassMethod.parameters();
        int paramCount = parameters.size();
        if (paramCount != subParameters.size()) {
            return false;
        }
        if (paramCount == 0) {
            return true;
        }
        for (int i = 0; i < paramCount; ++i) {
            if (Methods.isTypeEqual((Type)parameters.get(i), (Type)subParameters.get(i))) continue;
            return false;
        }
        return true;
    }

    static boolean isTypeEqual(Type a, Type b) {
        return Methods.toRawType(a).equals((Object)Methods.toRawType(b));
    }

    static DotName toRawType(Type a) {
        switch (a.kind()) {
            case CLASS: 
            case PRIMITIVE: 
            case ARRAY: {
                return a.name();
            }
            case PARAMETERIZED_TYPE: {
                return a.asParameterizedType().name();
            }
        }
        return DotNames.OBJECT;
    }

    static class RemoveFinalFromMethod
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        private final String classToTransform;
        private final Set<NameAndDescriptor> methodsFromWhichToRemoveFinal;

        public RemoveFinalFromMethod(String classToTransform, Set<NameAndDescriptor> methodsFromWhichToRemoveFinal) {
            this.classToTransform = classToTransform;
            this.methodsFromWhichToRemoveFinal = methodsFromWhichToRemoveFinal;
        }

        @Override
        public ClassVisitor apply(String s, ClassVisitor classVisitor) {
            return new ClassVisitor(589824, classVisitor){

                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    if (methodsFromWhichToRemoveFinal.contains(new NameAndDescriptor(name, descriptor))) {
                        access &= 0xFFFFFFEF;
                        LOGGER.debug((Object)("final modifier removed from method " + name + " of class " + classToTransform));
                    }
                    return super.visitMethod(access, name, descriptor, signature, exceptions);
                }
            };
        }
    }

    static class MethodKey {
        final String name;
        final List<DotName> params;
        final MethodInfo method;

        public MethodKey(MethodInfo method) {
            this.method = method;
            this.name = method.name();
            this.params = new ArrayList<DotName>();
            for (Type i : method.parameters()) {
                this.params.add(i.name());
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MethodKey)) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            return this.params.equals(other.params);
        }
    }

    static class NameAndDescriptor {
        private final String name;
        private final String descriptor;

        public NameAndDescriptor(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        public static NameAndDescriptor fromMethodInfo(MethodInfo method) {
            String returnTypeDesc = DescriptorUtils.objectToDescriptor((Object)method.returnType().name().toString());
            String[] paramTypesDesc = new String[method.parameters().size()];
            for (int i = 0; i < method.parameters().size(); ++i) {
                paramTypesDesc[i] = DescriptorUtils.objectToDescriptor((Object)((Type)method.parameters().get(i)).name().toString());
            }
            return new NameAndDescriptor(method.name(), DescriptorUtils.methodSignatureToDescriptor((String)returnTypeDesc, (String[])paramTypesDesc));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameAndDescriptor that = (NameAndDescriptor)o;
            return this.name.equals(that.name) && this.descriptor.equals(that.descriptor);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.descriptor);
        }
    }
}

