/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime.metrics;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceMetrics;
import io.quarkus.agroal.DataSource;
import io.quarkus.arc.Arc;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.metrics.Gauge;

public class AgroalGauge
implements Gauge<Long> {
    private String dataSourceName;
    private volatile AgroalDataSource dataSource;
    private String metric;

    public AgroalGauge() {
    }

    public AgroalGauge(String dataSourceName, String metricName) {
        this.dataSourceName = dataSourceName;
        this.metric = metricName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgroalDataSource getDataSource() {
        AgroalDataSource dsLocal = this.dataSource;
        if (dsLocal == null) {
            AgroalGauge agroalGauge = this;
            synchronized (agroalGauge) {
                dsLocal = this.dataSource;
                if (dsLocal == null) {
                    this.dataSource = this.dataSourceName == null || DataSourceUtil.isDefault((String)this.dataSourceName) ? (dsLocal = (AgroalDataSource)Arc.container().instance(AgroalDataSource.class, new Annotation[0]).get()) : (dsLocal = (AgroalDataSource)Arc.container().instance(AgroalDataSource.class, new Annotation[]{new DataSource.DataSourceLiteral(this.dataSourceName)}).get());
                }
            }
        }
        return dsLocal;
    }

    public Long getValue() {
        AgroalDataSourceMetrics metrics = this.getDataSource().getMetrics();
        switch (this.metric) {
            case "activeCount": {
                return metrics.activeCount();
            }
            case "availableCount": {
                return metrics.availableCount();
            }
            case "maxUsedCount": {
                return metrics.maxUsedCount();
            }
            case "awaitingCount": {
                return metrics.awaitingCount();
            }
            case "blockingTimeAverage": {
                return metrics.blockingTimeAverage().toMillis();
            }
            case "blockingTimeMax": {
                return metrics.blockingTimeMax().toMillis();
            }
            case "blockingTimeTotal": {
                return metrics.blockingTimeTotal().toMillis();
            }
            case "creationTimeAverage": {
                return metrics.creationTimeAverage().toMillis();
            }
            case "creationTimeMax": {
                return metrics.creationTimeMax().toMillis();
            }
            case "creationTimeTotal": {
                return metrics.creationTimeTotal().toMillis();
            }
        }
        throw new IllegalArgumentException("Unknown data source metric");
    }
}

