/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dynamodb.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.dynamodb.runtime.DynamodbBuildTimeConfig;
import io.quarkus.dynamodb.runtime.DynamodbClientProducer;
import io.quarkus.dynamodb.runtime.DynamodbConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@Recorder
public class DynamodbRecorder {
    public BeanContainerListener setDynamodbBuildConfig(DynamodbBuildTimeConfig buildConfig) {
        return beanContainer -> {
            DynamodbClientProducer producer = (DynamodbClientProducer)beanContainer.instance(DynamodbClientProducer.class, new Annotation[0]);
            producer.setBuildTimeConfig(buildConfig);
        };
    }

    public void configureRuntimeConfig(DynamodbConfig dynamodbConfig) {
        ((DynamodbClientProducer)Arc.container().instance(DynamodbClientProducer.class, new Annotation[0]).get()).setRuntimeConfig(dynamodbConfig);
    }

    public RuntimeValue<DynamoDbClient> createClient(BeanContainer beanContainer, ShutdownContext shutdown) {
        DynamodbClientProducer producer = (DynamodbClientProducer)beanContainer.instance(DynamodbClientProducer.class, new Annotation[0]);
        shutdown.addShutdownTask(producer::destroy);
        return new RuntimeValue((Object)producer.client());
    }

    public RuntimeValue<DynamoDbAsyncClient> createAsyncClient(BeanContainer beanContainer, ShutdownContext shutdown) {
        DynamodbClientProducer producer = (DynamodbClientProducer)beanContainer.instance(DynamodbClientProducer.class, new Annotation[0]);
        shutdown.addShutdownTask(producer::destroy);
        return new RuntimeValue((Object)producer.asyncClient());
    }
}

