/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.configproperties;

import io.quarkus.arc.deployment.configproperties.DotNames;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ArrayListFactory;
import io.quarkus.runtime.configuration.HashSetFactory;
import io.smallrye.config.Converters;
import io.smallrye.config.SmallRyeConfig;
import java.util.Optional;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.Converter;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

final class ConfigPropertiesUtil {
    static final String PACKAGE_TO_PLACE_GENERATED_CLASSES = "io.quarkus.arc.runtime.config";

    private ConfigPropertiesUtil() {
    }

    static ResultHandle createReadMandatoryValueAndConvertIfNeeded(String propertyName, Type resultType, DotName declaringClass, BytecodeCreator bytecodeCreator, ResultHandle config) {
        EffectiveTypeResponse effectiveTypeResponse = ConfigPropertiesUtil.getEffectiveResultType(resultType, declaringClass);
        ResultHandle value = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Config.class, (String)"getValue", Object.class, (Class[])new Class[]{String.class, Class.class}), config, new ResultHandle[]{bytecodeCreator.load(propertyName), bytecodeCreator.loadClass(effectiveTypeResponse.getEffectiveType().toString())});
        return ConfigPropertiesUtil.createConversionToFinalValue(resultType.name(), effectiveTypeResponse.getEffectiveType(), effectiveTypeResponse.getGenericType(), bytecodeCreator, value, config);
    }

    static ReadOptionalResponse createReadOptionalValueAndConvertIfNeeded(String propertyName, Type resultType, DotName declaringClass, BytecodeCreator bytecodeCreator, ResultHandle config) {
        DotName resultTypeDotName = resultType.name();
        EffectiveTypeResponse effectiveTypeResponse = ConfigPropertiesUtil.getEffectiveResultType(resultType, declaringClass);
        ResultHandle optionalValue = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Config.class, (String)"getOptionalValue", Optional.class, (Class[])new Class[]{String.class, Class.class}), config, new ResultHandle[]{bytecodeCreator.load(propertyName), bytecodeCreator.loadClass(effectiveTypeResponse.getEffectiveType().toString())});
        ResultHandle isPresent = bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Optional.class, (String)"isPresent", Boolean.TYPE, (Class[])new Class[0]), optionalValue, new ResultHandle[0]);
        BranchResult isPresentBranch = bytecodeCreator.ifNonZero(isPresent);
        BytecodeCreator isPresentTrue = isPresentBranch.trueBranch();
        ResultHandle value = isPresentTrue.invokeVirtualMethod(MethodDescriptor.ofMethod(Optional.class, (String)"get", Object.class, (Class[])new Class[0]), optionalValue, new ResultHandle[0]);
        value = ConfigPropertiesUtil.createConversionToFinalValue(resultTypeDotName, effectiveTypeResponse.getEffectiveType(), effectiveTypeResponse.getGenericType(), isPresentTrue, value, config);
        return new ReadOptionalResponse(value, isPresentTrue, isPresentBranch.falseBranch(), effectiveTypeResponse);
    }

    static EffectiveTypeResponse getEffectiveResultType(Type resultType, DotName declaringClass) {
        if (DotNames.LIST.equals((Object)resultType.name()) || DotNames.COLLECTION.equals((Object)resultType.name()) || DotNames.SET.equals((Object)resultType.name())) {
            return new EffectiveTypeResponse(DotNames.STRING, ConfigPropertiesUtil.determineSingleGenericType(resultType, declaringClass).name());
        }
        return new EffectiveTypeResponse(resultType.name());
    }

    static ResultHandle createConversionToFinalValue(DotName resultTypeDotName, DotName typeUsedToLoadValue, DotName genericType, BytecodeCreator bytecodeCreator, ResultHandle value, ResultHandle config) {
        if (genericType != null) {
            if (DotNames.LIST.equals((Object)resultTypeDotName) || DotNames.COLLECTION.equals((Object)resultTypeDotName) || DotNames.SET.equals((Object)resultTypeDotName)) {
                ResultHandle smallryeConfig = bytecodeCreator.checkCast(config, SmallRyeConfig.class);
                ResultHandle itemConverter = bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getConverter", Converter.class, (Class[])new Class[]{Class.class}), smallryeConfig, new ResultHandle[]{bytecodeCreator.loadClass(genericType.toString())});
                Class factoryToUse = DotNames.SET.equals((Object)resultTypeDotName) ? HashSetFactory.class : ArrayListFactory.class;
                ResultHandle collectionFactory = bytecodeCreator.invokeStaticMethod(MethodDescriptor.ofMethod(factoryToUse, (String)"getInstance", factoryToUse, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle collectionConverter = bytecodeCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Converters.class, (String)"newCollectionConverter", Converter.class, (Class[])new Class[]{Converter.class, IntFunction.class}), new ResultHandle[]{itemConverter, collectionFactory});
                return bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Converter.class, (String)"convert", Object.class, (Class[])new Class[]{String.class}), collectionConverter, new ResultHandle[]{value});
            }
            throw new IllegalStateException("Result type " + resultTypeDotName + " is not handled");
        }
        if (!resultTypeDotName.equals((Object)typeUsedToLoadValue) && DotNames.STRING.equals((Object)typeUsedToLoadValue)) {
            ResultHandle smallryeConfig = bytecodeCreator.checkCast(config, SmallRyeConfig.class);
            return bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"convert", Object.class, (Class[])new Class[]{String.class, Class.class}), smallryeConfig, new ResultHandle[]{value, bytecodeCreator.loadClass(resultTypeDotName.toString())});
        }
        return value;
    }

    static Type determineSingleGenericType(Type type, DotName declaringClass) {
        if (type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            throw new IllegalArgumentException("Type " + type.name().toString() + " which is used in class " + declaringClass + " must define a generic argument");
        }
        ParameterizedType parameterizedType = type.asParameterizedType();
        if (parameterizedType.arguments().size() != 1) {
            throw new IllegalArgumentException("Type " + type.name().toString() + " which is used in class " + declaringClass + " must define a single generic argument");
        }
        return (Type)type.asParameterizedType().arguments().get(0);
    }

    static class ReadOptionalResponse {
        private final ResultHandle value;
        private final BytecodeCreator isPresentTrue;
        private final BytecodeCreator isPresentFalse;
        private final EffectiveTypeResponse effectiveTypeResponse;

        ReadOptionalResponse(ResultHandle value, BytecodeCreator isPresentTrue, BytecodeCreator isPresentFalse, EffectiveTypeResponse effectiveTypeResponse) {
            this.value = value;
            this.isPresentTrue = isPresentTrue;
            this.isPresentFalse = isPresentFalse;
            this.effectiveTypeResponse = effectiveTypeResponse;
        }

        public ResultHandle getValue() {
            return this.value;
        }

        public BytecodeCreator getIsPresentTrue() {
            return this.isPresentTrue;
        }

        public BytecodeCreator getIsPresentFalse() {
            return this.isPresentFalse;
        }

        public EffectiveTypeResponse getEffectiveTypeResponse() {
            return this.effectiveTypeResponse;
        }
    }

    static class EffectiveTypeResponse {
        private final DotName effectiveType;
        private final DotName genericType;

        public EffectiveTypeResponse(DotName effectiveType) {
            this(effectiveType, null);
        }

        EffectiveTypeResponse(DotName effectiveType, DotName genericType) {
            this.effectiveType = effectiveType;
            this.genericType = genericType;
        }

        public DotName getEffectiveType() {
            return this.effectiveType;
        }

        public DotName getGenericType() {
            return this.genericType;
        }
    }
}

