/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.jms.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.artemis.core.deployment.ArtemisBuildTimeConfig;
import io.quarkus.artemis.core.deployment.ArtemisJmsBuildItem;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfig;
import io.quarkus.artemis.jms.deployment.ArtemisJmsConfiguredBuildItem;
import io.quarkus.artemis.jms.runtime.ArtemisJmsRecorder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import javax.enterprise.context.ApplicationScoped;
import javax.jms.ConnectionFactory;

public class ArtemisJmsProcessor {
    @BuildStep
    void load(BuildProducer<FeatureBuildItem> feature, BuildProducer<ArtemisJmsBuildItem> artemisJms) {
        artemisJms.produce((BuildItem)new ArtemisJmsBuildItem());
        feature.produce((BuildItem)new FeatureBuildItem(Feature.ARTEMIS_JMS));
    }

    @BuildStep
    HealthBuildItem health(ArtemisBuildTimeConfig buildConfig) {
        return new HealthBuildItem("io.quarkus.artemis.jms.runtime.health.ConnectionFactoryHealthCheck", buildConfig.healthEnabled);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    ArtemisJmsConfiguredBuildItem configure(ArtemisJmsRecorder recorder, ArtemisRuntimeConfig runtimeConfig, BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer) {
        SyntheticBeanBuildItem connectionFactory = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(ConnectionFactory.class).supplier(recorder.getConnectionFactorySupplier(runtimeConfig)).scope(ApplicationScoped.class)).defaultBean()).unremovable()).setRuntimeInit().done();
        syntheticBeanProducer.produce((BuildItem)connectionFactory);
        return new ArtemisJmsConfiguredBuildItem();
    }
}

