/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.MavenModelBuilder;
import io.quarkus.bootstrap.resolver.maven.SettingsDecrypterImpl;
import io.quarkus.bootstrap.util.PropertyUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.path.DefaultPathTranslator;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.DefaultProfileSelector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.FileProfileActivator;
import org.apache.maven.model.profile.activation.JdkVersionProfileActivator;
import org.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.apache.maven.model.profile.activation.PropertyProfileActivator;
import org.apache.maven.model.resolution.WorkspaceModelResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.jboss.logging.Logger;

public class MavenRepoInitializer {
    private static final String DEFAULT_REMOTE_REPO_ID = "central";
    private static final String DEFAULT_REMOTE_REPO_URL = "https://repo.maven.apache.org/maven2";
    private static final String BASEDIR = "basedir";
    private static final String MAVEN_CMD_LINE_ARGS = "MAVEN_CMD_LINE_ARGS";
    private static final String DOT_M2 = ".m2";
    private static final String MAVEN_HOME = "maven.home";
    private static final String M2_HOME = "M2_HOME";
    private static final String SETTINGS_XML = "settings.xml";
    private static final String userHome = PropertyUtils.getUserHome();
    private static final File userMavenConfigurationHome = new File(userHome, ".m2");
    private static final String envM2Home = System.getenv("M2_HOME");
    private static final File USER_SETTINGS_FILE;
    private static final File GLOBAL_SETTINGS_FILE;
    private static final CommandLine mvnArgs;
    private static Settings settings;
    private static final Logger log;

    private static File resolveUserSettings(String settingsArg) {
        File userSettings = new File(settingsArg);
        if (userSettings.exists()) {
            return userSettings;
        }
        String base = System.getenv("MAVEN_PROJECTBASEDIR");
        if (base != null && (userSettings = new File(base, settingsArg)).exists()) {
            return userSettings;
        }
        base = PropertyUtils.getProperty(BASEDIR);
        if (base != null && (userSettings = new File(base, settingsArg)).exists()) {
            return userSettings;
        }
        userSettings = new File(userHome, settingsArg);
        if (userSettings.exists()) {
            return userSettings;
        }
        return null;
    }

    public static RepositorySystem getRepositorySystem() {
        return MavenRepoInitializer.getRepositorySystem(false, null);
    }

    public static RepositorySystem getRepositorySystem(boolean offline, WorkspaceModelResolver wsModelResolver) {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        if (!offline) {
            locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
            locator.addService(TransporterFactory.class, FileTransporterFactory.class);
            locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        }
        locator.setServices(ModelBuilder.class, (Object[])new ModelBuilder[]{new MavenModelBuilder(wsModelResolver)});
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                log.error((Object)("Failed to initialize " + impl.getName() + " as a service implementing " + type.getName()), exception);
            }
        });
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public static DefaultRepositorySystemSession newSession(RepositorySystem system) throws AppModelResolverException {
        return MavenRepoInitializer.newSession(system, MavenRepoInitializer.getSettings());
    }

    public static DefaultRepositorySystemSession newSession(RepositorySystem system, Settings settings) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        List mirrors = settings.getMirrors();
        if (mirrors != null && !mirrors.isEmpty()) {
            DefaultMirrorSelector ms = new DefaultMirrorSelector();
            for (Mirror m : mirrors) {
                ms.add(m.getId(), m.getUrl(), m.getLayout(), false, m.getMirrorOf(), m.getMirrorOfLayouts());
            }
            session.setMirrorSelector((MirrorSelector)ms);
        }
        String localRepoPath = MavenRepoInitializer.getLocalRepo(settings);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, new LocalRepository(localRepoPath)));
        session.setOffline(settings.isOffline());
        if (mvnArgs != null) {
            if (!session.isOffline() && mvnArgs.hasOption('o')) {
                session.setOffline(true);
            }
            if (mvnArgs.hasOption("nsu")) {
                session.setUpdatePolicy("never");
            } else if (mvnArgs.hasOption('U')) {
                session.setUpdatePolicy("always");
            }
            if (mvnArgs.hasOption('C')) {
                session.setChecksumPolicy("fail");
            } else if (mvnArgs.hasOption('c')) {
                session.setChecksumPolicy("warn");
            }
        }
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies(settings.getProxies());
        decrypt.setServers(settings.getServers());
        SettingsDecryptionResult decrypted = new SettingsDecrypterImpl().decrypt((SettingsDecryptionRequest)decrypt);
        if (decrypted.getProblems().isEmpty()) {
            for (SettingsProblem p : decrypted.getProblems()) {
                log.warn((Object)("Problem decrypting maven settings: " + p));
            }
        }
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy p : decrypted.getProxies()) {
            proxySelector.add(MavenRepoInitializer.toAetherProxy(p), p.getNonProxyHosts());
        }
        session.setProxySelector((ProxySelector)proxySelector);
        LinkedHashMap<Object, Object> configProps = new LinkedHashMap<Object, Object>();
        configProps.put("aether.connector.userAgent", MavenRepoInitializer.getUserAgent());
        configProps.put("aether.interactive", settings.isInteractiveMode());
        configProps.putAll(System.getProperties());
        DefaultAuthenticationSelector authSelector = new DefaultAuthenticationSelector();
        for (Server server : decrypted.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            authSelector.add(server.getId(), authBuilder.build());
            if (server.getConfiguration() != null) {
                Xpp3Dom dom = (Xpp3Dom)server.getConfiguration();
                for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = dom.getChild(i);
                    if (!"wagonProvider".equals(child.getName())) continue;
                    dom.removeChild(i);
                }
                XmlPlexusConfiguration config = new XmlPlexusConfiguration(dom);
                configProps.put("aether.connector.wagon.config." + server.getId(), config);
            }
            configProps.put("aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            configProps.put("aether.connector.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
        session.setAuthenticationSelector((AuthenticationSelector)authSelector);
        session.setConfigProperties(configProps);
        return session;
    }

    public static List<RemoteRepository> getRemoteRepos(RepositorySystem repoSystem, RepositorySystemSession repoSession) throws AppModelResolverException {
        return Collections.unmodifiableList(MavenRepoInitializer.getRemoteRepos(MavenRepoInitializer.getSettings(), repoSystem, repoSession));
    }

    public static List<RemoteRepository> getRemoteRepos(Settings settings) throws AppModelResolverException {
        RepositorySystem system = MavenRepoInitializer.getRepositorySystem();
        return MavenRepoInitializer.getRemoteRepos(settings, system, (RepositorySystemSession)MavenRepoInitializer.newSession(system, settings));
    }

    public static List<RemoteRepository> getRemoteRepos(Settings settings, RepositorySystem repoSystem, RepositorySystemSession repoSession) throws AppModelResolverException {
        List activeProfiles;
        ArrayList<RemoteRepository> remotes = new ArrayList<RemoteRepository>();
        int profilesTotal = settings.getProfiles().size();
        if (profilesTotal > 0) {
            String[] profileOptionValues;
            List modelProfiles = new ArrayList<org.apache.maven.model.Profile>(profilesTotal);
            for (Profile profile : settings.getProfiles()) {
                modelProfiles.add(SettingsUtils.convertFromSettingsProfile((Profile)profile));
            }
            ArrayList<String> activeProfiles2 = new ArrayList<String>(0);
            ArrayList<String> inactiveProfiles = new ArrayList<String>(0);
            if (mvnArgs != null && (profileOptionValues = mvnArgs.getOptionValues('P')) != null && profileOptionValues.length > 0) {
                for (String profileOptionValue : profileOptionValues) {
                    StringTokenizer profileTokens = new StringTokenizer(profileOptionValue, ",");
                    while (profileTokens.hasMoreTokens()) {
                        String profileAction = profileTokens.nextToken().trim();
                        if (profileAction.isEmpty()) continue;
                        char c = profileAction.charAt(0);
                        if (c == '-' || c == '!') {
                            inactiveProfiles.add(profileAction.substring(1));
                            continue;
                        }
                        if (c == '+') {
                            activeProfiles2.add(profileAction.substring(1));
                            continue;
                        }
                        activeProfiles2.add(profileAction);
                    }
                }
            }
            String basedir = PropertyUtils.getProperty(BASEDIR);
            DefaultProfileActivationContext context = new DefaultProfileActivationContext().setActiveProfileIds(activeProfiles2).setInactiveProfileIds(inactiveProfiles).setSystemProperties(System.getProperties()).setProjectDirectory(basedir == null ? new File("") : new File(basedir));
            DefaultProfileSelector profileSelector = new DefaultProfileSelector().addProfileActivator((ProfileActivator)new PropertyProfileActivator()).addProfileActivator((ProfileActivator)new JdkVersionProfileActivator()).addProfileActivator((ProfileActivator)new OperatingSystemProfileActivator()).addProfileActivator((ProfileActivator)new FileProfileActivator().setPathTranslator((PathTranslator)new DefaultPathTranslator()));
            modelProfiles = profileSelector.getActiveProfiles(modelProfiles, (ProfileActivationContext)context, new ModelProblemCollector(){

                public void add(ModelProblemCollectorRequest req) {
                    log.error((Object)("Failed to activate a Maven profile: " + req.getMessage()));
                }
            });
            for (org.apache.maven.model.Profile modelProfile : modelProfiles) {
                MavenRepoInitializer.addProfileRepos(modelProfile, remotes);
            }
        }
        if (!(activeProfiles = settings.getActiveProfiles()).isEmpty()) {
            for (String profileName : activeProfiles) {
                Profile profile = MavenRepoInitializer.getProfile(profileName, settings);
                if (profile == null) continue;
                MavenRepoInitializer.addProfileRepos(profile, remotes);
            }
        }
        if (remotes.isEmpty() || !MavenRepoInitializer.includesDefaultRepo(remotes)) {
            remotes.add(new RemoteRepository.Builder(DEFAULT_REMOTE_REPO_ID, "default", DEFAULT_REMOTE_REPO_URL).setReleasePolicy(new RepositoryPolicy(true, "daily", "warn")).setSnapshotPolicy(new RepositoryPolicy(false, "daily", "warn")).build());
        }
        return repoSystem.newResolutionRepositories(repoSession, remotes);
    }

    private static Proxy toAetherProxy(org.apache.maven.settings.Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        Authentication auth = null;
        if (proxy.getUsername() != null) {
            auth = new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
        }
        return new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
    }

    private static Profile getProfile(String name, Settings settings) throws AppModelResolverException {
        Profile profile = (Profile)settings.getProfilesAsMap().get(name);
        if (profile == null) {
            MavenRepoInitializer.unrecognizedProfile(name, true);
        }
        return profile;
    }

    private static void unrecognizedProfile(String name, boolean activate) {
        StringBuilder buf = new StringBuilder();
        buf.append("The requested Maven profile \"").append(name).append("\" could not be ");
        if (!activate) {
            buf.append("de");
        }
        buf.append("activated because it does not exist.");
        log.warn((Object)buf.toString());
    }

    private static void addProfileRepos(org.apache.maven.model.Profile profile, List<RemoteRepository> all) {
        List repositories = profile.getRepositories();
        for (org.apache.maven.model.Repository repo : repositories) {
            RemoteRepository.Builder repoBuilder = new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl());
            org.apache.maven.model.RepositoryPolicy policy = repo.getReleases();
            if (policy != null) {
                repoBuilder.setReleasePolicy(MavenRepoInitializer.toAetherRepoPolicy(policy));
            }
            if ((policy = repo.getSnapshots()) != null) {
                repoBuilder.setSnapshotPolicy(MavenRepoInitializer.toAetherRepoPolicy(policy));
            }
            all.add(repoBuilder.build());
        }
    }

    private static void addProfileRepos(Profile profile, List<RemoteRepository> all) {
        List repositories = profile.getRepositories();
        for (Repository repo : repositories) {
            RemoteRepository.Builder repoBuilder = new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl());
            org.apache.maven.settings.RepositoryPolicy policy = repo.getReleases();
            if (policy != null) {
                repoBuilder.setReleasePolicy(MavenRepoInitializer.toAetherRepoPolicy(policy));
            }
            if ((policy = repo.getSnapshots()) != null) {
                repoBuilder.setSnapshotPolicy(MavenRepoInitializer.toAetherRepoPolicy(policy));
            }
            all.add(repoBuilder.build());
        }
    }

    public static Settings getSettings() throws AppModelResolverException {
        Settings effectiveSettings;
        if (settings != null) {
            return settings;
        }
        try {
            SettingsBuildingResult result = new DefaultSettingsBuilderFactory().newInstance().build((SettingsBuildingRequest)new DefaultSettingsBuildingRequest().setSystemProperties(System.getProperties()).setUserSettingsFile(USER_SETTINGS_FILE).setGlobalSettingsFile(GLOBAL_SETTINGS_FILE));
            List problems = result.getProblems();
            if (!problems.isEmpty()) {
                for (SettingsProblem problem : problems) {
                    switch (problem.getSeverity()) {
                        case ERROR: 
                        case FATAL: {
                            throw new AppModelResolverException("Settings problem encountered at " + problem.getLocation(), problem.getException());
                        }
                    }
                    log.warn((Object)("Settings problem encountered at " + problem.getLocation()), (Throwable)problem.getException());
                }
            }
            effectiveSettings = result.getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            throw new AppModelResolverException("Failed to initialize Maven repository settings", e);
        }
        settings = effectiveSettings;
        return settings;
    }

    public static String getLocalRepo(Settings settings) {
        String localRepo = settings.getLocalRepository();
        return localRepo == null ? MavenRepoInitializer.getDefaultLocalRepo() : localRepo;
    }

    private static String getDefaultLocalRepo() {
        return new File(userMavenConfigurationHome, "repository").getAbsolutePath();
    }

    private static boolean includesDefaultRepo(List<RemoteRepository> repositories) {
        for (ArtifactRepository artifactRepository : repositories) {
            if (!artifactRepository.getId().equals(DEFAULT_REMOTE_REPO_ID)) continue;
            return true;
        }
        return false;
    }

    private static RepositoryPolicy toAetherRepoPolicy(org.apache.maven.model.RepositoryPolicy modelPolicy) {
        return new RepositoryPolicy(modelPolicy.isEnabled(), MavenRepoInitializer.isEmpty(modelPolicy.getUpdatePolicy()) ? "daily" : modelPolicy.getUpdatePolicy(), MavenRepoInitializer.isEmpty(modelPolicy.getChecksumPolicy()) ? "warn" : modelPolicy.getChecksumPolicy());
    }

    private static RepositoryPolicy toAetherRepoPolicy(org.apache.maven.settings.RepositoryPolicy settingsPolicy) {
        return new RepositoryPolicy(settingsPolicy.isEnabled(), MavenRepoInitializer.isEmpty(settingsPolicy.getUpdatePolicy()) ? "daily" : settingsPolicy.getUpdatePolicy(), MavenRepoInitializer.isEmpty(settingsPolicy.getChecksumPolicy()) ? "warn" : settingsPolicy.getChecksumPolicy());
    }

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private static String getUserAgent() {
        return "Apache-Maven/" + MavenRepoInitializer.getMavenVersion() + " (Java " + PropertyUtils.getProperty("java.version") + "; " + PropertyUtils.getProperty("os.name") + " " + PropertyUtils.getProperty("os.version") + ")";
    }

    private static String getMavenVersion() {
        Properties props = new Properties();
        try (InputStream is = MavenRepoInitializer.class.getResourceAsStream("/META-INF/maven/org.apache.maven/maven-core/pom.properties");){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
            log.debug((Object)"Failed to read Maven version", (Throwable)e);
        }
        return props.getProperty("version", "unknown-version");
    }

    static {
        String mvnCmd = System.getenv(MAVEN_CMD_LINE_ARGS);
        String userSettings = null;
        String globalSettings = null;
        if (mvnCmd != null) {
            CLIManager mvnCli = new CLIManager();
            try {
                mvnArgs = mvnCli.parse(mvnCmd.split("\\s+"));
            }
            catch (ParseException e) {
                throw new IllegalStateException("Failed to parse Maven command line arguments", e);
            }
            userSettings = mvnArgs.getOptionValue('s');
            globalSettings = mvnArgs.getOptionValue("gs");
        } else {
            mvnArgs = null;
        }
        File f = userSettings != null ? MavenRepoInitializer.resolveUserSettings(userSettings) : new File(userMavenConfigurationHome, SETTINGS_XML);
        File file = USER_SETTINGS_FILE = f != null && f.exists() ? f : null;
        f = globalSettings != null ? MavenRepoInitializer.resolveUserSettings(globalSettings) : new File(PropertyUtils.getProperty(MAVEN_HOME, envM2Home != null ? envM2Home : ""), "conf/settings.xml");
        GLOBAL_SETTINGS_FILE = f != null && f.exists() ? f : null;
        log = Logger.getLogger(MavenRepoInitializer.class);
    }
}

