/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.BuildDependencyGraphVisitor;
import io.quarkus.bootstrap.resolver.maven.DeploymentInjectingDependencyVisitor;
import io.quarkus.bootstrap.resolver.maven.DeploymentInjectionException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.SimpleDependencyGraphTransformationContext;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.graph.transformer.ConflictIdSorter;
import org.eclipse.aether.util.graph.transformer.ConflictMarker;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.eclipse.aether.version.Version;

public class BootstrapAppModelResolver
implements AppModelResolver {
    protected final MavenArtifactResolver mvn;
    protected Consumer<String> buildTreeConsumer;
    protected boolean devmode;

    public BootstrapAppModelResolver(MavenArtifactResolver mvn) throws AppModelResolverException {
        this.mvn = mvn;
    }

    public void setBuildTreeLogger(Consumer<String> buildTreeConsumer) {
        this.buildTreeConsumer = buildTreeConsumer;
    }

    public BootstrapAppModelResolver setDevMode(boolean devmode) {
        this.devmode = devmode;
        return this;
    }

    public void addRemoteRepositories(List<RemoteRepository> repos) {
        this.mvn.addRemoteRepositories(repos);
    }

    @Override
    public void relink(AppArtifact artifact, Path path) throws AppModelResolverException {
        if (this.mvn.getLocalRepositoryManager() == null) {
            return;
        }
        this.mvn.getLocalRepositoryManager().relink(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion(), path);
        artifact.setPath(path);
    }

    @Override
    public Path resolve(AppArtifact artifact) throws AppModelResolverException {
        if (artifact.isResolved()) {
            return artifact.getPath();
        }
        Path path = this.mvn.resolve(BootstrapAppModelResolver.toAetherArtifact(artifact)).getArtifact().getFile().toPath();
        artifact.setPath(path);
        return path;
    }

    @Override
    public List<AppDependency> resolveUserDependencies(AppArtifact appArtifact, List<AppDependency> deps) throws AppModelResolverException {
        List<Dependency> mvnDeps;
        if (deps.isEmpty()) {
            mvnDeps = Collections.emptyList();
        } else {
            mvnDeps = new ArrayList(deps.size());
            for (AppDependency dep : deps) {
                mvnDeps.add(new Dependency(BootstrapAppModelResolver.toAetherArtifact(dep.getArtifact()), dep.getScope()));
            }
        }
        final ArrayList<AppDependency> result = new ArrayList<AppDependency>();
        TreeDependencyVisitor visitor = new TreeDependencyVisitor(new DependencyVisitor(){

            public boolean visitEnter(DependencyNode node) {
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                Dependency dep = node.getDependency();
                if (dep != null) {
                    result.add(new AppDependency(BootstrapAppModelResolver.toAppArtifact(dep.getArtifact()), dep.getScope(), dep.isOptional()));
                }
                return true;
            }
        });
        this.mvn.resolveDependencies(BootstrapAppModelResolver.toAetherArtifact(appArtifact), mvnDeps).getRoot().accept((DependencyVisitor)visitor);
        return result;
    }

    @Override
    public AppModel resolveModel(AppArtifact appArtifact) throws AppModelResolverException {
        return this.resolveManagedModel(appArtifact, Collections.emptyList(), null);
    }

    @Override
    public AppModel resolveModel(AppArtifact appArtifact, List<AppDependency> directDeps) throws AppModelResolverException {
        return this.resolveManagedModel(appArtifact, directDeps, null);
    }

    public AppModel resolveManagedModel(AppArtifact appArtifact, List<AppDependency> directDeps, AppArtifact managingProject) throws AppModelResolverException {
        return this.doResolveModel(appArtifact, BootstrapAppModelResolver.toAetherDeps(directDeps), managingProject);
    }

    private AppModel doResolveModel(AppArtifact appArtifact, List<Dependency> directMvnDeps, AppArtifact managingProject) throws AppModelResolverException {
        String[] stringArray;
        List managedDeps = Collections.emptyList();
        List<RemoteRepository> managedRepos = Collections.emptyList();
        if (managingProject != null) {
            ArtifactDescriptorResult managingDescr = this.mvn.resolveDescriptor(BootstrapAppModelResolver.toAetherArtifact(managingProject));
            managedDeps = managingDescr.getManagedDependencies();
            managedRepos = this.mvn.newResolutionRepositories(managingDescr.getRepositories());
        }
        Artifact artifact = BootstrapAppModelResolver.toAetherArtifact(appArtifact);
        if (this.devmode) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "test";
        } else {
            stringArray = new String[]{};
        }
        DependencyNode resolvedDeps = this.mvn.resolveManagedDependencies(artifact, directMvnDeps, (List<Dependency>)managedDeps, managedRepos, stringArray).getRoot();
        final HashSet<AppArtifactKey> appDeps = new HashSet<AppArtifactKey>();
        final ArrayList<AppDependency> userDeps = new ArrayList<AppDependency>();
        TreeDependencyVisitor visitor = new TreeDependencyVisitor(new DependencyVisitor(){

            public boolean visitEnter(DependencyNode node) {
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                Dependency dep = node.getDependency();
                if (dep != null) {
                    AppArtifact appArtifact = BootstrapAppModelResolver.toAppArtifact(dep.getArtifact());
                    appDeps.add(appArtifact.getKey());
                    userDeps.add(new AppDependency(appArtifact, dep.getScope(), dep.isOptional()));
                }
                return true;
            }
        });
        for (DependencyNode child : resolvedDeps.getChildren()) {
            child.accept((DependencyVisitor)visitor);
        }
        DeploymentInjectingDependencyVisitor deploymentInjector = new DeploymentInjectingDependencyVisitor(this.mvn, managedDeps, this.mvn.aggregateRepositories(managedRepos, this.mvn.newResolutionRepositories(this.mvn.resolveDescriptor(BootstrapAppModelResolver.toAetherArtifact(appArtifact)).getRepositories())));
        try {
            resolvedDeps.accept((DependencyVisitor)new TreeDependencyVisitor((DependencyVisitor)deploymentInjector));
        }
        catch (DeploymentInjectionException e) {
            throw new AppModelResolverException("Failed to inject extension deployment dependencies for " + resolvedDeps.getArtifact(), e.getCause());
        }
        List<AppDependency> deploymentDeps = Collections.emptyList();
        if (deploymentInjector.isInjectedDeps()) {
            SimpleDependencyGraphTransformationContext context = new SimpleDependencyGraphTransformationContext(this.mvn.getSession());
            try {
                resolvedDeps = new ConflictMarker().transformGraph(resolvedDeps, (DependencyGraphTransformationContext)context);
                resolvedDeps = new ConflictIdSorter().transformGraph(resolvedDeps, (DependencyGraphTransformationContext)context);
                resolvedDeps = this.mvn.getSession().getDependencyGraphTransformer().transformGraph(resolvedDeps, (DependencyGraphTransformationContext)context);
            }
            catch (RepositoryException e) {
                throw new AppModelResolverException("Failed to normalize the dependency graph", e);
            }
            BuildDependencyGraphVisitor buildDepsVisitor = new BuildDependencyGraphVisitor(appDeps, this.buildTreeConsumer);
            buildDepsVisitor.visit(resolvedDeps);
            List<ArtifactRequest> requests = buildDepsVisitor.getArtifactRequests();
            if (!requests.isEmpty()) {
                List<ArtifactResult> results = this.mvn.resolve(requests);
                for (ArtifactResult result : results) {
                    Artifact artifact2 = result.getArtifact();
                    if (artifact2 == null) continue;
                    result.getRequest().getDependencyNode().setArtifact(artifact2);
                }
                List<DependencyNode> deploymentDepNodes = buildDepsVisitor.getDeploymentNodes();
                deploymentDeps = new ArrayList<AppDependency>(deploymentDepNodes.size());
                for (DependencyNode dep : deploymentDepNodes) {
                    deploymentDeps.add(new AppDependency(BootstrapAppModelResolver.toAppArtifact(dep.getArtifact()), dep.getDependency().getScope(), dep.getDependency().isOptional()));
                }
            }
        }
        return new AppModel(appArtifact, userDeps, deploymentDeps);
    }

    @Override
    public List<String> listLaterVersions(AppArtifact appArtifact, String upToVersion, boolean inclusive) throws AppModelResolverException {
        VersionRangeResult rangeResult = this.resolveVersionRangeResult(appArtifact, appArtifact.getVersion(), false, upToVersion, inclusive);
        List resolvedVersions = rangeResult.getVersions();
        ArrayList<String> versions = new ArrayList<String>(resolvedVersions.size());
        for (Version v : resolvedVersions) {
            versions.add(v.toString());
        }
        return versions;
    }

    @Override
    public String getNextVersion(AppArtifact appArtifact, String fromVersion, boolean fromVersionIncluded, String upToVersion, boolean upToVersionInclusive) throws AppModelResolverException {
        VersionRangeResult rangeResult = this.resolveVersionRangeResult(appArtifact, fromVersion, fromVersionIncluded, upToVersion, upToVersionInclusive);
        List versions = rangeResult.getVersions();
        if (versions.isEmpty()) {
            return null;
        }
        Version next = (Version)versions.get(0);
        for (int i = 1; i < versions.size(); ++i) {
            Version candidate = (Version)versions.get(i);
            if (next.compareTo((Object)candidate) <= 0) continue;
            next = candidate;
        }
        return next.toString();
    }

    @Override
    public String getLatestVersion(AppArtifact appArtifact, String upToVersion, boolean inclusive) throws AppModelResolverException {
        VersionRangeResult rangeResult = this.resolveVersionRangeResult(appArtifact, appArtifact.getVersion(), false, upToVersion, inclusive);
        List versions = rangeResult.getVersions();
        if (versions.isEmpty()) {
            return appArtifact.getVersion();
        }
        Version latest = (Version)versions.get(0);
        for (int i = 1; i < versions.size(); ++i) {
            Version candidate = (Version)versions.get(i);
            if (latest.compareTo((Object)candidate) >= 0) continue;
            latest = candidate;
        }
        return latest.toString();
    }

    public List<RemoteRepository> resolveArtifactRepos(AppArtifact appArtifact) throws AppModelResolverException {
        return this.mvn.resolveDescriptor(BootstrapAppModelResolver.toAetherArtifact(appArtifact)).getRepositories();
    }

    public void install(AppArtifact appArtifact, Path localPath) throws AppModelResolverException {
        this.mvn.install((Artifact)new DefaultArtifact(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getClassifier(), appArtifact.getType(), appArtifact.getVersion(), Collections.emptyMap(), localPath.toFile()));
    }

    private VersionRangeResult resolveVersionRangeResult(AppArtifact appArtifact, String fromVersion, boolean fromVersionIncluded, String upToVersion, boolean upToVersionIncluded) throws AppModelResolverException {
        return this.mvn.resolveVersionRange((Artifact)new DefaultArtifact(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getType(), (fromVersionIncluded ? (char)'[' : '(') + fromVersion + ',' + (upToVersion == null ? Character.valueOf(')') : upToVersion + (upToVersionIncluded ? (char)']' : ')'))));
    }

    static List<AppDependency> toAppDepList(DependencyNode rootNode) {
        List depNodes = rootNode.getChildren();
        if (depNodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AppDependency> appDeps = new ArrayList<AppDependency>();
        BootstrapAppModelResolver.collect(depNodes, appDeps);
        return appDeps;
    }

    private static void collect(List<DependencyNode> nodes, List<AppDependency> appDeps) {
        for (DependencyNode node : nodes) {
            BootstrapAppModelResolver.collect(node.getChildren(), appDeps);
            Dependency dep = node.getDependency();
            appDeps.add(new AppDependency(BootstrapAppModelResolver.toAppArtifact(node.getArtifact()), dep.getScope(), dep.isOptional()));
        }
    }

    private static Artifact toAetherArtifact(AppArtifact artifact) {
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion());
    }

    private static AppArtifact toAppArtifact(Artifact artifact) {
        AppArtifact appArtifact = new AppArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getVersion());
        File file = artifact.getFile();
        if (file != null) {
            appArtifact.setPath(file.toPath());
        }
        return appArtifact;
    }

    private static List<Dependency> toAetherDeps(List<AppDependency> directDeps) {
        if (directDeps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> directMvnDeps = new ArrayList<Dependency>(directDeps.size());
        for (AppDependency dep : directDeps) {
            directMvnDeps.add(new Dependency(BootstrapAppModelResolver.toAetherArtifact(dep.getArtifact()), dep.getScope()));
        }
        return directMvnDeps;
    }
}

