/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.DeploymentInjectionException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.util.ZipUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.logging.Logger;

public class DeploymentInjectingDependencyVisitor
implements DependencyVisitor {
    private static final Logger log = Logger.getLogger(DeploymentInjectingDependencyVisitor.class);
    static final String INJECTED_DEPENDENCY = "injected.dep";
    private final MavenArtifactResolver resolver;
    private final List<Dependency> managedDeps;
    private final List<RemoteRepository> mainRepos;
    private DependencyNode node;
    boolean injectedDeps;

    public static Artifact getInjectedDependency(DependencyNode dep) {
        return (Artifact)dep.getData().get(INJECTED_DEPENDENCY);
    }

    public DeploymentInjectingDependencyVisitor(MavenArtifactResolver resolver, List<Dependency> managedDeps, List<RemoteRepository> mainRepos) {
        this.resolver = resolver;
        this.managedDeps = managedDeps;
        this.mainRepos = mainRepos;
    }

    public boolean isInjectedDeps() {
        return this.injectedDeps;
    }

    public boolean visitEnter(DependencyNode node) {
        boolean processChildren;
        block16: {
            Artifact artifact = node.getArtifact();
            if (!artifact.getExtension().equals("jar")) {
                return true;
            }
            this.node = node;
            processChildren = true;
            Path path = this.resolve(artifact);
            try {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    processChildren = !this.processMetaInfDir(path.resolve("META-INF"));
                    break block16;
                }
                try (FileSystem artifactFs = ZipUtils.newFileSystem(path);){
                    processChildren = !this.processMetaInfDir(artifactFs.getPath("META-INF", new String[0]));
                }
            }
            catch (Throwable t) {
                throw new DeploymentInjectionException("Failed to inject extension deplpyment dependencies", t);
            }
        }
        return processChildren;
    }

    public boolean visitLeave(DependencyNode node) {
        return true;
    }

    private boolean processMetaInfDir(Path metaInfDir) throws BootstrapDependencyProcessingException {
        if (!Files.exists(metaInfDir, new LinkOption[0])) {
            return false;
        }
        Path p = metaInfDir.resolve("quarkus-extension.properties");
        if (!Files.exists(p, new LinkOption[0])) {
            return false;
        }
        this.processPlatformArtifact(p);
        return true;
    }

    private void processPlatformArtifact(Path descriptor) throws BootstrapDependencyProcessingException {
        Properties rtProps = this.resolveDescriptor(descriptor);
        if (rtProps == null) {
            return;
        }
        log.debugf("Processing Quarkus extension %s", (Object)this.node);
        String value = rtProps.getProperty("deployment-artifact");
        if (value != null) {
            this.replaceWith(this.collectDependencies(DeploymentInjectingDependencyVisitor.toArtifact(value)));
        }
    }

    private void replaceWith(DependencyNode depNode) throws BootstrapDependencyProcessingException {
        List children = depNode.getChildren();
        if (children.isEmpty()) {
            throw new BootstrapDependencyProcessingException("No dependencies collected for Quarkus extension deployment artifact " + depNode.getArtifact() + " while at least the corresponding runtime artifact " + this.node.getArtifact() + " is expected");
        }
        log.debugf("Injecting deployment dependency %s", (Object)depNode);
        this.node.setData((Object)INJECTED_DEPENDENCY, (Object)this.node.getArtifact());
        this.node.setArtifact(depNode.getArtifact());
        this.node.getDependency().setArtifact(depNode.getArtifact());
        this.node.setChildren(children);
        this.injectedDeps = true;
    }

    private DependencyNode collectDependencies(Artifact artifact) throws BootstrapDependencyProcessingException {
        if (artifact.getVersion().isEmpty()) {
            artifact = artifact.setVersion(this.node.getArtifact().getVersion());
        }
        try {
            return this.managedDeps.isEmpty() ? this.resolver.collectDependencies(artifact, Collections.emptyList(), this.mainRepos).getRoot() : this.resolver.collectManagedDependencies(artifact, Collections.emptyList(), this.managedDeps, this.mainRepos, new String[0]).getRoot();
        }
        catch (AppModelResolverException e) {
            throw new DeploymentInjectionException(e);
        }
    }

    private Path resolve(Artifact artifact) {
        File file = artifact.getFile();
        if (file != null) {
            return file.toPath();
        }
        try {
            return this.resolver.resolve(artifact).getArtifact().getFile().toPath();
        }
        catch (AppModelResolverException e) {
            throw new DeploymentInjectionException(e);
        }
    }

    private Properties resolveDescriptor(Path path) throws BootstrapDependencyProcessingException {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        Properties rtProps = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            rtProps.load(reader);
        }
        catch (IOException e) {
            throw new BootstrapDependencyProcessingException("Failed to load " + path, e);
        }
        return rtProps;
    }

    public static Artifact toArtifact(String str) {
        return DeploymentInjectingDependencyVisitor.toArtifact(str, 0);
    }

    private static Artifact toArtifact(String str, int offset) {
        String groupId = null;
        String artifactId = null;
        String classifier = "";
        String type = "jar";
        String version = null;
        int colon = str.indexOf(58, offset);
        int length = str.length();
        if (colon < offset + 1 || colon == length - 1) {
            DeploymentInjectingDependencyVisitor.illegalDependencyFormat(str);
        }
        groupId = str.substring(offset, colon);
        offset = colon + 1;
        if ((colon = str.indexOf(58, offset)) < 0) {
            artifactId = str.substring(offset, length);
        } else {
            if (colon == length - 1) {
                DeploymentInjectingDependencyVisitor.illegalDependencyFormat(str);
            }
            artifactId = str.substring(offset, colon);
            offset = colon + 1;
            if ((colon = str.indexOf(58, offset)) < 0) {
                version = str.substring(offset, length);
            } else {
                if (colon == length - 1) {
                    DeploymentInjectingDependencyVisitor.illegalDependencyFormat(str);
                }
                type = str.substring(offset, colon);
                offset = colon + 1;
                if ((colon = str.indexOf(58, offset)) < 0) {
                    version = str.substring(offset, length);
                } else {
                    if (colon == length - 1) {
                        DeploymentInjectingDependencyVisitor.illegalDependencyFormat(str);
                    }
                    classifier = type;
                    type = str.substring(offset, colon);
                    version = str.substring(colon + 1);
                }
            }
        }
        return new DefaultArtifact(groupId, artifactId, classifier, type, version);
    }

    private static void illegalDependencyFormat(String str) {
        throw new IllegalArgumentException("Bad artifact coordinates " + str + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
    }
}

