/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.app;

import io.quarkus.bootstrap.BootstrapAppModelFactory;
import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.CurationResult;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.update.DependenciesOrigin;
import io.quarkus.bootstrap.resolver.update.VersionUpdate;
import io.quarkus.bootstrap.resolver.update.VersionUpdateNumber;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class QuarkusBootstrap
implements Serializable {
    private final Path applicationRoot;
    private final Path projectRoot;
    private final List<AdditionalDependency> additionalApplicationArchives;
    private final List<Path> additionalDeploymentArchives;
    private final List<Path> excludeFromClassPath;
    private final Properties buildSystemProperties;
    private final String baseName;
    private final Path targetDirectory;
    private final Mode mode;
    private final boolean offline;
    private final boolean test;
    private final Boolean localProjectDiscovery;
    private final ClassLoader baseClassLoader;
    private final AppModelResolver appModelResolver;
    private final VersionUpdateNumber versionUpdateNumber;
    private final VersionUpdate versionUpdate;
    private final DependenciesOrigin dependenciesOrigin;
    private final AppArtifact appArtifact;
    private final boolean isolateDeployment;
    private final MavenArtifactResolver mavenArtifactResolver;
    private final AppArtifact managingProject;
    private final List<AppDependency> forcedDependencies;

    private QuarkusBootstrap(Builder builder) {
        this.applicationRoot = builder.applicationRoot;
        this.additionalApplicationArchives = new ArrayList<AdditionalDependency>(builder.additionalApplicationArchives);
        this.excludeFromClassPath = new ArrayList<Path>(builder.excludeFromClassPath);
        this.projectRoot = builder.projectRoot != null ? builder.projectRoot.normalize() : null;
        this.buildSystemProperties = builder.buildSystemProperties;
        this.mode = builder.mode;
        this.offline = builder.offline;
        this.test = builder.test;
        this.localProjectDiscovery = builder.localProjectDiscovery;
        this.baseName = builder.baseName;
        this.baseClassLoader = builder.baseClassLoader;
        this.targetDirectory = builder.targetDirectory;
        this.appModelResolver = builder.appModelResolver;
        this.versionUpdate = builder.versionUpdate;
        this.versionUpdateNumber = builder.versionUpdateNumber;
        this.dependenciesOrigin = builder.dependenciesOrigin;
        this.appArtifact = builder.appArtifact;
        this.isolateDeployment = builder.isolateDeployment;
        this.additionalDeploymentArchives = builder.additionalDeploymentArchives;
        this.mavenArtifactResolver = builder.mavenArtifactResolver;
        this.managingProject = builder.managingProject;
        this.forcedDependencies = new ArrayList<AppDependency>(builder.forcedDependencies);
    }

    public CuratedApplication bootstrap() throws BootstrapException {
        if (this.mode != Mode.PROD && this.versionUpdate != VersionUpdate.NONE) {
            throw new BootstrapException("updates are only supported for PROD mode for existing files, not for dev or test");
        }
        BootstrapAppModelFactory appModelFactory = BootstrapAppModelFactory.newInstance().setOffline(this.offline).setMavenArtifactResolver(this.mavenArtifactResolver).setBootstrapAppModelResolver(this.appModelResolver).setVersionUpdate(this.versionUpdate).setVersionUpdateNumber(this.versionUpdateNumber).setDependenciesOrigin(this.dependenciesOrigin).setLocalProjectsDiscovery(this.localProjectDiscovery).setAppArtifact(this.appArtifact).setManagingProject(this.managingProject).setForcedDependencies(this.forcedDependencies).setAppClasses(this.getProjectRoot() != null ? this.getProjectRoot() : this.getApplicationRoot());
        if (this.mode == Mode.TEST || this.test) {
            appModelFactory.setTest(true);
            appModelFactory.setEnableClasspathCache(true);
        }
        if (this.mode == Mode.DEV) {
            appModelFactory.setDevMode(true);
            appModelFactory.setEnableClasspathCache(true);
        }
        CurationResult model = appModelFactory.resolveAppModel();
        return new CuratedApplication(this, model);
    }

    public AppModelResolver getAppModelResolver() {
        return this.appModelResolver;
    }

    public Path getApplicationRoot() {
        return this.applicationRoot;
    }

    public List<AdditionalDependency> getAdditionalApplicationArchives() {
        return Collections.unmodifiableList(this.additionalApplicationArchives);
    }

    public List<Path> getAdditionalDeploymentArchives() {
        return Collections.unmodifiableList(this.additionalDeploymentArchives);
    }

    public List<Path> getExcludeFromClassPath() {
        return Collections.unmodifiableList(this.excludeFromClassPath);
    }

    public Properties getBuildSystemProperties() {
        return this.buildSystemProperties;
    }

    public Path getProjectRoot() {
        return this.projectRoot;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public static Builder builder(Path applicationRoot) {
        return new Builder(applicationRoot);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public ClassLoader getBaseClassLoader() {
        return this.baseClassLoader;
    }

    public Path getTargetDirectory() {
        return this.targetDirectory;
    }

    public boolean isIsolateDeployment() {
        return this.isolateDeployment;
    }

    public static enum Mode {
        DEV,
        TEST,
        PROD;

    }

    public static class Builder {
        final Path applicationRoot;
        String baseName;
        Path projectRoot;
        ClassLoader baseClassLoader = ClassLoader.getSystemClassLoader();
        final List<AdditionalDependency> additionalApplicationArchives = new ArrayList<AdditionalDependency>();
        final List<Path> additionalDeploymentArchives = new ArrayList<Path>();
        final List<Path> excludeFromClassPath = new ArrayList<Path>();
        Properties buildSystemProperties;
        Mode mode = Mode.PROD;
        boolean offline;
        boolean test;
        Boolean localProjectDiscovery;
        Path targetDirectory;
        AppModelResolver appModelResolver;
        VersionUpdateNumber versionUpdateNumber = VersionUpdateNumber.MICRO;
        VersionUpdate versionUpdate = VersionUpdate.NONE;
        DependenciesOrigin dependenciesOrigin;
        AppArtifact appArtifact;
        boolean isolateDeployment;
        MavenArtifactResolver mavenArtifactResolver;
        AppArtifact managingProject;
        List<AppDependency> forcedDependencies = new ArrayList<AppDependency>();

        public Builder(Path applicationRoot) {
            this.applicationRoot = applicationRoot;
        }

        public Builder addAdditionalApplicationArchive(AdditionalDependency path) {
            this.additionalApplicationArchives.add(path);
            return this;
        }

        public Builder addAdditionalDeploymentArchive(Path path) {
            this.additionalDeploymentArchives.add(path);
            return this;
        }

        public Builder addExcludedPath(Path path) {
            this.excludeFromClassPath.add(path);
            return this;
        }

        public Builder setProjectRoot(Path projectRoot) {
            this.projectRoot = projectRoot;
            return this;
        }

        public Builder setBuildSystemProperties(Properties buildSystemProperties) {
            this.buildSystemProperties = buildSystemProperties;
            return this;
        }

        public Builder setOffline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder setTest(boolean test) {
            this.test = test;
            return this;
        }

        public Builder setMode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder setLocalProjectDiscovery(boolean localProjectDiscovery) {
            this.localProjectDiscovery = localProjectDiscovery;
            return this;
        }

        public Builder setBaseName(String baseName) {
            this.baseName = baseName;
            return this;
        }

        public Builder setBaseClassLoader(ClassLoader baseClassLoader) {
            this.baseClassLoader = baseClassLoader;
            return this;
        }

        public Builder setTargetDirectory(Path targetDirectory) {
            this.targetDirectory = targetDirectory;
            return this;
        }

        public Builder setAppModelResolver(AppModelResolver appModelResolver) {
            this.appModelResolver = appModelResolver;
            return this;
        }

        public Builder setVersionUpdateNumber(VersionUpdateNumber versionUpdateNumber) {
            this.versionUpdateNumber = versionUpdateNumber;
            return this;
        }

        public Builder setVersionUpdate(VersionUpdate versionUpdate) {
            this.versionUpdate = versionUpdate;
            return this;
        }

        public Builder setDependenciesOrigin(DependenciesOrigin dependenciesOrigin) {
            this.dependenciesOrigin = dependenciesOrigin;
            return this;
        }

        public Builder setAppArtifact(AppArtifact appArtifact) {
            this.appArtifact = appArtifact;
            return this;
        }

        public Builder setManagingProject(AppArtifact managingProject) {
            this.managingProject = managingProject;
            return this;
        }

        public Builder setIsolateDeployment(boolean isolateDeployment) {
            this.isolateDeployment = isolateDeployment;
            return this;
        }

        public Builder setMavenArtifactResolver(MavenArtifactResolver mavenArtifactResolver) {
            this.mavenArtifactResolver = mavenArtifactResolver;
            return this;
        }

        public Builder setForcedDependencies(List<AppDependency> forcedDependencies) {
            this.forcedDependencies = forcedDependencies;
            return this;
        }

        public QuarkusBootstrap build() {
            return new QuarkusBootstrap(this);
        }
    }
}

