/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloading;

import io.quarkus.bootstrap.classloading.AbstractClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathResource;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class DirectoryClassPathElement
extends AbstractClassPathElement {
    private final Path root;

    public DirectoryClassPathElement(Path root) {
        assert (root != null) : "root is null";
        this.root = root;
    }

    @Override
    public ClassPathResource getResource(final String name) {
        final Path file = this.root.resolve(name);
        if (Files.exists(file, new LinkOption[0])) {
            return new ClassPathResource(){

                @Override
                public ClassPathElement getContainingElement() {
                    return DirectoryClassPathElement.this;
                }

                @Override
                public String getPath() {
                    return name;
                }

                @Override
                public URL getUrl() {
                    try {
                        return file.toUri().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public byte[] getData() {
                    try {
                        return Files.readAllBytes(file);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to read " + file, e);
                    }
                }
            };
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getProvidedResources() {
        try (Stream<Path> files = Files.walk(this.root, new FileVisitOption[0]);){
            final HashSet<String> paths = new HashSet<String>();
            files.forEach(new Consumer<Path>(){

                @Override
                public void accept(Path path) {
                    if (!path.equals(DirectoryClassPathElement.this.root)) {
                        String st = DirectoryClassPathElement.this.root.relativize(path).toString();
                        if (!path.getFileSystem().getSeparator().equals("/")) {
                            st = st.replace(path.getFileSystem().getSeparator(), "/");
                        }
                        paths.add(st);
                    }
                }
            });
            HashSet<String> hashSet = paths;
            return hashSet;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ProtectionDomain getProtectionDomain(ClassLoader classLoader) {
        URL url = null;
        try {
            URI uri = this.root.toUri();
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to create protection domain for " + this.root, e);
        }
        CodeSource codesource = new CodeSource(url, (Certificate[])null);
        ProtectionDomain protectionDomain = new ProtectionDomain(codesource, null, classLoader, null);
        return protectionDomain;
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return this.root.toAbsolutePath().toString();
    }
}

