/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime.augmented;

import io.quarkus.arc.runtime.InterceptorBindings;
import io.quarkus.cache.CacheKey;
import io.quarkus.cache.runtime.CacheKeyBuilder;
import io.quarkus.cache.runtime.CacheRepository;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;

public abstract class AugmentedCacheAnnotationInterceptor {
    @Inject
    CacheRepository cacheRepository;

    protected <T> T getCacheAnnotation(InvocationContext context, Class<T> cacheAnnotationClass) {
        for (Annotation annotation : InterceptorBindings.getInterceptorBindings((InvocationContext)context)) {
            if (!cacheAnnotationClass.isInstance(annotation)) continue;
            return (T)annotation;
        }
        throw new IllegalStateException("Unable to find the cache annotation");
    }

    protected Object getCacheKey(InvocationContext context, String cacheName) {
        if (context.getParameters().length == 0) {
            return CacheKeyBuilder.buildDefault(cacheName);
        }
        ArrayList<Object> cacheKeyElements = new ArrayList<Object>();
        for (int i = 0; i < context.getParameters().length; ++i) {
            if (!context.getMethod().getParameters()[i].isAnnotationPresent(CacheKey.class)) continue;
            cacheKeyElements.add(context.getParameters()[i]);
        }
        if (cacheKeyElements.isEmpty()) {
            cacheKeyElements.addAll(Arrays.asList(context.getParameters()));
        }
        return CacheKeyBuilder.build(cacheKeyElements);
    }
}

