/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime.augmented;

import io.quarkus.cache.runtime.augmented.AugmentedCacheAnnotationInterceptor;
import io.quarkus.cache.runtime.augmented.AugmentedCacheInvalidateAll;
import io.quarkus.cache.runtime.caffeine.CaffeineCache;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@AugmentedCacheInvalidateAll
@Interceptor
@Priority(value=0)
public class AugmentedCacheInvalidateAllInterceptor
extends AugmentedCacheAnnotationInterceptor {
    private static final Logger LOGGER = Logger.getLogger(AugmentedCacheInvalidateAllInterceptor.class);

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        AugmentedCacheInvalidateAll annotation = this.getCacheAnnotation(context, AugmentedCacheInvalidateAll.class);
        CaffeineCache cache = this.cacheRepository.getCache(annotation.cacheName());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugf("Invalidating all entries from cache [%s]", (Object)cache.getName());
        }
        cache.invalidateAll();
        return context.proceed();
    }
}

