/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime.augmented;

import io.quarkus.cache.runtime.augmented.AugmentedCacheAnnotationInterceptor;
import io.quarkus.cache.runtime.augmented.AugmentedCacheResult;
import io.quarkus.cache.runtime.caffeine.CaffeineCache;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@AugmentedCacheResult
@Interceptor
@Priority(value=0)
public class AugmentedCacheResultInterceptor
extends AugmentedCacheAnnotationInterceptor {
    private static final Logger LOGGER = Logger.getLogger(AugmentedCacheResultInterceptor.class);

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        AugmentedCacheResult annotation = this.getCacheAnnotation(context, AugmentedCacheResult.class);
        CaffeineCache cache = this.cacheRepository.getCache(annotation.cacheName());
        Object key = this.getCacheKey(context, cache.getName());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugf("Loading entry with key [%s] from cache [%s]", key, (Object)cache.getName());
        }
        return cache.get(key, () -> context.proceed(), annotation.lockTimeout());
    }
}

