/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.CacheManager;
import io.quarkus.cache.runtime.CacheConfig;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheManagerBuilder;
import io.quarkus.cache.runtime.noop.NoOpCacheManagerBuilder;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.DeploymentException;

@Recorder
public class CacheManagerRecorder {
    private final CacheConfig cacheConfig;

    public CacheManagerRecorder(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    public Supplier<CacheManager> getCacheManagerSupplierWithMicrometerMetrics(final Set<String> cacheNames) {
        Supplier<Supplier<CacheManager>> caffeineCacheManagerSupplier = new Supplier<Supplier<CacheManager>>(){

            @Override
            public Supplier<CacheManager> get() {
                return CaffeineCacheManagerBuilder.buildWithMicrometerMetrics(cacheNames, CacheManagerRecorder.this.cacheConfig);
            }
        };
        return this.getCacheManagerSupplier(cacheNames, caffeineCacheManagerSupplier);
    }

    public Supplier<CacheManager> getCacheManagerSupplierWithoutMetrics(final Set<String> cacheNames) {
        Supplier<Supplier<CacheManager>> caffeineCacheManagerSupplier = new Supplier<Supplier<CacheManager>>(){

            @Override
            public Supplier<CacheManager> get() {
                return CaffeineCacheManagerBuilder.buildWithoutMetrics(cacheNames, CacheManagerRecorder.this.cacheConfig);
            }
        };
        return this.getCacheManagerSupplier(cacheNames, caffeineCacheManagerSupplier);
    }

    private Supplier<CacheManager> getCacheManagerSupplier(Set<String> cacheNames, Supplier<Supplier<CacheManager>> caffeineCacheManagerSupplier) {
        if (this.cacheConfig.enabled) {
            switch (this.cacheConfig.type) {
                case "caffeine": {
                    return caffeineCacheManagerSupplier.get();
                }
            }
            throw new DeploymentException("Unknown cache type: " + this.cacheConfig.type);
        }
        return NoOpCacheManagerBuilder.build(cacheNames);
    }
}

