/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem.nativeimage;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.ArrayList;
import java.util.List;

public final class JniRuntimeAccessBuildItem
extends MultiBuildItem {
    private final List<String> className;
    private final boolean constructors;
    private final boolean methods;
    private final boolean fields;
    private final boolean finalFieldsWriteable;

    public JniRuntimeAccessBuildItem(boolean constructors, boolean methods, boolean fields, Class<?> ... classes) {
        this(constructors, methods, fields, false, classes);
    }

    public JniRuntimeAccessBuildItem(boolean constructors, boolean methods, boolean fields, boolean finalFieldsWriteable, Class<?> ... classes) {
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> i : classes) {
            if (i == null) {
                throw new NullPointerException();
            }
            names.add(i.getName());
        }
        this.className = names;
        this.constructors = constructors;
        this.methods = methods;
        this.fields = fields;
        this.finalFieldsWriteable = finalFieldsWriteable;
    }

    public List<String> getClassNames() {
        return this.className;
    }

    public boolean isConstructors() {
        return this.constructors;
    }

    public boolean isMethods() {
        return this.methods;
    }

    public boolean isFields() {
        return this.fields;
    }

    public boolean isFinalFieldsWriteable() {
        return this.finalFieldsWriteable;
    }
}

