/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.index;

import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.ApplicationArchiveImpl;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveBuildItem;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.index.ArtifactIndex;
import io.quarkus.deployment.index.ClassPathArtifactResolver;
import io.quarkus.deployment.index.IndexDependencyConfig;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class ApplicationArchiveBuildStep {
    private static final Logger LOGGER = Logger.getLogger(ApplicationArchiveBuildStep.class);
    private static final String JANDEX_INDEX = "META-INF/jandex.idx";
    private static final int REQUIRED_INDEX_VERSION = 8;
    IndexDependencyConfiguration config;

    @BuildStep
    void addConfiguredIndexedDependencies(BuildProducer<IndexDependencyBuildItem> indexDependencyBuildItemBuildProducer) {
        for (IndexDependencyConfig indexDependencyConfig : this.config.indexDependency.values()) {
            indexDependencyBuildItemBuildProducer.produce(new IndexDependencyBuildItem(indexDependencyConfig.groupId, indexDependencyConfig.artifactId, indexDependencyConfig.classifier.orElse(null)));
        }
    }

    @BuildStep(loadsApplicationClasses=true)
    ApplicationArchivesBuildItem build(ArchiveRootBuildItem root, ApplicationIndexBuildItem appindex, List<AdditionalApplicationArchiveMarkerBuildItem> appMarkers, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchiveBuildItem, List<IndexDependencyBuildItem> indexDependencyBuildItems, LiveReloadBuildItem liveReloadContext) throws IOException {
        HashSet<String> markerFiles = new HashSet<String>();
        for (AdditionalApplicationArchiveMarkerBuildItem i : appMarkers) {
            markerFiles.add(i.getFile());
        }
        IndexCache indexCache = liveReloadContext.getContextObject(IndexCache.class);
        if (indexCache == null) {
            indexCache = new IndexCache();
            liveReloadContext.setContextObject(IndexCache.class, indexCache);
        }
        List<ApplicationArchive> applicationArchives = this.scanForOtherIndexes(Thread.currentThread().getContextClassLoader(), markerFiles, root, additionalApplicationArchiveBuildItem, indexDependencyBuildItems, indexCache);
        return new ApplicationArchivesBuildItem(new ApplicationArchiveImpl((IndexView)appindex.getIndex(), root.getArchiveRoot(), null, false, root.getArchiveLocation()), applicationArchives);
    }

    private List<ApplicationArchive> scanForOtherIndexes(ClassLoader classLoader, Set<String> applicationArchiveFiles, ArchiveRootBuildItem root, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchives, List<IndexDependencyBuildItem> indexDependencyBuildItem, IndexCache indexCache) throws IOException {
        HashSet<Path> dependenciesToIndex = new HashSet<Path>();
        dependenciesToIndex.addAll(this.getIndexDependencyPaths(indexDependencyBuildItem, classLoader, root));
        HashSet<String> markers = new HashSet<String>(applicationArchiveFiles);
        markers.add(JANDEX_INDEX);
        dependenciesToIndex.addAll(ApplicationArchiveBuildStep.getMarkerFilePaths(classLoader, markers, root));
        dependenciesToIndex.remove(root.getArchiveLocation());
        for (AdditionalApplicationArchiveBuildItem i : additionalApplicationArchives) {
            dependenciesToIndex.add(i.getPath());
        }
        return ApplicationArchiveBuildStep.indexPaths(dependenciesToIndex, classLoader, indexCache);
    }

    public List<Path> getIndexDependencyPaths(List<IndexDependencyBuildItem> indexDependencyBuildItems, ClassLoader classLoader, ArchiveRootBuildItem root) {
        ArtifactIndex artifactIndex = new ArtifactIndex(new ClassPathArtifactResolver(classLoader));
        try {
            ArrayList<Path> ret = new ArrayList<Path>();
            for (IndexDependencyBuildItem indexDependencyBuildItem : indexDependencyBuildItems) {
                String classifier = indexDependencyBuildItem.getClassifier();
                Path path = classifier == null || classifier.isEmpty() ? artifactIndex.getPath(indexDependencyBuildItem.getGroupId(), indexDependencyBuildItem.getArtifactId(), null) : artifactIndex.getPath(indexDependencyBuildItem.getGroupId(), indexDependencyBuildItem.getArtifactId(), classifier);
                if (root.isExcludedFromIndexing(path)) continue;
                ret.add(path);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<ApplicationArchive> indexPaths(Set<Path> dependenciesToIndex, ClassLoader classLoader, IndexCache indexCache) throws IOException {
        ArrayList<ApplicationArchive> ret = new ArrayList<ApplicationArchive>();
        for (Path dep : dependenciesToIndex) {
            LOGGER.debugf("Indexing dependency: %s", (Object)dep);
            if (Files.isDirectory(dep, new LinkOption[0])) {
                Index indexView = ApplicationArchiveBuildStep.handleFilePath(dep);
                ret.add(new ApplicationArchiveImpl((IndexView)indexView, dep, null, false, dep));
                continue;
            }
            Index index = ApplicationArchiveBuildStep.handleJarPath(dep, indexCache);
            FileSystem fs = FileSystems.newFileSystem(dep, classLoader);
            ret.add(new ApplicationArchiveImpl((IndexView)index, fs.getRootDirectories().iterator().next(), fs, true, dep));
        }
        return ret;
    }

    private static Collection<? extends Path> getMarkerFilePaths(ClassLoader classLoader, Set<String> applicationArchiveFiles, ArchiveRootBuildItem root) throws IOException {
        ArrayList<Path> ret = new ArrayList<Path>();
        for (String file : applicationArchiveFiles) {
            Enumeration<URL> e = classLoader.getResources(file);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                Path path = ApplicationArchiveBuildStep.urlToPath(url, file);
                if (root.isExcludedFromIndexing(path)) continue;
                ret.add(path);
            }
        }
        return ret;
    }

    static Path urlToPath(URL url, String resource) {
        try {
            if (url.getProtocol().equals("jar")) {
                String jarPath = url.getPath().substring(0, url.getPath().lastIndexOf(33));
                return Paths.get(new URI(jarPath));
            }
            if (url.getProtocol().equals("file")) {
                int index;
                Path path = Paths.get(url.toURI());
                if (resource.isEmpty()) {
                    return path;
                }
                String filePath = path.toString();
                if (File.separatorChar != '/') {
                    resource = resource.replace('/', File.separatorChar);
                }
                if ((index = filePath.lastIndexOf(File.separator + resource)) == -1) {
                    return path;
                }
                return Paths.get(filePath.substring(0, index), new String[0]);
            }
            throw new RuntimeException("Unknown URL type " + url.getProtocol());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static Index handleFilePath(Path path) throws IOException {
        Path existing = path.resolve(JANDEX_INDEX);
        if (Files.exists(existing, new LinkOption[0])) {
            try (FileInputStream in = new FileInputStream(existing.toFile());){
                IndexReader reader = new IndexReader((InputStream)in);
                if (reader.getIndexVersion() < 8) {
                    LOGGER.warnf("Re-indexing %s - at least Jandex 2.1 must be used to index an application dependency", (Object)path);
                    Index index = ApplicationArchiveBuildStep.indexFilePath(path);
                    return index;
                }
                Index index = reader.read();
                return index;
            }
        }
        return ApplicationArchiveBuildStep.indexFilePath(path);
    }

    private static Index indexFilePath(Path path) throws IOException {
        Indexer indexer = new Indexer();
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.forEach(path1 -> {
                if (path1.toString().endsWith(".class")) {
                    try (FileInputStream in = new FileInputStream(path1.toFile());){
                        indexer.index((InputStream)in);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return indexer.complete();
    }

    private static Index handleJarPath(Path path, IndexCache indexCache) throws IOException {
        return indexCache.cache.computeIfAbsent(path, new Function<Path, Index>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Index apply(Path path) {
                try (JarFile file = new JarFile(path.toFile());){
                    ZipEntry existing = file.getEntry(ApplicationArchiveBuildStep.JANDEX_INDEX);
                    if (existing != null) {
                        try (InputStream in = file.getInputStream(existing);){
                            IndexReader reader = new IndexReader(in);
                            if (reader.getIndexVersion() < 8) {
                                LOGGER.warnf("Re-indexing %s - at least Jandex 2.1 must be used to index an application dependency", (Object)path);
                                Index index = ApplicationArchiveBuildStep.indexJar(file);
                                return index;
                            }
                            Index index = reader.read();
                            return index;
                        }
                    }
                    Index index = ApplicationArchiveBuildStep.indexJar(file);
                    return index;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to process " + path, e);
                }
            }
        });
    }

    private static Index indexJar(JarFile file) throws IOException {
        Indexer indexer = new Indexer();
        Enumeration<JarEntry> e = file.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            InputStream inputStream = file.getInputStream(entry);
            Throwable throwable = null;
            try {
                indexer.index(inputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        return indexer.complete();
    }

    private static final class IndexCache {
        final Map<Path, Index> cache = new HashMap<Path, Index>();

        private IndexCache() {
        }
    }

    @ConfigRoot(phase=ConfigPhase.BUILD_TIME)
    static final class IndexDependencyConfiguration {
        @ConfigItem(name="<<parent>>")
        Map<String, IndexDependencyConfig> indexDependency;

        IndexDependencyConfiguration() {
        }
    }
}

