/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.devtools.codestarts.CodestartProjectDefinition;
import io.quarkus.devtools.codestarts.CodestartType;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartCatalog;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartData;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartProjectInput;
import io.quarkus.devtools.commands.CreateProject;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandlers;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.tools.ToolsUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class CreateProjectCommandHandler
implements QuarkusCommandHandler {
    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        List<AppArtifactCoords> extensionsToAdd;
        QuarkusPlatformDescriptor platformDescr = invocation.getPlatformDescriptor();
        invocation.setValue("bom_groupId", platformDescr.getBomGroupId());
        invocation.setValue("bom_artifactId", platformDescr.getBomArtifactId());
        invocation.setValue("quarkus_version", platformDescr.getQuarkusVersion());
        invocation.setValue("bom_version", platformDescr.getBomVersion());
        Set<String> extensionsQuery = invocation.getValue("extensions", Collections.emptySet());
        Properties quarkusProps = ToolsUtils.readQuarkusProperties(platformDescr);
        quarkusProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String name = k.toString().replace("-", "_");
            if (!invocation.hasValue(name)) {
                invocation.setValue(k.toString().replace("-", "_"), v.toString());
            }
        }));
        String pkgName = invocation.getStringValue("package_name");
        String groupId = invocation.getStringValue("project_groupId");
        if (pkgName == null && groupId != null) {
            invocation.setValue("package_name", groupId.replace("-", ".").replace("_", "."));
        }
        if ((extensionsToAdd = QuarkusCommandHandlers.computeCoordsFromQuery(invocation, extensionsQuery)) == null) {
            throw new QuarkusCommandException("Failed to create project because of invalid extensions");
        }
        try {
            HashMap platformData = new HashMap();
            if (platformDescr.getMetadata().get("maven") != null) {
                platformData.put("maven", platformDescr.getMetadata().get("maven"));
            }
            if (platformDescr.getMetadata().get("gradle") != null) {
                platformData.put("gradle", platformDescr.getMetadata().get("gradle"));
            }
            QuarkusCodestartProjectInput input = QuarkusCodestartProjectInput.builder().addExtensions(extensionsToAdd).buildTool(invocation.getQuarkusProject().getBuildTool()).addCodestarts((Collection)invocation.getValue(CreateProject.CODESTARTS, new HashSet())).noExamples(invocation.getValue(CreateProject.NO_EXAMPLES, false)).noBuildToolWrapper(invocation.getValue(CreateProject.NO_BUILDTOOL_WRAPPER, false)).noDockerfiles(invocation.getValue(CreateProject.NO_DOCKERFILES, false)).addData((Map)platformData).addData((Map)QuarkusCodestartData.LegacySupport.convertFromLegacy(invocation.getValues())).messageWriter(invocation.log()).build();
            invocation.log().info("-----------");
            if (!extensionsToAdd.isEmpty()) {
                invocation.log().info("selected extensions: \n" + extensionsToAdd.stream().map(e -> "- " + e.getGroupId() + ":" + e.getArtifactId() + "\n").collect(Collectors.joining()));
            }
            QuarkusCodestartCatalog catalog = QuarkusCodestartCatalog.fromQuarkusPlatformDescriptor(invocation.getPlatformDescriptor());
            CodestartProjectDefinition projectDefinition = catalog.createProject(input);
            projectDefinition.generate(invocation.getQuarkusProject().getProjectDirPath());
            invocation.log().info("\n-----------\n\ud83d\udc4d " + projectDefinition.getRequiredCodestart(CodestartType.PROJECT).getName() + " project has been successfully generated in:\n--> " + invocation.getQuarkusProject().getProjectDirPath().toString() + "\n-----------");
        }
        catch (IOException e2) {
            throw new QuarkusCommandException("Failed to create project", e2);
        }
        return QuarkusCommandOutcome.success();
    }
}

