/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.model;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.CollectionType;
import io.quarkus.registry.catalog.model.Extension;
import io.quarkus.registry.catalog.model.ImmutableRepository;
import io.quarkus.registry.catalog.model.Platform;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableRepository.class)
@Value.Immutable
public abstract class Repository {
    public abstract List<Extension> getIndividualExtensions();

    public abstract List<Platform> getPlatforms();

    public static Repository parse(Path rootPath, ObjectMapper mapper) {
        ObjectReader reader = mapper.reader().with((DeserializationConfig)mapper.getDeserializationConfig().with(PropertyNamingStrategy.KEBAB_CASE));
        return ImmutableRepository.builder().addAllPlatforms(Repository.parse(rootPath.resolve("platforms.json"), Platform.class, reader)).addAllIndividualExtensions(Repository.parse(rootPath.resolve("extensions"), Extension.class, reader)).build();
    }

    private static <T> Set<T> parse(Path root, Class<? extends T> type, ObjectReader reader) {
        HashSet<Object> result;
        block18: {
            result = new HashSet<Object>();
            if (Files.isDirectory(root, new LinkOption[0])) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(root, "*.json");){
                    for (Path path : stream) {
                        result.add(reader.forType(type).readValue(path.toFile()));
                    }
                    break block18;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            CollectionType collectionType = reader.getTypeFactory().constructCollectionType(List.class, type);
            try {
                result.addAll((Collection)reader.forType((JavaType)collectionType).readValue(root.toFile()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

