/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.cli.commands.QuarkusCommand;
import io.quarkus.cli.commands.QuarkusCommandException;
import io.quarkus.cli.commands.QuarkusCommandInvocation;
import io.quarkus.cli.commands.QuarkusCommandOutcome;
import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.file.MavenBuildFile;
import io.quarkus.cli.commands.legacy.LegacyQuarkusCommandInvocation;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.generators.BuildTool;
import io.quarkus.generators.ProjectGeneratorRegistry;
import io.quarkus.generators.SourceType;
import io.quarkus.platform.tools.ToolsUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.maven.model.Model;

public class CreateProject
implements QuarkusCommand {
    private ProjectWriter writer;
    private String groupId;
    private String artifactId;
    private String version;
    private SourceType sourceType = SourceType.JAVA;
    private BuildFile buildFile;
    private BuildTool buildTool;
    private String className;
    private Set<String> extensions;
    private Model model;

    public CreateProject(ProjectWriter writer) {
        this.writer = writer;
    }

    public CreateProject groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public CreateProject artifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public CreateProject version(String version) {
        this.version = version;
        return this;
    }

    public CreateProject sourceType(SourceType sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public CreateProject className(String className) {
        this.className = className;
        return this;
    }

    public CreateProject extensions(Set<String> extensions) {
        this.extensions = extensions;
        return this;
    }

    public CreateProject buildFile(BuildFile buildFile) {
        this.buildFile = buildFile;
        return this;
    }

    public CreateProject buildTool(BuildTool buildTool) {
        this.buildTool = buildTool;
        return this;
    }

    public Model getModel() {
        return this.model;
    }

    public boolean doCreateProject(Map<String, Object> context) throws IOException {
        try {
            return this.execute(new LegacyQuarkusCommandInvocation(context)).isSuccess();
        }
        catch (QuarkusCommandException e) {
            throw new IOException("Failed to create project", e);
        }
    }

    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        if (!this.writer.init()) {
            return QuarkusCommandOutcome.failure();
        }
        Properties quarkusProps = ToolsUtils.readQuarkusProperties(invocation.getPlatformDescriptor());
        quarkusProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> invocation.setProperty(k.toString().replace("-", "_"), v.toString())));
        invocation.setProperty("project_groupId", this.groupId);
        invocation.setProperty("project_artifactId", this.artifactId);
        invocation.setProperty("project_version", this.version);
        invocation.setProperty("bom_groupId", invocation.getPlatformDescriptor().getBomGroupId());
        invocation.setProperty("bom_artifactId", invocation.getPlatformDescriptor().getBomArtifactId());
        try (BuildFile buildFile = this.getBuildFile();){
            String bomVersion = invocation.getPlatformDescriptor().getBomVersion();
            invocation.setProperty("bom_version", bomVersion);
            invocation.setProperty("quarkus_version", invocation.getPlatformDescriptor().getQuarkusVersion());
            invocation.setValue("source_type", (Object)this.sourceType);
            invocation.setValue("build_file", buildFile);
            if (this.extensions != null && this.extensions.stream().anyMatch(e -> e.toLowerCase().contains("spring-web"))) {
                invocation.setValue("is_spring", Boolean.TRUE);
            }
            if (this.className != null) {
                this.className = this.sourceType.stripExtensionFrom(this.className);
                int idx = this.className.lastIndexOf(46);
                if (idx >= 0) {
                    String packageName = this.className.substring(0, idx);
                    this.className = this.className.substring(idx + 1);
                    invocation.setProperty("package_name", packageName);
                }
                invocation.setProperty("class_name", this.className);
            }
            ProjectGeneratorRegistry.get("basic-rest").generate(this.writer, invocation);
            buildFile.completeFile(this.groupId, this.artifactId, this.version, invocation.getPlatformDescriptor(), quarkusProps);
        }
        catch (IOException e2) {
            throw new QuarkusCommandException("Failed to create project", e2);
        }
        return QuarkusCommandOutcome.success();
    }

    private BuildFile getBuildFile() throws IOException {
        if (this.buildFile == null) {
            this.buildFile = this.buildTool == null ? new MavenBuildFile(this.writer) : this.buildTool.createBuildFile(this.writer);
        }
        return this.buildFile;
    }

    public static SourceType determineSourceType(Set<String> extensions) {
        Optional<SourceType> sourceType = extensions.stream().map(SourceType::parse).filter(Optional::isPresent).map(e -> e.orElse(SourceType.JAVA)).findAny();
        return sourceType.orElse(SourceType.JAVA);
    }
}

