/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.cli.commands.ValueMap;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.tools.MessageWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class QuarkusCommandInvocation
extends ValueMap<QuarkusCommandInvocation> {
    protected final QuarkusPlatformDescriptor platformDescr;
    protected final MessageWriter log;
    protected final Properties props;

    public QuarkusCommandInvocation(QuarkusPlatformDescriptor platformDescr, MessageWriter log) {
        this(platformDescr, log, new HashMap<String, Object>(), new Properties(System.getProperties()));
    }

    public QuarkusCommandInvocation(QuarkusPlatformDescriptor platformDescr, MessageWriter log, Map<String, Object> values, Properties props) {
        super(values);
        this.platformDescr = platformDescr;
        this.log = log;
        this.props = props;
    }

    public MessageWriter getMessageWriter() {
        return this.log;
    }

    public QuarkusPlatformDescriptor getPlatformDescriptor() {
        return this.platformDescr;
    }

    public String getProperty(String name) {
        String value = this.props.getProperty(name, "QUARKUS_VALUE_NOT_SET");
        return value == "QUARKUS_VALUE_NOT_SET" ? System.getProperty(name) : value;
    }

    public boolean hasProperty(String name) {
        return this.props.getOrDefault((Object)name, "QUARKUS_VALUE_NOT_SET") != "QUARKUS_VALUE_NOT_SET";
    }

    public QuarkusCommandInvocation setProperty(String name, String value) {
        this.props.setProperty(name, value);
        return this;
    }

    public Properties getProperties() {
        return this.props;
    }
}

