/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import java.util.HashMap;
import java.util.Map;

public class ValueMap<V extends ValueMap<V>> {
    static final String NOT_SET = "QUARKUS_VALUE_NOT_SET";
    protected final Map<String, Object> values;

    public ValueMap() {
        this(new HashMap<String, Object>());
    }

    public ValueMap(Map<String, Object> values) {
        this.values = values == null ? new HashMap() : values;
    }

    public ValueMap(ValueMap<?> values) {
        this(values.values);
    }

    public Object getValue(String name) {
        return this.getValue(name, null);
    }

    public <T> T getValue(String name, T defaultValue) {
        Object value = this.values.getOrDefault(name, NOT_SET);
        if (value == NOT_SET) {
            return defaultValue;
        }
        if (value == null) {
            return null;
        }
        return (T)value;
    }

    public boolean getValue(String name, boolean defaultValue) {
        Object value = this.getValue(name, null);
        if (value == null) {
            return defaultValue;
        }
        if (Boolean.class.equals(value.getClass())) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public boolean hasValue(String name) {
        return this.values.getOrDefault(name, NOT_SET) != NOT_SET;
    }

    public V setValue(String name, Object value) {
        this.values.put(name, value);
        return (V)this;
    }

    public V setValue(String name, boolean value) {
        return this.setValue(name, (Object)value);
    }
}

