/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartDefinitionException;
import io.quarkus.devtools.codestarts.CodestartInput;
import io.quarkus.devtools.codestarts.CodestartLoader;
import io.quarkus.devtools.codestarts.CodestartProject;
import io.quarkus.devtools.codestarts.CodestartResourceLoader;
import io.quarkus.devtools.codestarts.CodestartSpec;
import io.quarkus.devtools.codestarts.Codestarts;
import io.quarkus.devtools.codestarts.QuarkusCodestartInput;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class QuarkusCodestarts {
    private QuarkusCodestarts() {
    }

    public static CodestartProject prepareProject(QuarkusCodestartInput input) throws IOException {
        List allCodestarts = CodestartLoader.loadAllCodestarts((CodestartInput)input.getCodestartInput());
        CodestartProject codestartProject = Codestarts.prepareProject((CodestartInput)input.getCodestartInput(), (List)allCodestarts);
        List codestarts = codestartProject.getCodestarts().stream().filter(c -> !QuarkusCodestarts.isExample(c) || !input.noExamples()).collect(Collectors.toCollection(ArrayList::new));
        if (!input.noExamples() && codestartProject.getExtraCodestarts().stream().noneMatch(c -> QuarkusCodestarts.isExample(c) && !c.getSpec().isPreselected())) {
            Codestart commandModeCodestart = allCodestarts.stream().filter(c -> c.isSelected(Collections.singleton(Example.COMMANDMODE_EXAMPLE.getKey()))).findFirst().orElseThrow(() -> new CodestartDefinitionException(Example.COMMANDMODE_EXAMPLE.getKey() + " codestart not found"));
            codestarts.add(commandModeCodestart);
        }
        return CodestartProject.of((CodestartInput)input.getCodestartInput(), (List)codestarts);
    }

    public static CodestartResourceLoader resourceLoader(QuarkusPlatformDescriptor platformDescr) {
        return new QuarkusPlatformCodestartResourceLoader(platformDescr);
    }

    public static boolean isExample(Codestart codestart) {
        return codestart.getType() == CodestartSpec.Type.CODE && codestart.getSpec().getTags().contains(Tag.EXAMPLE.getKey());
    }

    static interface KeySupplier {
        default public String getKey() {
            return this.toString().toLowerCase().replace("_", "-");
        }
    }

    private static class QuarkusPlatformCodestartResourceLoader
    implements CodestartResourceLoader {
        private QuarkusPlatformDescriptor platformDescr;

        QuarkusPlatformCodestartResourceLoader(QuarkusPlatformDescriptor platformDescr) {
            this.platformDescr = platformDescr;
        }

        public <T> T loadResourceAsPath(String name, CodestartResourceLoader.Consumer<T> consumer) throws IOException {
            return (T)this.platformDescr.loadResourceAsPath(name, arg_0 -> consumer.consume(arg_0));
        }
    }

    public static enum Example implements KeySupplier
    {
        RESTEASY_EXAMPLE,
        COMMANDMODE_EXAMPLE;

    }

    public static enum Tooling implements KeySupplier
    {
        GRADLE_WRAPPER,
        MAVEN_WRAPPER,
        DOCKERFILES;

    }

    public static enum Language implements KeySupplier
    {
        JAVA,
        KOTLIN,
        SCALA;

    }

    public static enum Tag implements KeySupplier
    {
        EXAMPLE,
        COMPATIBILITY_ISSUES,
        MAVEN_ONLY;

    }
}

