/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.model.ArtifactKey;
import io.quarkus.registry.model.ModifiablePlatform;
import io.quarkus.registry.model.Platform;
import io.quarkus.registry.model.Release;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class ImmutablePlatform
implements Platform {
    private final ArtifactKey id;
    private final Set<Release> releases;

    private ImmutablePlatform(ArtifactKey id, Set<Release> releases) {
        this.id = id;
        this.releases = releases;
    }

    @Override
    @JsonProperty(value="id")
    @JsonUnwrapped
    public ArtifactKey getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="releases")
    public Set<Release> getReleases() {
        return this.releases;
    }

    public final ImmutablePlatform withId(ArtifactKey value) {
        if (this.id == value) {
            return this;
        }
        ArtifactKey newValue = Objects.requireNonNull(value, "id");
        return new ImmutablePlatform(newValue, this.releases);
    }

    public final ImmutablePlatform withReleases(Release ... elements) {
        Set<Release> newValue = ImmutablePlatform.createUnmodifiableSet(ImmutablePlatform.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePlatform(this.id, newValue);
    }

    public final ImmutablePlatform withReleases(Iterable<? extends Release> elements) {
        if (this.releases == elements) {
            return this;
        }
        Set<Release> newValue = ImmutablePlatform.createUnmodifiableSet(ImmutablePlatform.createSafeList(elements, true, false));
        return new ImmutablePlatform(this.id, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePlatform && this.equalTo((ImmutablePlatform)another);
    }

    private boolean equalTo(ImmutablePlatform another) {
        return this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "Platform{id=" + this.id + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePlatform fromJson(Json json) {
        Builder builder = ImmutablePlatform.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.releases != null) {
            builder.addAllReleases(json.releases);
        }
        return builder.build();
    }

    public static ImmutablePlatform copyOf(Platform instance) {
        if (instance instanceof ImmutablePlatform) {
            return (ImmutablePlatform)instance;
        }
        return ImmutablePlatform.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        private ArtifactKey id;
        private List<Release> releases = new ArrayList<Release>();

        private Builder() {
        }

        public final Builder from(ModifiablePlatform instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance.idIsSet()) {
                this.id(instance.getId());
            }
            this.addAllReleases(instance.getReleases());
            return this;
        }

        public final Builder from(Platform instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiablePlatform) {
                return this.from((ModifiablePlatform)instance);
            }
            this.id(instance.getId());
            this.addAllReleases(instance.getReleases());
            return this;
        }

        @JsonProperty(value="id")
        @JsonUnwrapped
        public final Builder id(ArtifactKey id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addReleases(Release element) {
            this.releases.add(Objects.requireNonNull(element, "releases element"));
            return this;
        }

        public final Builder addReleases(Release ... elements) {
            for (Release element : elements) {
                this.releases.add(Objects.requireNonNull(element, "releases element"));
            }
            return this;
        }

        @JsonProperty(value="releases")
        public final Builder releases(Iterable<? extends Release> elements) {
            this.releases.clear();
            return this.addAllReleases(elements);
        }

        public final Builder addAllReleases(Iterable<? extends Release> elements) {
            for (Release release : elements) {
                this.releases.add(Objects.requireNonNull(release, "releases element"));
            }
            return this;
        }

        public ImmutablePlatform build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePlatform(this.id, ImmutablePlatform.createUnmodifiableSet(this.releases));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build Platform, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements Platform {
        ArtifactKey id;
        Set<Release> releases = Collections.emptySet();

        Json() {
        }

        @JsonProperty(value="id")
        @JsonUnwrapped
        public void setId(ArtifactKey id) {
            this.id = id;
        }

        @JsonProperty(value="releases")
        public void setReleases(Set<Release> releases) {
            this.releases = releases;
        }

        @Override
        public ArtifactKey getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Release> getReleases() {
            throw new UnsupportedOperationException();
        }
    }
}

