/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.json;

import io.quarkus.registry.catalog.Category;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.catalog.PlatformRelease;
import io.quarkus.registry.catalog.PlatformStream;
import io.quarkus.registry.catalog.json.JsonExtension;
import io.quarkus.registry.catalog.json.JsonExtensionCatalog;
import io.quarkus.registry.catalog.json.JsonPlatform;
import io.quarkus.registry.catalog.json.JsonPlatformCatalog;
import io.quarkus.registry.catalog.json.JsonPlatformStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonCatalogMerger {
    public static ExtensionCatalog merge(List<ExtensionCatalog> catalogs) {
        if (catalogs.isEmpty()) {
            throw new IllegalArgumentException("No catalogs provided");
        }
        if (catalogs.size() == 1) {
            return catalogs.get(0);
        }
        List<ExtensionCatalog> roots = JsonCatalogMerger.detectRoots(catalogs);
        if (roots.size() == 1) {
            return roots.get(0);
        }
        JsonExtensionCatalog combined = new JsonExtensionCatalog();
        LinkedHashMap categories = new LinkedHashMap();
        LinkedHashMap<String, ExtensionCatalog> derivedFrom = new LinkedHashMap<String, ExtensionCatalog>();
        LinkedHashMap extensions = new LinkedHashMap();
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        for (ExtensionCatalog catalog : roots) {
            if (combined.getBom() == null) {
                combined.setBom(catalog.getBom());
            }
            if (catalog.getId() != null) {
                derivedFrom.putIfAbsent(catalog.getId(), catalog);
            }
            catalog.getDerivedFrom().forEach(o -> derivedFrom.putIfAbsent(o.getId(), (ExtensionCatalog)o));
            catalog.getCategories().forEach(c -> categories.putIfAbsent(c.getId(), c));
            catalog.getExtensions().forEach(e -> {
                Extension copy = (Extension)extensions.get(e.getArtifact().getKey());
                if (copy == null) {
                    extensions.put(e.getArtifact().getKey(), JsonExtension.copy(e));
                } else {
                    copy.getOrigins().addAll(e.getOrigins());
                }
            });
            catalog.getMetadata().entrySet().forEach(entry -> metadata.putIfAbsent((String)entry.getKey(), entry.getValue()));
            if (combined.getQuarkusCoreVersion() == null && catalog.getQuarkusCoreVersion() != null) {
                combined.setQuarkusCoreVersion(catalog.getQuarkusCoreVersion());
            }
            if (combined.getUpstreamQuarkusCoreVersion() != null || catalog.getUpstreamQuarkusCoreVersion() == null || combined.getQuarkusCoreVersion().equals(catalog.getUpstreamQuarkusCoreVersion())) continue;
            combined.setUpstreamQuarkusCoreVersion(catalog.getUpstreamQuarkusCoreVersion());
        }
        combined.setCategories(new ArrayList<Category>(categories.values()));
        combined.setDerivedFrom(new ArrayList<ExtensionOrigin>(derivedFrom.values()));
        combined.setExtensions(new ArrayList<Extension>(extensions.values()));
        combined.setMetadata(metadata);
        return combined;
    }

    public static PlatformCatalog mergePlatformCatalogs(List<PlatformCatalog> catalogs) {
        if (catalogs.isEmpty()) {
            throw new IllegalArgumentException("No catalogs provided");
        }
        if (catalogs.size() == 1) {
            return catalogs.get(0);
        }
        JsonPlatformCatalog merged = new JsonPlatformCatalog();
        HashMap<String, JsonPlatform> platformMap = new HashMap<String, JsonPlatform>();
        for (PlatformCatalog c : catalogs) {
            for (Platform p : c.getPlatforms()) {
                JsonPlatform mergedPlatform = platformMap.computeIfAbsent(p.getPlatformKey(), k -> {
                    JsonPlatform pl = new JsonPlatform();
                    pl.setPlatformKey(p.getPlatformKey());
                    merged.addPlatform(pl);
                    return pl;
                });
                for (PlatformStream s : p.getStreams()) {
                    JsonPlatformStream mergedStream = (JsonPlatformStream)mergedPlatform.getStream(s.getId());
                    if (mergedStream == null) {
                        mergedStream = new JsonPlatformStream();
                        mergedStream.setId(s.getId());
                        mergedPlatform.addStream(mergedStream);
                    }
                    for (PlatformRelease r : s.getReleases()) {
                        PlatformRelease release = mergedStream.getRelease(r.getVersion());
                        if (release != null) continue;
                        mergedStream.addRelease(r);
                    }
                    Map mergedStreamMetadata = mergedStream.getMetadata();
                    s.getMetadata().entrySet().forEach(entry -> mergedStreamMetadata.putIfAbsent((String)entry.getKey(), entry.getValue()));
                }
                p.getMetadata().entrySet().forEach(entry -> mergedPlatform.getMetadata().putIfAbsent((String)entry.getKey(), entry.getValue()));
            }
            c.getMetadata().entrySet().forEach(entry -> merged.getMetadata().putIfAbsent((String)entry.getKey(), entry.getValue()));
        }
        return merged;
    }

    private static List<ExtensionCatalog> detectRoots(List<ExtensionCatalog> catalogs) {
        HashSet<String> allDerivedFrom = new HashSet<String>(catalogs.size());
        for (ExtensionCatalog catalog : catalogs) {
            for (ExtensionOrigin o : catalog.getDerivedFrom()) {
                allDerivedFrom.add(o.getId());
            }
        }
        ArrayList<ExtensionCatalog> roots = new ArrayList<ExtensionCatalog>(catalogs.size());
        for (ExtensionCatalog catalog : catalogs) {
            if (catalog.getId() == null) {
                roots.add(catalog);
                continue;
            }
            if (allDerivedFrom.contains(catalog.getId())) continue;
            roots.add(catalog);
        }
        return roots;
    }
}

