/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.jdbc;

import io.quarkus.arc.Arc;
import io.quarkus.elytron.security.jdbc.AttributeMappingConfig;
import io.quarkus.elytron.security.jdbc.JdbcSecurityRealmConfig;
import io.quarkus.elytron.security.jdbc.PrincipalQueriesConfig;
import io.quarkus.elytron.security.jdbc.PrincipalQueryConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.security.Provider;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.wildfly.security.WildFlyElytronProvider;
import org.wildfly.security.auth.realm.jdbc.ColumnMapper;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealm;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealmBuilder;
import org.wildfly.security.auth.realm.jdbc.QueryBuilder;
import org.wildfly.security.auth.realm.jdbc.mapper.AttributeMapper;
import org.wildfly.security.auth.server.SecurityRealm;

@Recorder
public class JdbcRecorder {
    private static final Provider[] PROVIDERS = new Provider[]{new WildFlyElytronProvider()};

    public RuntimeValue<SecurityRealm> createRealm(JdbcSecurityRealmConfig config) {
        Supplier<Provider[]> providers = new Supplier<Provider[]>(){

            @Override
            public Provider[] get() {
                return PROVIDERS;
            }
        };
        JdbcSecurityRealmBuilder builder = JdbcSecurityRealm.builder().setProviders((Supplier)providers);
        PrincipalQueriesConfig principalQueries = config.principalQueries;
        this.registerPrincipalQuery(principalQueries.defaultPrincipalQuery, builder);
        principalQueries.namedPrincipalQueries.forEach((name, principalQuery) -> this.registerPrincipalQuery((PrincipalQueryConfig)principalQuery, builder));
        return new RuntimeValue((Object)builder.build());
    }

    private void registerPrincipalQuery(PrincipalQueryConfig principalQuery, JdbcSecurityRealmBuilder builder) {
        DataSource dataSource = (DataSource)principalQuery.datasource.map(name -> Arc.container().instance(name).get()).orElse(Arc.container().instance(DataSource.class, new Annotation[0]).get());
        QueryBuilder queryBuilder = builder.principalQuery(principalQuery.sql).from(dataSource);
        AttributeMapper[] mappers = (AttributeMapper[])principalQuery.attributeMappings.entrySet().stream().map(entry -> new AttributeMapper(((AttributeMappingConfig)entry.getValue()).index, ((AttributeMappingConfig)entry.getValue()).to)).toArray(AttributeMapper[]::new);
        queryBuilder.withMapper((ColumnMapper[])mappers);
        if (principalQuery.clearPasswordMapperConfig.enabled) {
            queryBuilder.withMapper(new ColumnMapper[]{principalQuery.clearPasswordMapperConfig.toPasswordKeyMapper()});
        }
        if (principalQuery.bcryptPasswordKeyMapperConfig.enabled) {
            queryBuilder.withMapper(new ColumnMapper[]{principalQuery.bcryptPasswordKeyMapperConfig.toPasswordKeyMapper()});
        }
    }
}

