/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.reflection;

import com.google.protobuf.Descriptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class GrpcServerIndex {
    private final Set<String> names;
    private final Set<Descriptors.FileDescriptor> services;
    private final Map<String, Descriptors.FileDescriptor> descriptorsByName;
    private final Map<String, Descriptors.FileDescriptor> descriptorsBySymbol;
    private final Map<String, Map<Integer, Descriptors.FileDescriptor>> descriptorsByExtensionAndNumber;

    public GrpcServerIndex(List<ServerServiceDefinition> definitions) {
        ArrayDeque<Descriptors.FileDescriptor> fileDescriptorsToProcess = new ArrayDeque<Descriptors.FileDescriptor>();
        HashSet<String> files = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        HashSet<Descriptors.FileDescriptor> services = new HashSet<Descriptors.FileDescriptor>();
        LinkedHashMap<String, Descriptors.FileDescriptor> descriptorsByName = new LinkedHashMap<String, Descriptors.FileDescriptor>();
        LinkedHashMap<String, Descriptors.FileDescriptor> descriptorsBySymbol = new LinkedHashMap<String, Descriptors.FileDescriptor>();
        LinkedHashMap<String, Map<Integer, Descriptors.FileDescriptor>> descriptorsByExtensionAndNumber = new LinkedHashMap<String, Map<Integer, Descriptors.FileDescriptor>>();
        for (ServerServiceDefinition definition : definitions) {
            ServiceDescriptor serviceDescriptor = definition.getServiceDescriptor();
            if (!(serviceDescriptor.getSchemaDescriptor() instanceof ProtoFileDescriptorSupplier)) continue;
            ProtoFileDescriptorSupplier supplier = (ProtoFileDescriptorSupplier)serviceDescriptor.getSchemaDescriptor();
            Descriptors.FileDescriptor fd = supplier.getFileDescriptor();
            String serviceName = serviceDescriptor.getName();
            if (names.contains(serviceName)) {
                throw new IllegalStateException("Duplicated gRPC service: " + serviceName);
            }
            services.add(fd);
            names.add(serviceName);
            if (files.contains(fd.getName())) continue;
            files.add(fd.getName());
            fileDescriptorsToProcess.add(fd);
        }
        while (!fileDescriptorsToProcess.isEmpty()) {
            Descriptors.FileDescriptor fd = (Descriptors.FileDescriptor)fileDescriptorsToProcess.remove();
            this.processFileDescriptor(fd, descriptorsByName, descriptorsBySymbol, descriptorsByExtensionAndNumber);
            for (Descriptors.FileDescriptor dep : fd.getDependencies()) {
                if (files.contains(dep.getName())) continue;
                files.add(dep.getName());
                fileDescriptorsToProcess.add(dep);
            }
        }
        this.services = Collections.unmodifiableSet(services);
        this.descriptorsByName = Collections.unmodifiableMap(descriptorsByName);
        this.descriptorsByExtensionAndNumber = Collections.unmodifiableMap(descriptorsByExtensionAndNumber);
        this.descriptorsBySymbol = Collections.unmodifiableMap(descriptorsBySymbol);
        this.names = Collections.unmodifiableSet(names);
    }

    public Set<String> getServiceNames() {
        return this.names;
    }

    public Descriptors.FileDescriptor getFileDescriptorByName(String name) {
        return this.descriptorsByName.get(name);
    }

    public Descriptors.FileDescriptor getFileDescriptorBySymbol(String symbol) {
        return this.descriptorsBySymbol.get(symbol);
    }

    public Descriptors.FileDescriptor getFileDescriptorByExtensionAndNumber(String type, int number) {
        Map map = this.descriptorsByExtensionAndNumber.getOrDefault(type, Collections.emptyMap());
        return (Descriptors.FileDescriptor)map.get(number);
    }

    public Set<Integer> getExtensionNumbersOfType(String type) {
        return this.descriptorsByExtensionAndNumber.getOrDefault(type, Collections.emptyMap()).keySet();
    }

    private void processFileDescriptor(Descriptors.FileDescriptor fd, Map<String, Descriptors.FileDescriptor> descriptorsByName, Map<String, Descriptors.FileDescriptor> descriptorsBySymbol, Map<String, Map<Integer, Descriptors.FileDescriptor>> descriptorsByExtensionAndNumber) {
        String name = fd.getName();
        if (descriptorsByName.containsKey(name)) {
            throw new IllegalStateException("File name already used: " + name);
        }
        descriptorsByName.put(name, fd);
        for (Descriptors.ServiceDescriptor service : fd.getServices()) {
            this.processService(service, fd, descriptorsBySymbol);
        }
        for (Descriptors.Descriptor type : fd.getMessageTypes()) {
            this.processType(type, fd, descriptorsBySymbol, descriptorsByExtensionAndNumber);
        }
        for (Descriptors.FieldDescriptor extension : fd.getExtensions()) {
            this.processExtension(extension, fd, descriptorsByExtensionAndNumber);
        }
    }

    private void processService(Descriptors.ServiceDescriptor service, Descriptors.FileDescriptor fd, Map<String, Descriptors.FileDescriptor> descriptorsBySymbol) {
        String fullyQualifiedServiceName = service.getFullName();
        if (descriptorsBySymbol.containsKey(fullyQualifiedServiceName)) {
            throw new IllegalStateException("Service already defined: " + fullyQualifiedServiceName);
        }
        descriptorsBySymbol.put(fullyQualifiedServiceName, fd);
        for (Descriptors.MethodDescriptor method : service.getMethods()) {
            String fullyQualifiedMethodName = method.getFullName();
            if (descriptorsBySymbol.containsKey(fullyQualifiedMethodName)) {
                throw new IllegalStateException("Method already defined: " + fullyQualifiedMethodName + " in " + fullyQualifiedServiceName);
            }
            descriptorsBySymbol.put(fullyQualifiedMethodName, fd);
        }
    }

    private void processType(Descriptors.Descriptor type, Descriptors.FileDescriptor fd, Map<String, Descriptors.FileDescriptor> descriptorsBySymbol, Map<String, Map<Integer, Descriptors.FileDescriptor>> descriptorsByExtensionAndNumber) {
        String fullyQualifiedTypeName = type.getFullName();
        if (descriptorsBySymbol.containsKey(fullyQualifiedTypeName)) {
            throw new IllegalStateException("Type already defined: " + fullyQualifiedTypeName);
        }
        descriptorsBySymbol.put(fullyQualifiedTypeName, fd);
        for (Descriptors.FieldDescriptor extension : type.getExtensions()) {
            this.processExtension(extension, fd, descriptorsByExtensionAndNumber);
        }
        for (Descriptors.Descriptor nestedType : type.getNestedTypes()) {
            this.processType(nestedType, fd, descriptorsBySymbol, descriptorsByExtensionAndNumber);
        }
    }

    private void processExtension(Descriptors.FieldDescriptor extension, Descriptors.FileDescriptor fd, Map<String, Map<Integer, Descriptors.FileDescriptor>> descriptorsByExtensionAndNumber) {
        String extensionName = extension.getContainingType().getFullName();
        int extensionNumber = extension.getNumber();
        descriptorsByExtensionAndNumber.computeIfAbsent(extensionName, new Function<String, Map<Integer, Descriptors.FileDescriptor>>(){

            @Override
            public Map<Integer, Descriptors.FileDescriptor> apply(String s) {
                return new HashMap<Integer, Descriptors.FileDescriptor>();
            }
        });
        if (descriptorsByExtensionAndNumber.get(extensionName).containsKey(extensionNumber)) {
            throw new IllegalStateException("Extension name " + extensionName + " and number " + extensionNumber + " are already defined");
        }
        descriptorsByExtensionAndNumber.get(extensionName).put(extensionNumber, fd);
    }
}

