/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports.blocking;

import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.grpc.runtime.supports.blocking.BlockingExecutionHandler;
import io.quarkus.grpc.runtime.supports.blocking.DevModeBlockingExecutionHandler;
import io.vertx.core.Vertx;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public class BlockingServerInterceptor
implements ServerInterceptor,
Function<String, Boolean> {
    private final Vertx vertx;
    private final Set<String> blockingMethods;
    private final Set<String> virtualMethods;
    private final Map<String, Boolean> blockingCache = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Boolean> virtualCache = new ConcurrentHashMap<String, Boolean>();
    private final boolean devMode;
    private final Executor virtualThreadExecutor;

    public BlockingServerInterceptor(Vertx vertx, List<String> blockingMethods, List<String> virtualMethods, Executor virtualThreadExecutor, boolean devMode) {
        this.vertx = vertx;
        this.blockingMethods = new HashSet<String>();
        this.virtualMethods = new HashSet<String>();
        this.devMode = devMode;
        if (blockingMethods != null) {
            for (String method : blockingMethods) {
                this.blockingMethods.add(method.toLowerCase());
            }
        }
        if (virtualMethods != null) {
            for (String method : virtualMethods) {
                this.virtualMethods.add(method.toLowerCase());
            }
        }
        this.virtualThreadExecutor = virtualThreadExecutor;
    }

    @Override
    public Boolean apply(String name) {
        String methodName = name.substring(name.lastIndexOf("/") + 1);
        return this.blockingMethods.contains(methodName.toLowerCase());
    }

    public Boolean applyVirtual(String name) {
        String methodName = name.substring(name.lastIndexOf("/") + 1);
        return this.virtualMethods.contains(methodName.toLowerCase());
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        String fullMethodName = call.getMethodDescriptor().getFullMethodName();
        boolean isBlocking = this.blockingCache.computeIfAbsent(fullMethodName, this);
        boolean isVirtual = this.virtualCache.computeIfAbsent(fullMethodName, this::applyVirtual);
        if (isVirtual) {
            ManagedContext requestContext = this.getRequestContext();
            InjectableContext.ContextState state = requestContext.getState();
            VirtualReplayListener replay = new VirtualReplayListener(state);
            this.virtualThreadExecutor.execute(() -> {
                ServerCall.Listener listener;
                try {
                    requestContext.activate(state);
                    listener = next.startCall(call, headers);
                }
                finally {
                    requestContext.deactivate();
                }
                replay.setDelegate(listener);
            });
            return replay;
        }
        if (isBlocking) {
            ManagedContext requestContext = this.getRequestContext();
            InjectableContext.ContextState state = requestContext.getState();
            ReplayListener replay = new ReplayListener(state);
            this.vertx.executeBlocking(() -> {
                ServerCall.Listener listener;
                try {
                    requestContext.activate(state);
                    listener = next.startCall(call, headers);
                }
                finally {
                    requestContext.deactivate();
                }
                return listener;
            }, false).onComplete(event -> replay.setDelegate((ServerCall.Listener)event.result()));
            return replay;
        }
        return next.startCall(call, headers);
    }

    protected ManagedContext getRequestContext() {
        return Arc.container().requestContext();
    }

    private class VirtualReplayListener<ReqT>
    extends ServerCall.Listener<ReqT> {
        private final InjectableContext.ContextState requestContextState;
        private ServerCall.Listener<ReqT> delegate;
        private final Queue<Consumer<ServerCall.Listener<ReqT>>> incomingEvents = new ConcurrentLinkedQueue<Consumer<ServerCall.Listener<ReqT>>>();
        private volatile boolean isConsumingFromIncomingEvents = false;

        private VirtualReplayListener(InjectableContext.ContextState requestContextState) {
            this.requestContextState = requestContextState;
        }

        void setDelegate(ServerCall.Listener<ReqT> delegate) {
            Consumer<ServerCall.Listener<ReqT>> consumer;
            this.delegate = delegate;
            if (!this.isConsumingFromIncomingEvents && (consumer = this.incomingEvents.poll()) != null) {
                this.executeVirtualWithRequestContext(consumer);
            }
        }

        private void scheduleOrEnqueue(Consumer<ServerCall.Listener<ReqT>> consumer) {
            if (this.delegate != null && !this.isConsumingFromIncomingEvents) {
                this.executeVirtualWithRequestContext(consumer);
            } else {
                this.incomingEvents.add(consumer);
            }
        }

        private void executeVirtualWithRequestContext(Consumer<ServerCall.Listener<ReqT>> consumer) {
            Context grpcContext = Context.current();
            Callable<Void> blockingHandler = new BlockingExecutionHandler<ReqT>(consumer, grpcContext, this.delegate, this.requestContextState, BlockingServerInterceptor.this.getRequestContext(), (Object)this);
            if (BlockingServerInterceptor.this.devMode) {
                blockingHandler = new DevModeBlockingExecutionHandler(Thread.currentThread().getContextClassLoader(), blockingHandler);
            }
            this.isConsumingFromIncomingEvents = true;
            BlockingExecutionHandler<ReqT> finalBlockingHandler = blockingHandler;
            BlockingServerInterceptor.this.virtualThreadExecutor.execute(() -> {
                try {
                    finalBlockingHandler.call();
                    Consumer<ServerCall.Listener<ReqT>> next = this.incomingEvents.poll();
                    if (next != null) {
                        this.executeVirtualWithRequestContext(next);
                    } else {
                        this.isConsumingFromIncomingEvents = false;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }

        public void onMessage(ReqT message) {
            this.scheduleOrEnqueue(t -> t.onMessage(message));
        }

        public void onHalfClose() {
            this.scheduleOrEnqueue(ServerCall.Listener::onHalfClose);
        }

        public void onCancel() {
            this.scheduleOrEnqueue(ServerCall.Listener::onCancel);
        }

        public void onComplete() {
            this.scheduleOrEnqueue(ServerCall.Listener::onComplete);
        }

        public void onReady() {
            this.scheduleOrEnqueue(ServerCall.Listener::onReady);
        }
    }

    private class ReplayListener<ReqT>
    extends ServerCall.Listener<ReqT> {
        private final InjectableContext.ContextState requestContextState;
        private ServerCall.Listener<ReqT> delegate;
        private final Queue<Consumer<ServerCall.Listener<ReqT>>> incomingEvents = new LinkedList<Consumer<ServerCall.Listener<ReqT>>>();
        private boolean isConsumingFromIncomingEvents = false;

        private ReplayListener(InjectableContext.ContextState requestContextState) {
            this.requestContextState = requestContextState;
        }

        void setDelegate(ServerCall.Listener<ReqT> delegate) {
            Consumer<ServerCall.Listener<ReqT>> consumer;
            this.delegate = delegate;
            if (!this.isConsumingFromIncomingEvents && (consumer = this.incomingEvents.poll()) != null) {
                this.executeBlockingWithRequestContext(consumer);
            }
        }

        private void scheduleOrEnqueue(Consumer<ServerCall.Listener<ReqT>> consumer) {
            if (this.delegate != null && !this.isConsumingFromIncomingEvents) {
                this.executeBlockingWithRequestContext(consumer);
            } else {
                this.incomingEvents.add(consumer);
            }
        }

        private void executeBlockingWithRequestContext(Consumer<ServerCall.Listener<ReqT>> consumer) {
            Context grpcContext = Context.current();
            Callable<Void> blockingHandler = new BlockingExecutionHandler<ReqT>(consumer, grpcContext, this.delegate, this.requestContextState, BlockingServerInterceptor.this.getRequestContext(), (Object)this);
            if (BlockingServerInterceptor.this.devMode) {
                blockingHandler = new DevModeBlockingExecutionHandler(Thread.currentThread().getContextClassLoader(), blockingHandler);
            }
            this.isConsumingFromIncomingEvents = true;
            BlockingServerInterceptor.this.vertx.executeBlocking(blockingHandler, true).onComplete(p -> {
                Consumer<ServerCall.Listener<ReqT>> next = this.incomingEvents.poll();
                if (next != null) {
                    this.executeBlockingWithRequestContext(next);
                } else {
                    this.isConsumingFromIncomingEvents = false;
                }
            });
        }

        public void onMessage(ReqT message) {
            this.scheduleOrEnqueue(t -> t.onMessage(message));
        }

        public void onHalfClose() {
            this.scheduleOrEnqueue(ServerCall.Listener::onHalfClose);
        }

        public void onCancel() {
            this.scheduleOrEnqueue(ServerCall.Listener::onCancel);
        }

        public void onComplete() {
            this.scheduleOrEnqueue(ServerCall.Listener::onComplete);
        }

        public void onReady() {
            this.scheduleOrEnqueue(ServerCall.Listener::onReady);
        }
    }
}

