/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.deployment;

import io.quarkus.hibernate.orm.deployment.JpaModelPersistenceUnitMappingBuildItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

public final class EntityToPersistenceUnitUtil {
    private EntityToPersistenceUnitUtil() {
    }

    public static Map<String, String> determineEntityPersistenceUnits(Optional<JpaModelPersistenceUnitMappingBuildItem> jpaModelPersistenceUnitMapping, Set<String> candidates, String source) {
        if (jpaModelPersistenceUnitMapping.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Map collectedEntityToPersistenceUnits = jpaModelPersistenceUnitMapping.get().getEntityToPersistenceUnits();
        TreeMap<String, Set> violatingEntities = new TreeMap<String, Set>();
        for (Map.Entry entry : collectedEntityToPersistenceUnits.entrySet()) {
            String entityName = (String)entry.getKey();
            Set selectedPersistenceUnits = (Set)entry.getValue();
            boolean isCandidate = candidates.contains(entityName);
            if (!isCandidate) continue;
            if (selectedPersistenceUnits.size() == 1) {
                result.put(entityName, (String)selectedPersistenceUnits.iterator().next());
                continue;
            }
            violatingEntities.put(entityName, selectedPersistenceUnits);
        }
        if (violatingEntities.size() > 0) {
            StringBuilder message = new StringBuilder(String.format("%s entities do not support being attached to several persistence units:\n", source));
            Iterator iterator = violatingEntities.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry violatingEntityEntry = iterator.next();
                message.append("\t- ").append((String)violatingEntityEntry.getKey()).append(" is attached to: ").append(String.join((CharSequence)",", (Iterable)violatingEntityEntry.getValue()));
                throw new IllegalStateException(message.toString());
            }
        }
        return result;
    }
}

