/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxrs.client.reactive.deployment;

import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.Types;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.jaxrs.client.reactive.deployment.ClassRestClientContext;
import io.quarkus.jaxrs.client.reactive.deployment.JaxrsClientReactiveEnricherBuildItem;
import io.quarkus.jaxrs.client.reactive.deployment.MediaTypeWithPriority;
import io.quarkus.jaxrs.client.reactive.deployment.RestClientDefaultConsumesBuildItem;
import io.quarkus.jaxrs.client.reactive.deployment.RestClientDefaultProducesBuildItem;
import io.quarkus.jaxrs.client.reactive.deployment.RestClientDisableSmartDefaultProduces;
import io.quarkus.jaxrs.client.reactive.runtime.ClientResponseBuilderFactory;
import io.quarkus.jaxrs.client.reactive.runtime.JaxrsClientReactiveRecorder;
import io.quarkus.jaxrs.client.reactive.runtime.RestClientBase;
import io.quarkus.jaxrs.client.reactive.runtime.ToObjectArray;
import io.quarkus.jaxrs.client.reactive.runtime.impl.MultipartResponseDataBase;
import io.quarkus.resteasy.reactive.common.deployment.ApplicationResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.QuarkusFactoryCreator;
import io.quarkus.resteasy.reactive.common.deployment.QuarkusResteasyReactiveDotNames;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.SerializersUtil;
import io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveCommonRecorder;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderOverrideBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterOverrideBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.buffer.Buffer;
import java.io.Closeable;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.CompletionStageRxInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.RxInvoker;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.apache.http.entity.ContentType;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.handlers.ClientObservabilityHandler;
import org.jboss.resteasy.reactive.client.impl.AbstractRxInvoker;
import org.jboss.resteasy.reactive.client.impl.AsyncInvokerImpl;
import org.jboss.resteasy.reactive.client.impl.ClientBuilderImpl;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.MultiInvoker;
import org.jboss.resteasy.reactive.client.impl.UniInvoker;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartForm;
import org.jboss.resteasy.reactive.client.processor.beanparam.BeanParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.ClientBeanParamInfo;
import org.jboss.resteasy.reactive.client.processor.beanparam.CookieParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.FormParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.HeaderParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.Item;
import org.jboss.resteasy.reactive.client.processor.beanparam.PathParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.QueryParamItem;
import org.jboss.resteasy.reactive.client.processor.scanning.ClientEndpointIndexer;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.client.spi.FieldFiller;
import org.jboss.resteasy.reactive.client.spi.MultipartResponseData;
import org.jboss.resteasy.reactive.common.ResteasyReactiveConfig;
import org.jboss.resteasy.reactive.common.core.GenericTypeMapping;
import org.jboss.resteasy.reactive.common.core.ResponseBuilderFactory;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.model.MaybeRestClientInterface;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;
import org.jboss.resteasy.reactive.common.model.RestClientInterface;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaderWriter;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaders;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.common.processor.HashUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ResourceScanningResult;
import org.jboss.resteasy.reactive.multipart.FileDownload;

public class JaxrsClientReactiveProcessor {
    private static final Logger log = Logger.getLogger(JaxrsClientReactiveProcessor.class);
    private static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("//+");
    private static final MethodDescriptor WEB_TARGET_RESOLVE_TEMPLATE_METHOD = MethodDescriptor.ofMethod(WebTarget.class, (String)"resolveTemplate", WebTarget.class, (Class[])new Class[]{String.class, Object.class});
    private static final MethodDescriptor MULTIVALUED_MAP_ADD = MethodDescriptor.ofMethod(MultivaluedMap.class, (String)"add", Void.TYPE, (Class[])new Class[]{Object.class, Object.class});
    private static final MethodDescriptor PATH_GET_FILENAME = MethodDescriptor.ofMethod(Path.class, (String)"getFileName", Path.class, (Class[])new Class[0]);
    private static final MethodDescriptor OBJECT_TO_STRING = MethodDescriptor.ofMethod(Object.class, (String)"toString", String.class, (Class[])new Class[0]);
    static final DotName CONTINUATION = DotName.createSimple((String)"kotlin.coroutines.Continuation");
    private static final DotName UNI_KT = DotName.createSimple((String)"io.smallrye.mutiny.coroutines.UniKt");
    private static final DotName FILE = DotName.createSimple((String)File.class.getName());
    private static final DotName PATH = DotName.createSimple((String)Path.class.getName());
    private static final DotName BUFFER = DotName.createSimple((String)Buffer.class.getName());
    private static final Set<DotName> ASYNC_RETURN_TYPES = Set.of(ResteasyReactiveDotNames.COMPLETION_STAGE, ResteasyReactiveDotNames.UNI, ResteasyReactiveDotNames.MULTI);
    public static final DotName BYTE = DotName.createSimple((String)Byte.class.getName());
    public static final MethodDescriptor MULTIPART_RESPONSE_DATA_ADD_FILLER = MethodDescriptor.ofMethod(MultipartResponseDataBase.class, (String)"addFiller", Void.TYPE, (Class[])new Class[]{FieldFiller.class});

    @BuildStep
    void addFeature(BuildProducer<FeatureBuildItem> features) {
        features.produce((BuildItem)new FeatureBuildItem(Feature.JAXRS_CLIENT_REACTIVE));
    }

    @BuildStep
    void registerClientResponseBuilder(BuildProducer<ServiceProviderBuildItem> serviceProviders) {
        serviceProviders.produce((BuildItem)new ServiceProviderBuildItem(ResponseBuilderFactory.class.getName(), new String[]{ClientResponseBuilderFactory.class.getName()}));
        serviceProviders.produce((BuildItem)new ServiceProviderBuildItem(ClientBuilder.class.getName(), new String[]{ClientBuilderImpl.class.getName()}));
    }

    @BuildStep
    void initializeRuntimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClasses) {
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(AsyncInvokerImpl.class.getName()));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupClientProxies(JaxrsClientReactiveRecorder recorder, BeanContainerBuildItem beanContainerBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, final BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyBuildItemBuildProducer, List<MessageBodyReaderBuildItem> messageBodyReaderBuildItems, List<MessageBodyWriterBuildItem> messageBodyWriterBuildItems, List<MessageBodyReaderOverrideBuildItem> messageBodyReaderOverrideBuildItems, List<MessageBodyWriterOverrideBuildItem> messageBodyWriterOverrideBuildItems, List<JaxrsClientReactiveEnricherBuildItem> enricherBuildItems, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, ApplicationIndexBuildItem applicationIndexBuildItem, Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsCapability, io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveConfig config, RecorderContext recorderContext, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformerBuildItemBuildProducer, List<RestClientDefaultProducesBuildItem> defaultConsumes, List<RestClientDefaultConsumesBuildItem> defaultProduces, List<RestClientDisableSmartDefaultProduces> disableSmartDefaultProduces) {
        String defaultConsumesType = this.defaultMediaType(defaultConsumes, "application/octet-stream");
        String defaultProducesType = this.defaultMediaType(defaultProduces, "text/plain");
        Serialisers serialisers = recorder.createSerializers();
        SerializersUtil.setupSerializers((ResteasyReactiveCommonRecorder)recorder, reflectiveClassBuildItemBuildProducer, messageBodyReaderBuildItems, messageBodyWriterBuildItems, messageBodyReaderOverrideBuildItems, messageBodyWriterOverrideBuildItems, (BeanContainerBuildItem)beanContainerBuildItem, (ApplicationResultBuildItem)applicationResultBuildItem, (Serialisers)serialisers, (RuntimeType)RuntimeType.CLIENT);
        if (resourceScanningResultBuildItem.isEmpty() || resourceScanningResultBuildItem.get().getResult().getClientInterfaces().isEmpty()) {
            recorder.setupClientProxies(new HashMap(), Collections.emptyMap());
            return;
        }
        ResourceScanningResult result = resourceScanningResultBuildItem.get().getResult();
        AdditionalReaders additionalReaders = new AdditionalReaders();
        AdditionalWriters additionalWriters = new AdditionalWriters();
        final IndexView index = beanArchiveIndexBuildItem.getIndex();
        ClientEndpointIndexer clientEndpointIndexer = ((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)new ClientEndpointIndexer.Builder().setIndex(index)).setApplicationIndex((IndexView)applicationIndexBuildItem.getIndex())).setExistingConverters(new HashMap())).setScannedResourcePaths(result.getScannedResourcePaths())).setConfig(this.createRestReactiveConfig(config))).setAdditionalReaders(additionalReaders)).setHttpAnnotationToMethod(result.getHttpAnnotationToMethod())).setInjectableBeans(new HashMap())).setFactoryCreator((Function)new QuarkusFactoryCreator((ResteasyReactiveCommonRecorder)recorder, beanContainerBuildItem.getValue()))).setAdditionalWriters(additionalWriters)).setDefaultBlocking(applicationResultBuildItem.getResult().getBlockingDefault())).setHasRuntimeConverters(false)).setDefaultProduces(defaultProducesType).setSmartDefaultProduces(disableSmartDefaultProduces.isEmpty()).setResourceMethodCallback((Consumer)new Consumer<EndpointIndexer.ResourceMethodCallbackData>(){

            @Override
            public void accept(EndpointIndexer.ResourceMethodCallbackData entry) {
                MethodInfo method = entry.getMethodInfo();
                String source = JaxrsClientReactiveProcessor.class.getSimpleName() + " > " + method.declaringClass() + "[" + method + "]";
                reflectiveHierarchyBuildItemBuildProducer.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(method.returnType()).index(index).ignoreTypePredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
            }
        })).build();
        boolean observabilityIntegrationNeeded = capabilities.isPresent("io.quarkus.opentelemetry.tracer") || metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer");
        HashMap clientImplementations = new HashMap();
        HashMap<String, String> failures = new HashMap<String, String>();
        HashSet<ClassInfo> multipartResponseTypes = new HashSet<ClassInfo>();
        for (AnnotationInstance annotationInstance : index.getAnnotations(ResteasyReactiveDotNames.MULTI_PART_FORM_PARAM)) {
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            multipartResponseTypes.add(annotationInstance.target().asClass());
        }
        for (Map.Entry entry : result.getClientInterfaces().entrySet()) {
            ClassInfo clazz = index.getClassByName((DotName)entry.getKey());
            MaybeRestClientInterface maybeClientProxy = clientEndpointIndexer.createClientProxy(clazz, (String)entry.getValue());
            if (maybeClientProxy.exists()) {
                RestClientInterface clientProxy = maybeClientProxy.getRestClientInterface();
                try {
                    RuntimeValue<BiFunction<WebTarget, List<ParamConverterProvider>, ?>> proxyProvider = this.generateClientInvoker(recorderContext, clientProxy, enricherBuildItems, generatedClassBuildItemBuildProducer, clazz, index, defaultConsumesType, result.getHttpAnnotationToMethod(), observabilityIntegrationNeeded, multipartResponseTypes);
                    if (proxyProvider == null) continue;
                    clientImplementations.put(clientProxy.getClassName(), proxyProvider);
                }
                catch (Exception any) {
                    log.debugv((Throwable)any, "Failed to create client proxy for {0} this can usually be safely ignored", (Object)clazz.name());
                    failures.put(clazz.name().toString(), any.getMessage());
                }
                continue;
            }
            failures.put(clazz.name().toString(), maybeClientProxy.getFailure());
        }
        recorder.setupClientProxies(clientImplementations, failures);
        for (AdditionalReaderWriter.Entry entry : additionalReaders.get()) {
            String readerClass = entry.getHandlerClass();
            ResourceReader reader = new ResourceReader();
            reader.setBuiltin(true);
            reader.setFactory(recorder.factory(readerClass, beanContainerBuildItem.getValue()));
            reader.setMediaTypeStrings(Collections.singletonList(entry.getMediaType()));
            recorder.registerReader(serialisers, entry.getEntityClass(), reader);
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{readerClass}));
        }
        for (AdditionalReaderWriter.Entry entry : additionalWriters.get()) {
            String writerClass = entry.getHandlerClass();
            ResourceWriter writer = new ResourceWriter();
            writer.setBuiltin(true);
            writer.setFactory(recorder.factory(writerClass, beanContainerBuildItem.getValue()));
            writer.setMediaTypeStrings(Collections.singletonList(entry.getMediaType()));
            recorder.registerWriter(serialisers, entry.getEntityClass(), writer);
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{writerClass}));
        }
        HashMap<String, RuntimeValue<MultipartResponseData>> responsesData = new HashMap<String, RuntimeValue<MultipartResponseData>>();
        for (ClassInfo multipartResponseType : multipartResponseTypes) {
            responsesData.put(multipartResponseType.toString(), this.createMultipartResponseData(multipartResponseType, generatedClassBuildItemBuildProducer, recorderContext));
        }
        recorder.setMultipartResponsesData(responsesData);
    }

    private RuntimeValue<MultipartResponseData> createMultipartResponseData(ClassInfo multipartResponseTypeInfo, BuildProducer<GeneratedClassBuildItem> generatedClasses, RecorderContext context) {
        String multipartResponseType = multipartResponseTypeInfo.toString();
        String dataClassName = multipartResponseType + "$$MultipartData";
        try (ClassCreator c = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClasses, true), dataClassName, null, MultipartResponseDataBase.class.getName(), new String[0]);){
            MethodCreator newInstance = c.getMethodCreator("newInstance", Object.class, new Class[0]);
            newInstance.returnValue(newInstance.newInstance(MethodDescriptor.ofConstructor((String)multipartResponseType, (String[])new String[0]), new ResultHandle[0]));
            MethodCreator constructor = c.getMethodCreator(MethodDescriptor.ofConstructor((String)multipartResponseType, (String[])new String[0]));
            constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(MultipartResponseDataBase.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
            HashMap<String, AnnotationInstance> nonPublicPartTypeFields = new HashMap<String, AnnotationInstance>();
            for (FieldInfo field : multipartResponseTypeInfo.fields()) {
                AnnotationInstance partType = field.annotation(ResteasyReactiveDotNames.PART_TYPE_NAME);
                if (partType == null) {
                    log.debugf("Skipping field %s.%s from multipart mapping because it is not annotated with @PartType", (Object)multipartResponseType, (Object)field.name());
                    continue;
                }
                if (!Modifier.isPublic(field.flags())) {
                    nonPublicPartTypeFields.put(field.name(), partType);
                    continue;
                }
                String partName = this.extractPartName(partType.target(), field.name());
                String fillerName = this.createFieldFillerForField(partType, field, partName, generatedClasses, dataClassName);
                constructor.invokeVirtualMethod(MULTIPART_RESPONSE_DATA_ADD_FILLER, constructor.getThis(), new ResultHandle[]{constructor.newInstance(MethodDescriptor.ofConstructor((String)fillerName, (String[])new String[0]), new ResultHandle[0])});
            }
            for (MethodInfo method : multipartResponseTypeInfo.methods()) {
                String methodName = method.name();
                if (!methodName.startsWith("set") || method.parameters().size() != 1) continue;
                String fieldName = this.setterToFieldName(methodName);
                AnnotationInstance partType = this.partTypeFromGetterOrSetter(method);
                if (partType != null || (partType = (AnnotationInstance)nonPublicPartTypeFields.get(fieldName)) != null) {
                    String partName = this.extractPartName(partType.target(), fieldName);
                    String fillerName = this.createFieldFillerForSetter(partType, method, partName, generatedClasses, dataClassName);
                    constructor.invokeVirtualMethod(MULTIPART_RESPONSE_DATA_ADD_FILLER, constructor.getThis(), new ResultHandle[]{constructor.newInstance(MethodDescriptor.ofConstructor((String)fillerName, (String[])new String[0]), new ResultHandle[0])});
                    continue;
                }
                log.debugf("Ignoring possible setter " + methodName + ", no part type annotation found", new Object[0]);
            }
            constructor.returnValue(null);
        }
        return context.newInstance(dataClassName);
    }

    private String extractPartName(AnnotationTarget target, String fieldName) {
        AnnotationInstance formParam;
        AnnotationInstance restForm;
        switch (target.kind()) {
            case FIELD: {
                restForm = target.asField().annotation(ResteasyReactiveDotNames.REST_FORM_PARAM);
                formParam = target.asField().annotation(ResteasyReactiveDotNames.FORM_PARAM);
                break;
            }
            case METHOD: {
                restForm = target.asMethod().annotation(ResteasyReactiveDotNames.REST_FORM_PARAM);
                formParam = target.asMethod().annotation(ResteasyReactiveDotNames.FORM_PARAM);
                break;
            }
            default: {
                throw new IllegalArgumentException("PartType annotation is only supported on fields and (setter/getter) methods for multipart responses, found one on " + target);
            }
        }
        return this.getAnnotationValueOrDefault(fieldName, restForm, formParam);
    }

    private String getAnnotationValueOrDefault(String fieldName, AnnotationInstance restForm, AnnotationInstance formParam) {
        if (restForm != null) {
            AnnotationValue restFormValue = restForm.value();
            return restFormValue == null ? fieldName : restFormValue.asString();
        }
        if (formParam != null) {
            return formParam.value().asString();
        }
        return fieldName;
    }

    private String createFieldFillerForSetter(AnnotationInstance partType, MethodInfo setter, String partName, BuildProducer<GeneratedClassBuildItem> generatedClasses, String dataClassName) {
        String fillerClassName = dataClassName + "$$" + setter.name();
        try (ClassCreator c = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClasses, true), fillerClassName, null, FieldFiller.class.getName(), new String[0]);){
            org.jboss.jandex.Type parameter = (org.jboss.jandex.Type)setter.parameters().get(0);
            this.createFieldFillerConstructor(partType, parameter, partName, fillerClassName, c);
            MethodCreator set = c.getMethodCreator(MethodDescriptor.ofMethod((Object)fillerClassName, (String)"set", Void.TYPE, (Object[])new Object[]{Object.class, Object.class}));
            ResultHandle value = set.getMethodParam(1);
            value = this.performValueConversion(parameter, set, value);
            set.invokeVirtualMethod(setter, set.getMethodParam(0), new ResultHandle[]{value});
            set.returnValue(null);
        }
        return fillerClassName;
    }

    private ResultHandle performValueConversion(org.jboss.jandex.Type parameter, MethodCreator set, ResultHandle value) {
        if (parameter.kind() == Type.Kind.CLASS) {
            if (parameter.asClassType().name().equals((Object)FILE)) {
                value = set.invokeStaticMethod(MethodDescriptor.ofMethod(FieldFiller.class, (String)"fileDownloadToFile", File.class, (Class[])new Class[]{FileDownload.class}), new ResultHandle[]{value});
            } else if (parameter.asClassType().name().equals((Object)PATH)) {
                value = set.invokeStaticMethod(MethodDescriptor.ofMethod(FieldFiller.class, (String)"fileDownloadToPath", Path.class, (Class[])new Class[]{FileDownload.class}), new ResultHandle[]{value});
            }
        }
        return value;
    }

    private String createFieldFillerForField(AnnotationInstance partType, FieldInfo field, String partName, BuildProducer<GeneratedClassBuildItem> generatedClasses, String dataClassName) {
        String fillerClassName = dataClassName + "$$" + field.name();
        try (ClassCreator c = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClasses, true), fillerClassName, null, FieldFiller.class.getName(), new String[0]);){
            this.createFieldFillerConstructor(partType, field.type(), partName, fillerClassName, c);
            MethodCreator set = c.getMethodCreator(MethodDescriptor.ofMethod((Object)fillerClassName, (String)"set", Void.TYPE, (Object[])new Object[]{Object.class, Object.class}));
            ResultHandle value = set.getMethodParam(1);
            value = this.performValueConversion(field.type(), set, value);
            set.writeInstanceField(field, set.getMethodParam(0), value);
            set.returnValue(null);
        }
        return fillerClassName;
    }

    private void createFieldFillerConstructor(AnnotationInstance partType, org.jboss.jandex.Type type, String partName, String fillerClassName, ClassCreator c) {
        ResultHandle genericType;
        MethodCreator ctor = c.getMethodCreator(MethodDescriptor.ofConstructor((String)fillerClassName, (String[])new String[0]));
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            genericType = this.createGenericTypeFromParameterizedType(ctor, type.asParameterizedType());
        } else if (type.kind() == Type.Kind.CLASS) {
            genericType = ctor.newInstance(MethodDescriptor.ofConstructor(GenericType.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{ctor.loadClass(type.asClassType().name().toString())});
        } else if (type.kind() == Type.Kind.ARRAY) {
            genericType = ctor.newInstance(MethodDescriptor.ofConstructor(GenericType.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{ctor.loadClass(type.asArrayType().name().toString())});
        } else {
            if (type.kind() == Type.Kind.PRIMITIVE) {
                throw new IllegalArgumentException("Primitive types are not supported for multipart response mapping. Please use a wrapper class instead");
            }
            throw new IllegalArgumentException("Unsupported field type for multipart response mapping: " + type + ". Only classes, arrays and parameterized types are supported");
        }
        ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(FieldFiller.class, (Class[])new Class[]{GenericType.class, String.class, String.class}), ctor.getThis(), new ResultHandle[]{genericType, ctor.load(partName), ctor.load(partType.value().asString())});
        ctor.returnValue(null);
    }

    private AnnotationInstance partTypeFromGetterOrSetter(MethodInfo setter) {
        AnnotationInstance partTypeAnno = setter.annotation(ResteasyReactiveDotNames.PART_TYPE_NAME);
        if (partTypeAnno != null) {
            return partTypeAnno;
        }
        String getterName = setter.name().replaceFirst("s", "g");
        MethodInfo getter = setter.declaringClass().method(getterName, new org.jboss.jandex.Type[0]);
        if (getter != null && null != (partTypeAnno = getter.annotation(ResteasyReactiveDotNames.PART_TYPE_NAME))) {
            return partTypeAnno;
        }
        return null;
    }

    private String setterToFieldName(String methodName) {
        if (methodName.length() <= 3) {
            return "";
        }
        char[] nameArray = methodName.toCharArray();
        nameArray[3] = Character.toLowerCase(nameArray[3]);
        return new String(nameArray, 3, nameArray.length - 3);
    }

    private ResteasyReactiveConfig createRestReactiveConfig(io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveConfig config) {
        Config mpConfig = ConfigProvider.getConfig();
        return new ResteasyReactiveConfig(this.getEffectivePropertyValue("input-buffer-size", config.inputBufferSize.asLongValue(), Long.class, mpConfig).longValue(), this.getEffectivePropertyValue("output-buffer-size", config.outputBufferSize, Integer.class, mpConfig).intValue(), this.getEffectivePropertyValue("single-default-produces", config.singleDefaultProduces, Boolean.class, mpConfig).booleanValue(), this.getEffectivePropertyValue("default-produces", config.defaultProduces, Boolean.class, mpConfig).booleanValue());
    }

    private <T> T getEffectivePropertyValue(String legacyPropertyName, T newPropertyValue, Class<T> propertyType, Config mpConfig) {
        Optional legacyPropertyValue = mpConfig.getOptionalValue("quarkus.rest." + legacyPropertyName, propertyType);
        if (legacyPropertyValue.isPresent()) {
            return legacyPropertyValue.get();
        }
        return newPropertyValue;
    }

    private String defaultMediaType(List<? extends MediaTypeWithPriority> defaultMediaTypes, String defaultMediaType) {
        if (defaultMediaTypes == null || defaultMediaTypes.isEmpty()) {
            return defaultMediaType;
        }
        defaultMediaTypes.sort(Comparator.comparingInt(MediaTypeWithPriority::getPriority));
        return defaultMediaTypes.get(0).getMediaType();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void registerInvocationCallbacks(CombinedIndexBuildItem index, JaxrsClientReactiveRecorder recorder) {
        Collection invocationCallbacks = index.getComputingIndex().getAllKnownImplementors(ResteasyReactiveDotNames.INVOCATION_CALLBACK);
        GenericTypeMapping genericTypeMapping = new GenericTypeMapping();
        for (ClassInfo invocationCallback : invocationCallbacks) {
            try {
                List typeParameters = JandexUtil.resolveTypeParameters((DotName)invocationCallback.name(), (DotName)ResteasyReactiveDotNames.INVOCATION_CALLBACK, (IndexView)index.getComputingIndex());
                recorder.registerInvocationHandlerGenericType(genericTypeMapping, invocationCallback.name().toString(), ((org.jboss.jandex.Type)typeParameters.get(0)).name().toString());
            }
            catch (Exception exception) {}
        }
        recorder.setGenericTypeMapping(genericTypeMapping);
    }

    private RuntimeValue<BiFunction<WebTarget, List<ParamConverterProvider>, ?>> generateClientInvoker(RecorderContext recorderContext, RestClientInterface restClientInterface, List<JaxrsClientReactiveEnricherBuildItem> enrichers, BuildProducer<GeneratedClassBuildItem> generatedClasses, ClassInfo interfaceClass, IndexView index, String defaultMediaType, Map<DotName, String> httpAnnotationToMethod, boolean observabilityIntegrationNeeded, Set<ClassInfo> multipartResponseTypes) {
        String creatorName = restClientInterface.getClassName() + "$$QuarkusRestClientInterfaceCreator";
        String name = restClientInterface.getClassName() + "$$QuarkusRestClientInterface";
        MethodDescriptor constructorDesc = MethodDescriptor.ofConstructor((Object)name, (Object[])new Object[]{WebTarget.class.getName(), List.class});
        try (ClassRestClientContext classContext = new ClassRestClientContext(name, constructorDesc, generatedClasses, RestClientBase.class, Closeable.class.getName(), restClientInterface.getClassName());){
            classContext.constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(RestClientBase.class, (Class[])new Class[]{List.class}), classContext.constructor.getThis(), new ResultHandle[]{classContext.constructor.getMethodParam(1)});
            AssignableResultHandle baseTarget = classContext.constructor.createVariable(WebTarget.class);
            classContext.constructor.assign(baseTarget, classContext.constructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"path", WebTarget.class, (Class[])new Class[]{String.class}), classContext.constructor.getMethodParam(0), new ResultHandle[]{classContext.constructor.load(restClientInterface.getPath())}));
            for (JaxrsClientReactiveEnricherBuildItem enricher : enrichers) {
                enricher.getEnricher().forClass(classContext.constructor, baseTarget, interfaceClass, index);
            }
            int methodIndex = 0;
            ArrayList<FieldDescriptor> webTargets = new ArrayList<FieldDescriptor>();
            for (ResourceMethod method : restClientInterface.getMethods()) {
                ++methodIndex;
                String[] javaMethodParameters = new String[method.getParameters().length];
                for (int i = 0; i < method.getParameters().length; ++i) {
                    MethodParameter param = method.getParameters()[i];
                    javaMethodParameters[i] = param.declaredType != null ? param.declaredType : param.type;
                }
                MethodInfo jandexMethod = this.getJavaMethod(interfaceClass, method, method.getParameters(), index).orElseThrow(() -> new RuntimeException("Failed to find matching java method for " + method + " on " + interfaceClass + ". It may have unresolved parameter types (generics)"));
                if (!Modifier.isAbstract(jandexMethod.flags())) continue;
                if (method.getHttpMethod() == null) {
                    this.handleSubResourceMethod(enrichers, generatedClasses, interfaceClass, index, defaultMediaType, httpAnnotationToMethod, name, classContext, classContext.constructor, baseTarget, methodIndex, webTargets, method, javaMethodParameters, jandexMethod, multipartResponseTypes);
                    continue;
                }
                FieldDescriptor methodField = classContext.createJavaMethodField(interfaceClass, jandexMethod, methodIndex);
                Supplier<FieldDescriptor> methodParamAnnotationsField = classContext.getLazyJavaMethodParamAnnotationsField(methodIndex);
                Supplier<FieldDescriptor> methodGenericParametersField = classContext.getLazyJavaMethodGenericParametersField(methodIndex);
                this.addResponseTypeIfMultipart(multipartResponseTypes, jandexMethod, index);
                FieldDescriptor webTargetForMethod = FieldDescriptor.of((String)name, (String)("target" + methodIndex), WebTargetImpl.class);
                classContext.classCreator.getFieldCreator(webTargetForMethod).setModifiers(16);
                webTargets.add(webTargetForMethod);
                AssignableResultHandle constructorTarget = this.createWebTargetForMethod(classContext.constructor, baseTarget, method);
                classContext.constructor.writeInstanceField(webTargetForMethod, classContext.constructor.getThis(), (ResultHandle)constructorTarget);
                if (observabilityIntegrationNeeded) {
                    String templatePath = MULTIPLE_SLASH_PATTERN.matcher(restClientInterface.getPath() + method.getPath()).replaceAll("/");
                    classContext.constructor.invokeVirtualMethod(MethodDescriptor.ofMethod(WebTargetImpl.class, (String)"setPreClientSendHandler", Void.TYPE, (Class[])new Class[]{ClientRestHandler.class}), classContext.constructor.readInstanceField(webTargetForMethod, classContext.constructor.getThis()), new ResultHandle[]{classContext.constructor.newInstance(MethodDescriptor.ofConstructor(ClientObservabilityHandler.class, (Class[])new Class[]{String.class}), new ResultHandle[]{classContext.constructor.load(templatePath)})});
                }
                MethodCreator methodCreator = classContext.classCreator.getMethodCreator(method.getName(), method.getSimpleReturnType(), javaMethodParameters);
                AssignableResultHandle methodTarget = methodCreator.createVariable(WebTarget.class);
                methodCreator.assign(methodTarget, methodCreator.readInstanceField(webTargetForMethod, methodCreator.getThis()));
                Integer bodyParameterIdx = null;
                HashMap<MethodDescriptor, ResultHandle> invocationBuilderEnrichers = new HashMap<MethodDescriptor, ResultHandle>();
                ResultHandle multipartForm = null;
                AssignableResultHandle formParams = null;
                for (int paramIdx = 0; paramIdx < method.getParameters().length; ++paramIdx) {
                    AssignableResultHandle invocationBuilderRef;
                    MethodDescriptor handleHeaderDescriptor;
                    MethodParameter param = method.getParameters()[paramIdx];
                    if (param.parameterType == ParameterType.QUERY) {
                        methodCreator.assign(methodTarget, this.addQueryParam((BytecodeCreator)methodCreator, (ResultHandle)methodTarget, param.name, methodCreator.getMethodParam(paramIdx), (org.jboss.jandex.Type)jandexMethod.parameters().get(paramIdx), index, methodCreator.getThis(), methodCreator.readArrayValue(methodCreator.readStaticField(methodGenericParametersField.get()), paramIdx), methodCreator.readArrayValue(methodCreator.readStaticField(methodParamAnnotationsField.get()), paramIdx)));
                        continue;
                    }
                    if (param.parameterType == ParameterType.BEAN) {
                        ClientBeanParamInfo beanParam = (ClientBeanParamInfo)param;
                        MethodDescriptor handleBeanParamDescriptor = MethodDescriptor.ofMethod((Object)name, (String)(method.getName() + "$$" + methodIndex + "$$handleBeanParam$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                        MethodCreator handleBeanParamMethod = classContext.classCreator.getMethodCreator(handleBeanParamDescriptor);
                        AssignableResultHandle invocationBuilderRef2 = handleBeanParamMethod.createVariable(Invocation.Builder.class);
                        handleBeanParamMethod.assign(invocationBuilderRef2, handleBeanParamMethod.getMethodParam(0));
                        formParams = this.addBeanParamData((BytecodeCreator)methodCreator, (BytecodeCreator)handleBeanParamMethod, invocationBuilderRef2, beanParam.getItems(), methodCreator.getMethodParam(paramIdx), methodTarget, index, restClientInterface.getClassName(), methodCreator.getThis(), handleBeanParamMethod.getThis(), formParams, methodGenericParametersField, methodParamAnnotationsField, paramIdx);
                        handleBeanParamMethod.returnValue((ResultHandle)invocationBuilderRef2);
                        invocationBuilderEnrichers.put(handleBeanParamDescriptor, methodCreator.getMethodParam(paramIdx));
                        continue;
                    }
                    if (param.parameterType == ParameterType.PATH) {
                        this.addPathParam((BytecodeCreator)methodCreator, methodTarget, param.name, methodCreator.getMethodParam(paramIdx), param.type, methodCreator.getThis(), methodCreator.readArrayValue(methodCreator.readStaticField(methodGenericParametersField.get()), paramIdx), methodCreator.readArrayValue(methodCreator.readStaticField(methodParamAnnotationsField.get()), paramIdx));
                        continue;
                    }
                    if (param.parameterType == ParameterType.BODY) {
                        bodyParameterIdx = paramIdx;
                        continue;
                    }
                    if (param.parameterType == ParameterType.HEADER) {
                        handleHeaderDescriptor = MethodDescriptor.ofMethod((Object)name, (String)(method.getName() + "$$" + methodIndex + "$$handleHeader$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                        MethodCreator handleHeaderMethod = classContext.classCreator.getMethodCreator(handleHeaderDescriptor);
                        invocationBuilderRef = handleHeaderMethod.createVariable(Invocation.Builder.class);
                        handleHeaderMethod.assign(invocationBuilderRef, handleHeaderMethod.getMethodParam(0));
                        this.addHeaderParam((BytecodeCreator)handleHeaderMethod, invocationBuilderRef, param.name, handleHeaderMethod.getMethodParam(1), param.type, handleHeaderMethod.getThis(), methodGenericParametersField.get(), methodParamAnnotationsField.get(), paramIdx);
                        handleHeaderMethod.returnValue((ResultHandle)invocationBuilderRef);
                        invocationBuilderEnrichers.put(handleHeaderDescriptor, methodCreator.getMethodParam(paramIdx));
                        continue;
                    }
                    if (param.parameterType == ParameterType.COOKIE) {
                        handleHeaderDescriptor = MethodDescriptor.ofMethod((Object)name, (String)(method.getName() + "$$" + methodIndex + "$$handleCookie$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                        MethodCreator handleCookieMethod = classContext.classCreator.getMethodCreator(handleHeaderDescriptor);
                        invocationBuilderRef = handleCookieMethod.createVariable(Invocation.Builder.class);
                        handleCookieMethod.assign(invocationBuilderRef, handleCookieMethod.getMethodParam(0));
                        this.addCookieParam((BytecodeCreator)handleCookieMethod, invocationBuilderRef, param.name, handleCookieMethod.getMethodParam(1), param.type, handleCookieMethod.getThis(), methodGenericParametersField.get(), methodParamAnnotationsField.get(), paramIdx);
                        handleCookieMethod.returnValue((ResultHandle)invocationBuilderRef);
                        invocationBuilderEnrichers.put(handleHeaderDescriptor, methodCreator.getMethodParam(paramIdx));
                        continue;
                    }
                    if (param.parameterType == ParameterType.FORM) {
                        formParams = this.createIfAbsent((BytecodeCreator)methodCreator, formParams);
                        this.addFormParam((BytecodeCreator)methodCreator, param.name, methodCreator.getMethodParam(paramIdx), param.type, restClientInterface.getClassName(), methodCreator.getThis(), formParams, methodCreator.readArrayValue(methodCreator.readStaticField(methodGenericParametersField.get()), paramIdx), methodCreator.readArrayValue(methodCreator.readStaticField(methodParamAnnotationsField.get()), paramIdx));
                        continue;
                    }
                    if (param.parameterType != ParameterType.MULTI_PART_FORM) continue;
                    if (multipartForm != null) {
                        throw new IllegalArgumentException("MultipartForm data set twice for method " + jandexMethod.declaringClass().name() + "#" + jandexMethod.name());
                    }
                    multipartForm = this.createMultipartForm(methodCreator, methodCreator.getMethodParam(paramIdx), (org.jboss.jandex.Type)jandexMethod.parameters().get(paramIdx), index);
                }
                AssignableResultHandle builder = methodCreator.createVariable(Invocation.Builder.class);
                if (method.getProduces() == null || method.getProduces().length == 0) {
                    methodCreator.assign(builder, methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"request", Invocation.Builder.class, (Class[])new Class[0]), (ResultHandle)methodTarget, new ResultHandle[0]));
                } else {
                    ResultHandle array = methodCreator.newArray(String.class, method.getProduces().length);
                    for (int i = 0; i < method.getProduces().length; ++i) {
                        methodCreator.writeArrayValue(array, i, methodCreator.load(method.getProduces()[i]));
                    }
                    methodCreator.assign(builder, methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"request", Invocation.Builder.class, (Class[])new Class[]{String[].class}), (ResultHandle)methodTarget, new ResultHandle[]{array}));
                }
                for (Map.Entry invocationBuilderEnricher : invocationBuilderEnrichers.entrySet()) {
                    methodCreator.assign(builder, methodCreator.invokeVirtualMethod((MethodDescriptor)invocationBuilderEnricher.getKey(), methodCreator.getThis(), new ResultHandle[]{builder, (ResultHandle)invocationBuilderEnricher.getValue()}));
                }
                for (JaxrsClientReactiveEnricherBuildItem enricher : enrichers) {
                    enricher.getEnricher().forMethod(classContext.classCreator, classContext.constructor, classContext.clinit, methodCreator, interfaceClass, jandexMethod, builder, index, generatedClasses, methodIndex, methodField);
                }
                this.handleReturn(interfaceClass, defaultMediaType, method.getHttpMethod(), method.getConsumes(), jandexMethod, methodCreator, (ResultHandle)formParams, multipartForm, bodyParameterIdx == null ? null : methodCreator.getMethodParam(bodyParameterIdx.intValue()), builder);
            }
            classContext.constructor.returnValue(null);
            classContext.clinit.returnValue(null);
            MethodCreator closeCreator = classContext.classCreator.getMethodCreator(MethodDescriptor.ofMethod(Closeable.class, (String)"close", Void.TYPE, (Class[])new Class[0]));
            for (FieldDescriptor target : webTargets) {
                ResultHandle webTarget = closeCreator.readInstanceField(target, closeCreator.getThis());
                ResultHandle webTargetImpl = closeCreator.checkCast(webTarget, WebTargetImpl.class);
                ResultHandle restClient = closeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(WebTargetImpl.class, (String)"getRestClient", ClientImpl.class, (Class[])new Class[0]), webTargetImpl, new ResultHandle[0]);
                closeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(ClientImpl.class, (String)"close", Void.TYPE, (Class[])new Class[0]), restClient, new ResultHandle[0]);
            }
            closeCreator.returnValue(null);
        }
        try (ClassCreator c = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClasses, true), creatorName, null, Object.class.getName(), new String[]{BiFunction.class.getName()});){
            MethodCreator apply = c.getMethodCreator(MethodDescriptor.ofMethod((Object)creatorName, (String)"apply", Object.class, (Object[])new Object[]{Object.class, Object.class}));
            apply.returnValue(apply.newInstance(constructorDesc, new ResultHandle[]{apply.getMethodParam(0), apply.getMethodParam(1)}));
        }
        return recorderContext.newInstance(creatorName);
    }

    private void addResponseTypeIfMultipart(Set<ClassInfo> multipartResponseTypes, MethodInfo method, IndexView index) {
        AnnotationInstance produces = method.annotation(ResteasyReactiveDotNames.PRODUCES);
        if (produces == null) {
            produces = method.annotation(ResteasyReactiveDotNames.PRODUCES);
        }
        if (produces != null) {
            String[] producesValues;
            for (String producesValue : producesValues = produces.value().asStringArray()) {
                if (!producesValue.toLowerCase(Locale.ROOT).startsWith(ContentType.MULTIPART_FORM_DATA.getMimeType())) continue;
                multipartResponseTypes.add(this.returnTypeAsClass(method, index));
            }
        }
    }

    private ClassInfo returnTypeAsClass(MethodInfo jandexMethod, IndexView index) {
        org.jboss.jandex.Type result = jandexMethod.returnType();
        if (result.kind() == Type.Kind.CLASS) {
            return index.getClassByName(result.asClassType().name());
        }
        throw new IllegalArgumentException("multipart responses can only be mapped to non-generic classes, got " + result + " of type: " + result.kind());
    }

    /*
     * Could not resolve type clashes
     */
    private void handleSubResourceMethod(List<JaxrsClientReactiveEnricherBuildItem> enrichers, BuildProducer<GeneratedClassBuildItem> generatedClasses, ClassInfo interfaceClass, IndexView index, String defaultMediaType, Map<DotName, String> httpAnnotationToMethod, String name, ClassRestClientContext classContext, MethodCreator constructor, AssignableResultHandle baseTarget, int methodIndex, List<FieldDescriptor> webTargets, ResourceMethod method, String[] javaMethodParameters, MethodInfo jandexMethod, Set<ClassInfo> multipartResponseTypes) {
        org.jboss.jandex.Type returnType = jandexMethod.returnType();
        if (returnType.kind() != Type.Kind.CLASS) {
            throw new IllegalArgumentException("Sub resource type is not a class: " + returnType.name().toString());
        }
        ClassInfo subResourceInterface = index.getClassByName(returnType.name());
        if (!Modifier.isInterface(subResourceInterface.flags())) {
            throw new IllegalArgumentException("Client interface method: " + jandexMethod.declaringClass().name() + "#" + jandexMethod + " has no HTTP method annotation  (@GET, @POST, etc) and it's return type: " + returnType.name().toString() + " is not an interface. If it's a sub resource method, it has to return an interface. If it's not, it has to have one of the HTTP method annotations.");
        }
        classContext.createJavaMethodField(interfaceClass, jandexMethod, methodIndex);
        Supplier<FieldDescriptor> methodParamAnnotationsField = classContext.getLazyJavaMethodParamAnnotationsField(methodIndex);
        Supplier<FieldDescriptor> methodGenericParametersField = classContext.getLazyJavaMethodGenericParametersField(methodIndex);
        MethodCreator methodCreator = classContext.classCreator.getMethodCreator(method.getName(), method.getSimpleReturnType(), javaMethodParameters);
        String subName = subResourceInterface.name().toString() + HashUtil.sha1((String)name) + methodIndex;
        try (ClassRestClientContext subClassContext = new ClassRestClientContext(subName, generatedClasses, subResourceInterface.name().toString());){
            subClassContext.constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), subClassContext.constructor.getThis(), new ResultHandle[0]);
            ResultHandle subInstance = methodCreator.newInstance(MethodDescriptor.ofConstructor((String)subName, (String[])new String[0]), new ResultHandle[0]);
            HashMap<Integer, FieldDescriptor> paramFields = new HashMap<Integer, FieldDescriptor>();
            FieldDescriptor clientField = this.createRestClientField(name, classContext.classCreator, methodCreator, subClassContext.classCreator, subInstance);
            for (int i = 0; i < method.getParameters().length; ++i) {
                FieldDescriptor paramField = ((FieldCreator)subClassContext.classCreator.getFieldCreator("param" + i, method.getParameters()[i].type).setModifiers(1)).getFieldDescriptor();
                methodCreator.writeInstanceField(paramField, subInstance, methodCreator.getMethodParam(i));
                paramFields.put(i, paramField);
            }
            ResultHandle multipartForm = null;
            int subMethodIndex = 0;
            for (ResourceMethod subMethod : method.getSubResourceMethods()) {
                AssignableResultHandle invocationBuilderRef;
                MethodParameter param;
                int paramIdx;
                MethodInfo jandexSubMethod = this.getJavaMethod(subResourceInterface, subMethod, subMethod.getParameters(), index).orElseThrow(() -> new RuntimeException("Failed to find matching java method for " + subMethod + " on " + subResourceInterface + ". It may have unresolved parameter types (generics)"));
                FieldDescriptor subMethodField = subClassContext.createJavaMethodField(subResourceInterface, jandexSubMethod, ++subMethodIndex);
                Supplier<FieldDescriptor> subMethodParamAnnotationsField = subClassContext.getLazyJavaMethodParamAnnotationsField(subMethodIndex);
                Supplier<FieldDescriptor> subMethodGenericParametersField = subClassContext.getLazyJavaMethodGenericParametersField(subMethodIndex);
                FieldDescriptor webTargetForSubMethod = FieldDescriptor.of((String)name, (String)("target" + methodIndex + "_" + subMethodIndex), WebTarget.class);
                classContext.classCreator.getFieldCreator(webTargetForSubMethod).setModifiers(16);
                webTargets.add(webTargetForSubMethod);
                AssignableResultHandle constructorTarget = this.createWebTargetForMethod(constructor, baseTarget, method);
                if (subMethod.getPath() != null) {
                    this.appendPath(constructor, subMethod.getPath(), constructorTarget);
                }
                constructor.writeInstanceField(webTargetForSubMethod, constructor.getThis(), (ResultHandle)constructorTarget);
                FieldDescriptor subWebTarget = ((FieldCreator)subClassContext.classCreator.getFieldCreator("target" + subMethodIndex, WebTarget.class).setModifiers(1)).getFieldDescriptor();
                methodCreator.writeInstanceField(subWebTarget, subInstance, methodCreator.readInstanceField(webTargetForSubMethod, methodCreator.getThis()));
                MethodCreator subMethodCreator = subClassContext.classCreator.getMethodCreator(subMethod.getName(), jandexSubMethod.returnType().name().toString(), this.parametersAsStringArray(jandexSubMethod));
                AssignableResultHandle methodTarget = subMethodCreator.createVariable(WebTarget.class);
                subMethodCreator.assign(methodTarget, subMethodCreator.readInstanceField(subWebTarget, subMethodCreator.getThis()));
                ResultHandle bodyParameterValue = null;
                AssignableResultHandle formParams = null;
                HashMap<MethodDescriptor, ResultHandle> invocationBuilderEnrichers = new HashMap<MethodDescriptor, ResultHandle>();
                for (paramIdx = 0; paramIdx < method.getParameters().length; ++paramIdx) {
                    param = method.getParameters()[paramIdx];
                    ResultHandle paramValue = subMethodCreator.readInstanceField((FieldDescriptor)paramFields.get(paramIdx), subMethodCreator.getThis());
                    if (param.parameterType == ParameterType.QUERY) {
                        subMethodCreator.assign(methodTarget, this.addQueryParam((BytecodeCreator)subMethodCreator, (ResultHandle)methodTarget, param.name, paramValue, (org.jboss.jandex.Type)jandexMethod.parameters().get(paramIdx), index, subMethodCreator.readInstanceField(clientField, subMethodCreator.getThis()), subMethodCreator.readArrayValue(subMethodCreator.readStaticField(methodGenericParametersField.get()), paramIdx), subMethodCreator.readArrayValue(subMethodCreator.readStaticField(methodParamAnnotationsField.get()), paramIdx)));
                        continue;
                    }
                    if (param.parameterType == ParameterType.BEAN) {
                        ClientBeanParamInfo beanParam = (ClientBeanParamInfo)param;
                        MethodDescriptor handleBeanParamDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + methodIndex + "$$handleBeanParam$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                        MethodCreator handleBeanParamMethod = subClassContext.classCreator.getMethodCreator(handleBeanParamDescriptor);
                        AssignableResultHandle invocationBuilderRef2 = handleBeanParamMethod.createVariable(Invocation.Builder.class);
                        handleBeanParamMethod.assign(invocationBuilderRef2, handleBeanParamMethod.getMethodParam(0));
                        formParams = this.addBeanParamData((BytecodeCreator)subMethodCreator, (BytecodeCreator)handleBeanParamMethod, invocationBuilderRef2, beanParam.getItems(), paramValue, methodTarget, index, interfaceClass.name().toString(), subMethodCreator.readInstanceField(clientField, subMethodCreator.getThis()), handleBeanParamMethod.readInstanceField(clientField, handleBeanParamMethod.getThis()), formParams, methodGenericParametersField, methodParamAnnotationsField, paramIdx);
                        handleBeanParamMethod.returnValue((ResultHandle)invocationBuilderRef2);
                        invocationBuilderEnrichers.put(handleBeanParamDescriptor, paramValue);
                        continue;
                    }
                    if (param.parameterType == ParameterType.PATH) {
                        this.addPathParam((BytecodeCreator)subMethodCreator, methodTarget, param.name, paramValue, param.type, subMethodCreator.readInstanceField(clientField, subMethodCreator.getThis()), subMethodCreator.readArrayValue(subMethodCreator.readStaticField(methodGenericParametersField.get()), paramIdx), subMethodCreator.readArrayValue(subMethodCreator.readStaticField(methodParamAnnotationsField.get()), paramIdx));
                        continue;
                    }
                    if (param.parameterType == ParameterType.BODY) {
                        bodyParameterValue = paramValue;
                        continue;
                    }
                    if (param.parameterType == ParameterType.HEADER) {
                        MethodDescriptor handleHeaderDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + subMethodIndex + "$$handleHeader$$param" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                        MethodCreator handleHeaderMethod = subClassContext.classCreator.getMethodCreator(handleHeaderDescriptor);
                        invocationBuilderRef = handleHeaderMethod.createVariable(Invocation.Builder.class);
                        handleHeaderMethod.assign(invocationBuilderRef, handleHeaderMethod.getMethodParam(0));
                        this.addHeaderParam((BytecodeCreator)handleHeaderMethod, invocationBuilderRef, param.name, handleHeaderMethod.getMethodParam(1), param.type, handleHeaderMethod.readInstanceField(clientField, handleHeaderMethod.getThis()), methodGenericParametersField.get(), methodParamAnnotationsField.get(), paramIdx);
                        handleHeaderMethod.returnValue((ResultHandle)invocationBuilderRef);
                        invocationBuilderEnrichers.put(handleHeaderDescriptor, paramValue);
                        continue;
                    }
                    if (param.parameterType == ParameterType.COOKIE) {
                        MethodDescriptor handleCookieDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + subMethodIndex + "$$handleCookie$$param" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                        MethodCreator handleCookieMethod = subClassContext.classCreator.getMethodCreator(handleCookieDescriptor);
                        invocationBuilderRef = handleCookieMethod.createVariable(Invocation.Builder.class);
                        handleCookieMethod.assign(invocationBuilderRef, handleCookieMethod.getMethodParam(0));
                        this.addCookieParam((BytecodeCreator)handleCookieMethod, invocationBuilderRef, param.name, handleCookieMethod.getMethodParam(1), param.type, handleCookieMethod.readInstanceField(clientField, handleCookieMethod.getThis()), methodGenericParametersField.get(), methodParamAnnotationsField.get(), paramIdx);
                        handleCookieMethod.returnValue((ResultHandle)invocationBuilderRef);
                        invocationBuilderEnrichers.put(handleCookieDescriptor, paramValue);
                        continue;
                    }
                    if (param.parameterType == ParameterType.FORM) {
                        formParams = this.createIfAbsent((BytecodeCreator)subMethodCreator, formParams);
                        subMethodCreator.invokeInterfaceMethod(MULTIVALUED_MAP_ADD, (ResultHandle)formParams, new ResultHandle[]{subMethodCreator.load(param.name), paramValue});
                        continue;
                    }
                    if (param.parameterType != ParameterType.MULTI_PART_FORM) continue;
                    if (multipartForm != null) {
                        throw new IllegalArgumentException("MultipartForm data set twice for method " + jandexSubMethod.declaringClass().name() + "#" + jandexSubMethod.name());
                    }
                    multipartForm = this.createMultipartForm(subMethodCreator, paramValue, (org.jboss.jandex.Type)((org.jboss.jandex.Type)jandexMethod.parameters().get(paramIdx)).asClassType(), index);
                }
                for (paramIdx = 0; paramIdx < subMethod.getParameters().length; ++paramIdx) {
                    AssignableResultHandle invocationBuilderRef3;
                    param = subMethod.getParameters()[paramIdx];
                    if (param.parameterType == ParameterType.QUERY) {
                        subMethodCreator.assign(methodTarget, this.addQueryParam((BytecodeCreator)subMethodCreator, (ResultHandle)methodTarget, param.name, subMethodCreator.getMethodParam(paramIdx), (org.jboss.jandex.Type)jandexSubMethod.parameters().get(paramIdx), index, subMethodCreator.readInstanceField(clientField, subMethodCreator.getThis()), subMethodCreator.readArrayValue(subMethodCreator.readStaticField(subMethodGenericParametersField.get()), paramIdx), subMethodCreator.readArrayValue(subMethodCreator.readStaticField(subMethodParamAnnotationsField.get()), paramIdx)));
                        continue;
                    }
                    if (param.parameterType == ParameterType.BEAN) {
                        ClientBeanParamInfo beanParam = (ClientBeanParamInfo)param;
                        MethodDescriptor handleBeanParamDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + subMethodIndex + "$$handleBeanParam$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                        MethodCreator handleBeanParamMethod = classContext.classCreator.getMethodCreator(handleBeanParamDescriptor);
                        invocationBuilderRef = handleBeanParamMethod.createVariable(Invocation.Builder.class);
                        handleBeanParamMethod.assign(invocationBuilderRef, handleBeanParamMethod.getMethodParam(0));
                        formParams = this.addBeanParamData((BytecodeCreator)subMethodCreator, (BytecodeCreator)handleBeanParamMethod, invocationBuilderRef, beanParam.getItems(), subMethodCreator.getMethodParam(paramIdx), methodTarget, index, interfaceClass.name().toString(), subMethodCreator.readInstanceField(clientField, subMethodCreator.getThis()), handleBeanParamMethod.readInstanceField(clientField, handleBeanParamMethod.getThis()), formParams, subMethodGenericParametersField, subMethodParamAnnotationsField, paramIdx);
                        handleBeanParamMethod.returnValue((ResultHandle)invocationBuilderRef);
                        invocationBuilderEnrichers.put(handleBeanParamDescriptor, subMethodCreator.getMethodParam(paramIdx));
                        continue;
                    }
                    if (param.parameterType == ParameterType.PATH) {
                        this.addPathParam((BytecodeCreator)subMethodCreator, methodTarget, param.name, subMethodCreator.getMethodParam(paramIdx), param.type, subMethodCreator.readInstanceField(clientField, subMethodCreator.getThis()), subMethodCreator.readArrayValue(subMethodCreator.readStaticField(subMethodGenericParametersField.get()), paramIdx), subMethodCreator.readArrayValue(subMethodCreator.readStaticField(subMethodParamAnnotationsField.get()), paramIdx));
                        continue;
                    }
                    if (param.parameterType == ParameterType.BODY) {
                        bodyParameterValue = subMethodCreator.getMethodParam(paramIdx);
                        continue;
                    }
                    if (param.parameterType == ParameterType.HEADER) {
                        MethodDescriptor handleHeaderDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + subMethodIndex + "$$handleHeader$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                        MethodCreator handleHeaderMethod = subClassContext.classCreator.getMethodCreator(handleHeaderDescriptor);
                        invocationBuilderRef3 = handleHeaderMethod.createVariable(Invocation.Builder.class);
                        handleHeaderMethod.assign(invocationBuilderRef3, handleHeaderMethod.getMethodParam(0));
                        this.addHeaderParam((BytecodeCreator)handleHeaderMethod, invocationBuilderRef3, param.name, handleHeaderMethod.getMethodParam(1), param.type, handleHeaderMethod.readInstanceField(clientField, handleHeaderMethod.getThis()), subMethodGenericParametersField.get(), subMethodParamAnnotationsField.get(), paramIdx);
                        handleHeaderMethod.returnValue((ResultHandle)invocationBuilderRef3);
                        invocationBuilderEnrichers.put(handleHeaderDescriptor, subMethodCreator.getMethodParam(paramIdx));
                        continue;
                    }
                    if (param.parameterType == ParameterType.COOKIE) {
                        MethodDescriptor handleCookieDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + subMethodIndex + "$$handleCookie$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                        MethodCreator handleCookieMethod = subClassContext.classCreator.getMethodCreator(handleCookieDescriptor);
                        invocationBuilderRef3 = handleCookieMethod.createVariable(Invocation.Builder.class);
                        handleCookieMethod.assign(invocationBuilderRef3, handleCookieMethod.getMethodParam(0));
                        this.addCookieParam((BytecodeCreator)handleCookieMethod, invocationBuilderRef3, param.name, handleCookieMethod.getMethodParam(1), param.type, handleCookieMethod.readInstanceField(clientField, handleCookieMethod.getThis()), subMethodGenericParametersField.get(), subMethodParamAnnotationsField.get(), paramIdx);
                        handleCookieMethod.returnValue((ResultHandle)invocationBuilderRef3);
                        invocationBuilderEnrichers.put(handleCookieDescriptor, subMethodCreator.getMethodParam(paramIdx));
                        continue;
                    }
                    if (param.parameterType == ParameterType.FORM) {
                        formParams = this.createIfAbsent((BytecodeCreator)subMethodCreator, formParams);
                        subMethodCreator.invokeInterfaceMethod(MULTIVALUED_MAP_ADD, (ResultHandle)formParams, new ResultHandle[]{subMethodCreator.load(param.name), subMethodCreator.getMethodParam(paramIdx)});
                        continue;
                    }
                    if (param.parameterType != ParameterType.MULTI_PART_FORM) continue;
                    if (multipartForm != null) {
                        throw new IllegalArgumentException("MultipartForm data set twice for method " + jandexSubMethod.declaringClass().name() + "#" + jandexSubMethod.name());
                    }
                    multipartForm = this.createMultipartForm(subMethodCreator, subMethodCreator.getMethodParam(paramIdx), (org.jboss.jandex.Type)jandexSubMethod.parameters().get(paramIdx), index);
                }
                if (subMethod.getHttpMethod() == null) {
                    String[] subJavaMethodParameters = new String[subMethod.getParameters().length];
                    for (int i = 0; i < subMethod.getParameters().length; ++i) {
                        MethodParameter param2 = subMethod.getParameters()[i];
                        subJavaMethodParameters[i] = param2.declaredType != null ? param2.declaredType : param2.type;
                    }
                    this.handleSubResourceMethod(enrichers, generatedClasses, subResourceInterface, index, defaultMediaType, httpAnnotationToMethod, subName, subClassContext, subMethodCreator, methodTarget, subMethodIndex, webTargets, subMethod, subJavaMethodParameters, jandexSubMethod, multipartResponseTypes);
                    continue;
                }
                this.addResponseTypeIfMultipart(multipartResponseTypes, jandexSubMethod, index);
                AssignableResultHandle builder = subMethodCreator.createVariable(Invocation.Builder.class);
                if (method.getProduces() == null || method.getProduces().length == 0) {
                    subMethodCreator.assign(builder, subMethodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"request", Invocation.Builder.class, (Class[])new Class[0]), (ResultHandle)methodTarget, new ResultHandle[0]));
                } else {
                    ResultHandle array = subMethodCreator.newArray(String.class, subMethod.getProduces().length);
                    for (int i = 0; i < subMethod.getProduces().length; ++i) {
                        subMethodCreator.writeArrayValue(array, i, subMethodCreator.load(subMethod.getProduces()[i]));
                    }
                    subMethodCreator.assign(builder, subMethodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"request", Invocation.Builder.class, (Class[])new Class[]{String[].class}), (ResultHandle)methodTarget, new ResultHandle[]{array}));
                }
                for (Map.Entry invocationBuilderEnricher : invocationBuilderEnrichers.entrySet()) {
                    subMethodCreator.assign(builder, subMethodCreator.invokeVirtualMethod((MethodDescriptor)invocationBuilderEnricher.getKey(), subMethodCreator.getThis(), new ResultHandle[]{builder, (ResultHandle)invocationBuilderEnricher.getValue()}));
                }
                for (JaxrsClientReactiveEnricherBuildItem enricher : enrichers) {
                    enricher.getEnricher().forSubResourceMethod(subClassContext.classCreator, subClassContext.constructor, subClassContext.clinit, subMethodCreator, interfaceClass, subResourceInterface, jandexSubMethod, jandexMethod, builder, index, generatedClasses, methodIndex, subMethodIndex, subMethodField);
                }
                String[] consumes = EndpointIndexer.extractProducesConsumesValues((AnnotationInstance)jandexSubMethod.declaringClass().classAnnotation(ResteasyReactiveDotNames.CONSUMES), (String[])method.getConsumes());
                consumes = EndpointIndexer.extractProducesConsumesValues((AnnotationInstance)jandexSubMethod.annotation(ResteasyReactiveDotNames.CONSUMES), (String[])consumes);
                this.handleReturn(subResourceInterface, defaultMediaType, this.getHttpMethod(jandexSubMethod, subMethod.getHttpMethod(), httpAnnotationToMethod), consumes, jandexSubMethod, subMethodCreator, (ResultHandle)formParams, multipartForm, bodyParameterValue, builder);
            }
            subClassContext.constructor.returnValue(null);
            subClassContext.clinit.returnValue(null);
            methodCreator.returnValue(subInstance);
        }
    }

    private AssignableResultHandle createWebTargetForMethod(MethodCreator constructor, AssignableResultHandle baseTarget, ResourceMethod method) {
        AssignableResultHandle target = constructor.createVariable(WebTarget.class);
        constructor.assign(target, (ResultHandle)baseTarget);
        if (method.getPath() != null) {
            this.appendPath(constructor, method.getPath(), target);
        }
        return target;
    }

    private void appendPath(MethodCreator constructor, String pathPart, AssignableResultHandle target) {
        AssignableResultHandle path = constructor.createVariable(String.class);
        constructor.assign(path, constructor.load(pathPart));
        constructor.assign(target, constructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"path", WebTarget.class, (Class[])new Class[]{String.class}), (ResultHandle)target, new ResultHandle[]{path}));
    }

    private FieldDescriptor createRestClientField(String name, ClassCreator c, MethodCreator methodCreator, ClassCreator sub, ResultHandle subInstance) {
        FieldDescriptor clientField = ((FieldCreator)sub.getFieldCreator("client", RestClientBase.class).setModifiers(1)).getFieldDescriptor();
        if (c.getSuperClass().contains(RestClientBase.class.getSimpleName())) {
            methodCreator.writeInstanceField(clientField, subInstance, methodCreator.getThis());
        } else {
            FieldDescriptor subClientField = FieldDescriptor.of((String)name, (String)"client", RestClientBase.class);
            methodCreator.writeInstanceField(clientField, subInstance, methodCreator.readInstanceField(subClientField, methodCreator.getThis()));
        }
        return clientField;
    }

    private ResultHandle createMultipartForm(MethodCreator methodCreator, ResultHandle methodParam, org.jboss.jandex.Type formClassType, IndexView index) {
        AssignableResultHandle multipartForm = methodCreator.createVariable(QuarkusMultipartForm.class);
        methodCreator.assign(multipartForm, methodCreator.newInstance(MethodDescriptor.ofConstructor(QuarkusMultipartForm.class, (Class[])new Class[0]), new ResultHandle[0]));
        ClassInfo formClass = index.getClassByName(formClassType.name());
        for (FieldInfo field : formClass.fields()) {
            if (Modifier.isStatic(field.flags())) continue;
            String fieldName = field.name();
            ResultHandle fieldValue = null;
            String getterName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            for (MethodInfo method : formClass.methods()) {
                if (!method.name().equals(getterName) || !method.returnType().name().equals((Object)field.type().name()) || !method.parameters().isEmpty() || !Modifier.isPublic(method.flags()) || Modifier.isStatic(method.flags())) continue;
                fieldValue = methodCreator.invokeVirtualMethod(method, methodParam, new ResultHandle[0]);
                break;
            }
            if (fieldValue == null && Modifier.isPublic(field.flags())) {
                fieldValue = methodCreator.readInstanceField(field, methodParam);
            }
            if (fieldValue == null) {
                throw new IllegalArgumentException("Non-public field '" + fieldName + "' without a getter, found in a multipart form data class '" + formClassType.name() + "'. Rest Client Reactive only supports multipart form classes with fields that are public or have public getters.");
            }
            String formParamName = this.formParamName(field);
            String partType = this.formPartType(field);
            String partFilename = this.formPartFilename(field);
            org.jboss.jandex.Type fieldType = field.type();
            BytecodeCreator ifValueNotNull = methodCreator.ifNotNull(fieldValue).trueBranch();
            switch (fieldType.kind()) {
                case CLASS: {
                    ClassInfo fieldClass = index.getClassByName(fieldType.name());
                    if (DotNames.STRING.equals((Object)fieldClass.name())) {
                        this.addString(ifValueNotNull, multipartForm, formParamName, partFilename, fieldValue);
                        break;
                    }
                    if (this.is(FILE, fieldClass, index)) {
                        if (partType == null) {
                            throw new IllegalArgumentException("No @PartType annotation found on multipart form field of type File: " + formClass.name() + "." + field.name());
                        }
                        ResultHandle filePath = ifValueNotNull.invokeVirtualMethod(MethodDescriptor.ofMethod(File.class, (String)"toPath", Path.class, (Class[])new Class[0]), fieldValue, new ResultHandle[0]);
                        this.addFile(ifValueNotNull, multipartForm, formParamName, partType, partFilename, filePath);
                        break;
                    }
                    if (this.is(PATH, fieldClass, index)) {
                        if (partType == null) {
                            throw new IllegalArgumentException("No @PartType annotation found on multipart form field of type Path: " + formClass.name() + "." + field.name());
                        }
                        this.addFile(ifValueNotNull, multipartForm, formParamName, partType, partFilename, fieldValue);
                        break;
                    }
                    if (this.is(BUFFER, fieldClass, index)) {
                        this.addBuffer(ifValueNotNull, multipartForm, formParamName, partType, partFilename, fieldValue, field);
                        break;
                    }
                    this.addPojo(ifValueNotNull, multipartForm, formParamName, partType, fieldValue, field);
                    break;
                }
                case ARRAY: {
                    org.jboss.jandex.Type componentType = fieldType.asArrayType().component();
                    if (componentType.kind() != Type.Kind.PRIMITIVE || !Byte.TYPE.getName().equals(componentType.name().toString())) {
                        throw new IllegalArgumentException("Array of unsupported type: " + componentType.name() + " on " + formClassType.name() + "." + field.name());
                    }
                    ResultHandle buffer = ifValueNotNull.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{byte[].class}), new ResultHandle[]{fieldValue});
                    this.addBuffer(ifValueNotNull, multipartForm, formParamName, partType, partFilename, buffer, field);
                    break;
                }
                case PRIMITIVE: {
                    ResultHandle string = this.primitiveToString(ifValueNotNull, fieldValue, field);
                    this.addString(ifValueNotNull, multipartForm, formParamName, partFilename, string);
                    break;
                }
                case PARAMETERIZED_TYPE: {
                    ParameterizedType parameterizedType = fieldType.asParameterizedType();
                    List args = parameterizedType.arguments();
                    if (parameterizedType.name().equals((Object)ResteasyReactiveDotNames.MULTI) && args.size() == 1 && ((org.jboss.jandex.Type)args.get(0)).name().equals((Object)BYTE)) {
                        this.addMultiAsFile(ifValueNotNull, multipartForm, formParamName, partType, field, fieldValue);
                        break;
                    }
                    throw new IllegalArgumentException("Unsupported multipart form field type: " + parameterizedType + "<" + args.stream().map(a -> a.name().toString()).collect(Collectors.joining(",")) + "> in field class " + formClassType.name());
                }
                case VOID: 
                case TYPE_VARIABLE: 
                case UNRESOLVED_TYPE_VARIABLE: 
                case WILDCARD_TYPE: {
                    throw new IllegalArgumentException("Unsupported multipart form field type: " + fieldType + " in field class " + formClassType.name());
                }
            }
        }
        return multipartForm;
    }

    private void addPojo(BytecodeCreator methodCreator, AssignableResultHandle multipartForm, String formParamName, String partType, ResultHandle fieldValue, FieldInfo field) {
        methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"entity", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, Object.class, String.class, Class.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(field.name()), fieldValue, methodCreator.load(partType), methodCreator.loadClass(field.type().name().toString())}));
    }

    private void addFile(BytecodeCreator methodCreator, AssignableResultHandle multipartForm, String formParamName, String partType, String partFilename, ResultHandle filePath) {
        ResultHandle fileNamePath = methodCreator.invokeInterfaceMethod(PATH_GET_FILENAME, filePath, new ResultHandle[0]);
        ResultHandle fileName = partFilename != null ? methodCreator.load(partFilename) : methodCreator.invokeVirtualMethod(OBJECT_TO_STRING, fileNamePath, new ResultHandle[0]);
        ResultHandle pathString = methodCreator.invokeVirtualMethod(OBJECT_TO_STRING, filePath, new ResultHandle[0]);
        if (partType.equalsIgnoreCase("application/octet-stream")) {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"binaryFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, String.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), fileName, pathString, methodCreator.load(partType)}));
        } else {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"textFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, String.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), fileName, pathString, methodCreator.load(partType)}));
        }
    }

    private ResultHandle primitiveToString(BytecodeCreator methodCreator, ResultHandle fieldValue, FieldInfo field) {
        PrimitiveType primitiveType = field.type().asPrimitiveType();
        switch (primitiveType.primitive()) {
            case BOOLEAN: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Boolean.TYPE}), new ResultHandle[]{fieldValue});
            }
            case CHAR: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Character.TYPE}), new ResultHandle[]{fieldValue});
            }
            case DOUBLE: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Double.TYPE}), new ResultHandle[]{fieldValue});
            }
            case FLOAT: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Float.TYPE}), new ResultHandle[]{fieldValue});
            }
            case INT: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{fieldValue});
            }
            case LONG: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Long.TYPE}), new ResultHandle[]{fieldValue});
            }
        }
        throw new IllegalArgumentException("Unsupported primitive type in mulitpart form field: " + field.declaringClass().name() + "." + field.name());
    }

    private ResultHandle partFilenameHandle(BytecodeCreator methodCreator, String partFilename) {
        return partFilename != null ? methodCreator.load(partFilename) : methodCreator.loadNull();
    }

    private void addString(BytecodeCreator methodCreator, AssignableResultHandle multipartForm, String formParamName, String partFilename, ResultHandle fieldValue) {
        methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"attribute", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), fieldValue, this.partFilenameHandle(methodCreator, partFilename)}));
    }

    private void addMultiAsFile(BytecodeCreator methodCreator, AssignableResultHandle multipartForm, String formParamName, String partType, FieldInfo field, ResultHandle multi) {
        if (partType == null) {
            throw new IllegalArgumentException("No @PartType annotation found on multipart form field " + field.declaringClass().name() + "." + field.name());
        }
        if (partType.equalsIgnoreCase("application/octet-stream")) {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"multiAsBinaryFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, Multi.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), methodCreator.load(formParamName), multi, methodCreator.load(partType)}));
        } else {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"multiAsTextFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, Multi.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), methodCreator.load(formParamName), multi, methodCreator.load(partType)}));
        }
    }

    private void addBuffer(BytecodeCreator methodCreator, AssignableResultHandle multipartForm, String formParamName, String partType, String partFilename, ResultHandle buffer, FieldInfo field) {
        ResultHandle filenameHandle;
        ResultHandle resultHandle = filenameHandle = partFilename != null ? methodCreator.load(partFilename) : methodCreator.load(formParamName);
        if (partType == null) {
            throw new IllegalArgumentException("No @PartType annotation found on multipart form field " + field.declaringClass().name() + "." + field.name());
        }
        if (partType.equalsIgnoreCase("application/octet-stream")) {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"binaryFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, Buffer.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), filenameHandle, buffer, methodCreator.load(partType)}));
        } else {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"textFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, Buffer.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), filenameHandle, buffer, methodCreator.load(partType)}));
        }
    }

    private String formPartType(FieldInfo field) {
        AnnotationInstance partType = field.annotation(ResteasyReactiveDotNames.PART_TYPE_NAME);
        if (partType != null) {
            return partType.value().asString();
        }
        return null;
    }

    private String formPartFilename(FieldInfo field) {
        AnnotationInstance partType = field.annotation(ResteasyReactiveDotNames.PART_FILE_NAME);
        if (partType != null) {
            return partType.value().asString();
        }
        return null;
    }

    private String formParamName(FieldInfo field) {
        AnnotationInstance restFormParam = field.annotation(ResteasyReactiveDotNames.REST_FORM_PARAM);
        AnnotationInstance formParam = field.annotation(ResteasyReactiveDotNames.FORM_PARAM);
        if (restFormParam != null && formParam != null) {
            throw new IllegalArgumentException("Only one of @RestFormParam, @FormParam annotations expected on a field. Found both on " + field.declaringClass() + "." + field.name());
        }
        if (restFormParam != null) {
            AnnotationValue value = restFormParam.value();
            if (value == null || "".equals(value.asString())) {
                return field.name();
            }
            return value.asString();
        }
        if (formParam != null) {
            return formParam.value().asString();
        }
        throw new IllegalArgumentException("One of @RestFormParam, @FormParam annotations expected on a field. No annotation found on " + field.declaringClass() + "." + field.name());
    }

    private boolean is(DotName desiredClass, ClassInfo fieldClass, IndexView index) {
        ClassInfo superClass;
        if (fieldClass.name().equals((Object)desiredClass)) {
            return true;
        }
        if (fieldClass.name().toString().equals(Object.class.getName()) || (superClass = index.getClassByName(fieldClass.superName())) == null) {
            return false;
        }
        return this.is(desiredClass, superClass, index);
    }

    private AssignableResultHandle createIfAbsent(BytecodeCreator methodCreator, AssignableResultHandle formValues) {
        if (formValues == null) {
            formValues = methodCreator.createVariable(MultivaluedMap.class);
            methodCreator.assign(formValues, methodCreator.newInstance(MethodDescriptor.ofConstructor(MultivaluedHashMap.class, (Class[])new Class[0]), new ResultHandle[0]));
        }
        return formValues;
    }

    private String[] parametersAsStringArray(MethodInfo subMethod) {
        List params = subMethod.parameters();
        String[] result = new String[params.size()];
        int i = 0;
        for (org.jboss.jandex.Type param : params) {
            result[i++] = param.name().toString();
        }
        return result;
    }

    private String getHttpMethod(MethodInfo subMethod, String defaultMethod, Map<DotName, String> httpAnnotationToMethod) {
        for (Map.Entry<DotName, String> annoToMethod : httpAnnotationToMethod.entrySet()) {
            if (subMethod.annotation(annoToMethod.getKey()) == null) continue;
            return annoToMethod.getValue();
        }
        for (Map.Entry<DotName, String> annoToMethod : httpAnnotationToMethod.entrySet()) {
            if (subMethod.declaringClass().classAnnotation(annoToMethod.getKey()) == null) continue;
            return annoToMethod.getValue();
        }
        return defaultMethod;
    }

    private void handleReturn(ClassInfo restClientInterface, String defaultMediaType, String httpMethod, String[] consumes, MethodInfo jandexMethod, MethodCreator methodCreator, ResultHandle formParams, ResultHandle multipartForm, ResultHandle bodyValue, AssignableResultHandle builder) {
        ResultHandle rx;
        ResultHandle result;
        Integer continuationIndex;
        ResultHandle genericReturnType;
        String simpleReturnType;
        ReturnCategory returnCategory;
        block35: {
            org.jboss.jandex.Type lastParamType;
            List parameters;
            org.jboss.jandex.Type returnType = jandexMethod.returnType();
            returnCategory = ReturnCategory.BLOCKING;
            simpleReturnType = returnType.name().toString();
            genericReturnType = null;
            if (returnType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                ParameterizedType paramType = returnType.asParameterizedType();
                if (ASYNC_RETURN_TYPES.contains(paramType.name())) {
                    ReturnCategory returnCategory2 = paramType.name().equals((Object)ResteasyReactiveDotNames.COMPLETION_STAGE) ? ReturnCategory.COMPLETION_STAGE : (returnCategory = paramType.name().equals((Object)ResteasyReactiveDotNames.MULTI) ? ReturnCategory.MULTI : ReturnCategory.UNI);
                    if (paramType.arguments().isEmpty()) {
                        simpleReturnType = Object.class.getName();
                    } else {
                        org.jboss.jandex.Type type = (org.jboss.jandex.Type)paramType.arguments().get(0);
                        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                            genericReturnType = this.createGenericTypeFromParameterizedType(methodCreator, type.asParameterizedType());
                        } else {
                            simpleReturnType = type.name().toString();
                        }
                    }
                } else {
                    genericReturnType = this.createGenericTypeFromParameterizedType(methodCreator, paramType);
                }
            }
            continuationIndex = null;
            if (returnCategory == ReturnCategory.BLOCKING && !(parameters = jandexMethod.parameters()).isEmpty() && (lastParamType = (org.jboss.jandex.Type)parameters.get(parameters.size() - 1)).name().equals((Object)CONTINUATION)) {
                continuationIndex = parameters.size() - 1;
                returnCategory = ReturnCategory.COROUTINE;
                try {
                    Thread.currentThread().getContextClassLoader().loadClass(UNI_KT.toString());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Suspendable rest client method" + jandexMethod + " is present on class " + jandexMethod.declaringClass() + " however io.smallrye.reactive:mutiny-kotlin is not detected. Please add a dependency on this artifact.");
                }
                org.jboss.jandex.Type type = (org.jboss.jandex.Type)lastParamType.asParameterizedType().arguments().get(0);
                while (true) {
                    if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        genericReturnType = this.createGenericTypeFromParameterizedType(methodCreator, type.asParameterizedType());
                        break block35;
                    }
                    if (type.kind() != Type.Kind.WILDCARD_TYPE) break;
                    if (type.asWildcardType().extendsBound().name().equals((Object)ResteasyReactiveDotNames.OBJECT)) {
                        type = type.asWildcardType().superBound();
                        continue;
                    }
                    type = type.asWildcardType().extendsBound();
                }
                simpleReturnType = type.name().toString();
            }
        }
        String mediaTypeValue = defaultMediaType;
        TryBlock tryBlock = methodCreator.tryBlock();
        List exceptionTypes = jandexMethod.exceptions();
        LinkedHashSet<String> exceptions = new LinkedHashSet<String>();
        for (org.jboss.jandex.Type exceptionType : exceptionTypes) {
            exceptions.add(exceptionType.name().toString());
        }
        if (!exceptions.contains(Exception.class.getName()) && !exceptions.contains(Throwable.class.getName())) {
            exceptions.add(RuntimeException.class.getName());
        }
        CatchBlockCreator catchBlock = tryBlock.addCatch(ProcessingException.class);
        ResultHandle caughtException = catchBlock.getCaughtException();
        ResultHandle cause = catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"getCause", Throwable.class, (Class[])new Class[0]), caughtException, new ResultHandle[0]);
        for (String exception : exceptions) {
            catchBlock.ifTrue(catchBlock.instanceOf(cause, exception)).trueBranch().throwException(cause);
        }
        catchBlock.throwException(caughtException);
        if (bodyValue != null || formParams != null || multipartForm != null) {
            if (this.countNonNulls(bodyValue, formParams, multipartForm) > 1) {
                throw new IllegalArgumentException("Attempt to pass at least two of form, multipart form or regular entity as a request body in " + restClientInterface.name().toString() + "#" + jandexMethod.name());
            }
            if (consumes != null && consumes.length > 0) {
                if (consumes.length > 1) {
                    throw new IllegalArgumentException("Multiple `@Consumes` values used in a MicroProfile Rest Client: " + restClientInterface.name().toString() + " Unable to determine a single `Content-Type`.");
                }
                mediaTypeValue = consumes[0];
            }
            ResultHandle mediaType = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(MediaType.class, (String)"valueOf", MediaType.class, (Class[])new Class[]{String.class}), new ResultHandle[]{tryBlock.load(mediaTypeValue)});
            ResultHandle entity = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Entity.class, (String)"entity", Entity.class, (Class[])new Class[]{Object.class, MediaType.class}), new ResultHandle[]{bodyValue != null ? bodyValue : (formParams != null ? formParams : multipartForm), mediaType});
            if (returnCategory == ReturnCategory.COMPLETION_STAGE) {
                ResultHandle async = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"async", AsyncInvoker.class, (Class[])new Class[0]), (ResultHandle)builder, new ResultHandle[0]);
                result = genericReturnType != null ? tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(CompletionStageRxInvoker.class, (String)"method", CompletionStage.class, (Class[])new Class[]{String.class, Entity.class, GenericType.class}), async, new ResultHandle[]{tryBlock.load(httpMethod), entity, genericReturnType}) : tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(CompletionStageRxInvoker.class, (String)"method", CompletionStage.class, (Class[])new Class[]{String.class, Entity.class, Class.class}), async, new ResultHandle[]{tryBlock.load(httpMethod), entity, tryBlock.loadClass(simpleReturnType)});
            } else if (returnCategory == ReturnCategory.UNI || returnCategory == ReturnCategory.COROUTINE) {
                ResultHandle rx2 = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"rx", RxInvoker.class, (Class[])new Class[]{Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.loadClass(UniInvoker.class)});
                ResultHandle uniInvoker = tryBlock.checkCast(rx2, UniInvoker.class);
                result = genericReturnType != null ? tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(UniInvoker.class, (String)"method", Uni.class, (Class[])new Class[]{String.class, Entity.class, GenericType.class}), uniInvoker, new ResultHandle[]{tryBlock.load(httpMethod), entity, genericReturnType}) : tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(UniInvoker.class, (String)"method", Uni.class, (Class[])new Class[]{String.class, Entity.class, Class.class}), uniInvoker, new ResultHandle[]{tryBlock.load(httpMethod), entity, tryBlock.loadClass(simpleReturnType)});
                if (returnCategory == ReturnCategory.COROUTINE) {
                    result = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod((Object)UNI_KT.toString(), (String)"awaitSuspending", Object.class, (Object[])new Object[]{Uni.class, CONTINUATION.toString()}), new ResultHandle[]{result, tryBlock.getMethodParam(continuationIndex.intValue())});
                }
            } else if (returnCategory == ReturnCategory.MULTI) {
                ResultHandle rx3 = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"rx", RxInvoker.class, (Class[])new Class[]{Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.loadClass(MultiInvoker.class)});
                ResultHandle multiInvoker = tryBlock.checkCast(rx3, MultiInvoker.class);
                result = genericReturnType != null ? tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(MultiInvoker.class, (String)"method", Multi.class, (Class[])new Class[]{String.class, Entity.class, GenericType.class}), multiInvoker, new ResultHandle[]{tryBlock.load(httpMethod), entity, genericReturnType}) : tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractRxInvoker.class, (String)"method", Object.class, (Class[])new Class[]{String.class, Entity.class, Class.class}), multiInvoker, new ResultHandle[]{tryBlock.load(httpMethod), entity, tryBlock.loadClass(simpleReturnType)});
            } else {
                result = genericReturnType != null ? tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"method", Object.class, (Class[])new Class[]{String.class, Entity.class, GenericType.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.load(httpMethod), entity, genericReturnType}) : tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"method", Object.class, (Class[])new Class[]{String.class, Entity.class, Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.load(httpMethod), entity, tryBlock.loadClass(simpleReturnType)});
            }
        } else if (returnCategory == ReturnCategory.COMPLETION_STAGE) {
            ResultHandle async = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"async", AsyncInvoker.class, (Class[])new Class[0]), (ResultHandle)builder, new ResultHandle[0]);
            result = genericReturnType != null ? tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(CompletionStageRxInvoker.class, (String)"method", CompletionStage.class, (Class[])new Class[]{String.class, GenericType.class}), async, new ResultHandle[]{tryBlock.load(httpMethod), genericReturnType}) : tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(CompletionStageRxInvoker.class, (String)"method", CompletionStage.class, (Class[])new Class[]{String.class, Class.class}), async, new ResultHandle[]{tryBlock.load(httpMethod), tryBlock.loadClass(simpleReturnType)});
        } else if (returnCategory == ReturnCategory.UNI || returnCategory == ReturnCategory.COROUTINE) {
            rx = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"rx", RxInvoker.class, (Class[])new Class[]{Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.loadClass(UniInvoker.class)});
            ResultHandle uniInvoker = tryBlock.checkCast(rx, UniInvoker.class);
            result = genericReturnType != null ? tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(UniInvoker.class, (String)"method", Uni.class, (Class[])new Class[]{String.class, GenericType.class}), uniInvoker, new ResultHandle[]{tryBlock.load(httpMethod), genericReturnType}) : tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(UniInvoker.class, (String)"method", Uni.class, (Class[])new Class[]{String.class, Class.class}), uniInvoker, new ResultHandle[]{tryBlock.load(httpMethod), tryBlock.loadClass(simpleReturnType)});
            if (returnCategory == ReturnCategory.COROUTINE) {
                result = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod((Object)UNI_KT.toString(), (String)"awaitSuspending", Object.class, (Object[])new Object[]{Uni.class, CONTINUATION.toString()}), new ResultHandle[]{result, tryBlock.getMethodParam(continuationIndex.intValue())});
            }
        } else if (returnCategory == ReturnCategory.MULTI) {
            rx = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"rx", RxInvoker.class, (Class[])new Class[]{Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.loadClass(MultiInvoker.class)});
            ResultHandle multiInvoker = tryBlock.checkCast(rx, MultiInvoker.class);
            result = genericReturnType != null ? tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractRxInvoker.class, (String)"method", Object.class, (Class[])new Class[]{String.class, GenericType.class}), multiInvoker, new ResultHandle[]{tryBlock.load(httpMethod), genericReturnType}) : tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractRxInvoker.class, (String)"method", Object.class, (Class[])new Class[]{String.class, Class.class}), multiInvoker, new ResultHandle[]{tryBlock.load(httpMethod), tryBlock.loadClass(simpleReturnType)});
        } else {
            result = genericReturnType != null ? tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"method", Object.class, (Class[])new Class[]{String.class, GenericType.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.load(httpMethod), genericReturnType}) : tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"method", Object.class, (Class[])new Class[]{String.class, Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.load(httpMethod), tryBlock.loadClass(simpleReturnType)});
        }
        tryBlock.returnValue(result);
    }

    private int countNonNulls(Object ... objects) {
        int result = 0;
        for (Object object : objects) {
            if (object == null) continue;
            ++result;
        }
        return result;
    }

    private ResultHandle createGenericTypeFromParameterizedType(MethodCreator methodCreator, ParameterizedType parameterizedType2) {
        ResultHandle currentThread = methodCreator.invokeStaticMethod(MethodDescriptors.THREAD_CURRENT_THREAD, new ResultHandle[0]);
        ResultHandle tccl = methodCreator.invokeVirtualMethod(MethodDescriptors.THREAD_GET_TCCL, currentThread, new ResultHandle[0]);
        ResultHandle parameterizedType = Types.getParameterizedType((BytecodeCreator)methodCreator, (ResultHandle)tccl, (ParameterizedType)parameterizedType2);
        ResultHandle genericReturnType = methodCreator.newInstance(MethodDescriptor.ofConstructor(GenericType.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{parameterizedType});
        return genericReturnType;
    }

    private Optional<MethodInfo> getJavaMethod(ClassInfo interfaceClass, ResourceMethod method, MethodParameter[] parameters, IndexView index) {
        DotName interfaceName;
        for (MethodInfo methodInfo : interfaceClass.methods()) {
            if (!methodInfo.name().equals(method.getName()) || methodInfo.parameters().size() != parameters.length) continue;
            boolean matches = true;
            for (int i = 0; i < parameters.length; ++i) {
                String declaredType;
                MethodParameter actualParam = parameters[i];
                org.jboss.jandex.Type parameterType = (org.jboss.jandex.Type)methodInfo.parameters().get(i);
                String string = declaredType = actualParam.declaredType != null ? actualParam.declaredType : actualParam.type;
                if (declaredType.equals(parameterType.name().toString())) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return Optional.of(methodInfo);
        }
        Optional<MethodInfo> maybeMethod = Optional.empty();
        Iterator iterator = interfaceClass.interfaceNames().iterator();
        while (iterator.hasNext() && !(maybeMethod = this.getJavaMethod(index.getClassByName(interfaceName = (DotName)iterator.next()), method, parameters, index)).isPresent()) {
        }
        return maybeMethod;
    }

    private AssignableResultHandle addBeanParamData(BytecodeCreator methodCreator, BytecodeCreator invocationBuilderEnricher, AssignableResultHandle invocationBuilder, List<Item> beanParamItems, ResultHandle param, AssignableResultHandle target, IndexView index, String restClientInterfaceClassName, ResultHandle client, ResultHandle invocationEnricherClient, AssignableResultHandle formParams, Supplier<FieldDescriptor> methodGenericTypeField, Supplier<FieldDescriptor> methodParamAnnotationsField, int paramIdx) {
        if (this.areFormParamsDefinedIn(beanParamItems)) {
            formParams = this.createIfAbsent(methodCreator, formParams);
        }
        this.addSubBeanParamData(methodCreator, invocationBuilderEnricher, invocationBuilder, beanParamItems, param, target, index, restClientInterfaceClassName, client, invocationEnricherClient, formParams, methodGenericTypeField, methodParamAnnotationsField, paramIdx);
        return formParams;
    }

    private void addSubBeanParamData(BytecodeCreator methodCreator, BytecodeCreator invocationBuilderEnricher, AssignableResultHandle invocationBuilder, List<Item> beanParamItems, ResultHandle param, AssignableResultHandle target, IndexView index, String restClientInterfaceClassName, ResultHandle client, ResultHandle invocationEnricherClient, AssignableResultHandle formParams, Supplier<FieldDescriptor> methodGenericTypeField, Supplier<FieldDescriptor> methodParamAnnotationsField, int paramIdx) {
        BytecodeCreator creator = methodCreator.ifNotNull(param).trueBranch();
        BytecodeCreator invoEnricher = invocationBuilderEnricher.ifNotNull(invocationBuilderEnricher.getMethodParam(1)).trueBranch();
        block8: for (Item item : beanParamItems) {
            switch (item.type()) {
                case BEAN_PARAM: {
                    BeanParamItem beanParamItem = (BeanParamItem)item;
                    ResultHandle beanParamElementHandle = beanParamItem.extract(creator, param);
                    this.addSubBeanParamData(creator, invoEnricher, invocationBuilder, beanParamItem.items(), beanParamElementHandle, target, index, restClientInterfaceClassName, client, invocationEnricherClient, formParams, methodGenericTypeField, methodParamAnnotationsField, paramIdx);
                    continue block8;
                }
                case QUERY_PARAM: {
                    QueryParamItem queryParam = (QueryParamItem)item;
                    creator.assign(target, this.addQueryParam(creator, (ResultHandle)target, queryParam.name(), queryParam.extract(creator, param), queryParam.getValueType(), index, client, creator.readArrayValue(creator.readStaticField(methodGenericTypeField.get()), paramIdx), creator.readArrayValue(creator.readStaticField(methodParamAnnotationsField.get()), paramIdx)));
                    continue block8;
                }
                case COOKIE: {
                    CookieParamItem cookieParam = (CookieParamItem)item;
                    this.addCookieParam(invoEnricher, invocationBuilder, cookieParam.getCookieName(), cookieParam.extract(invoEnricher, invoEnricher.getMethodParam(1)), cookieParam.getParamType(), invocationEnricherClient, methodGenericTypeField.get(), methodParamAnnotationsField.get(), paramIdx);
                    continue block8;
                }
                case HEADER_PARAM: {
                    HeaderParamItem headerParam = (HeaderParamItem)item;
                    this.addHeaderParam(invoEnricher, invocationBuilder, headerParam.getHeaderName(), headerParam.extract(invoEnricher, invoEnricher.getMethodParam(1)), headerParam.getParamType(), invocationEnricherClient, methodGenericTypeField.get(), methodParamAnnotationsField.get(), paramIdx);
                    continue block8;
                }
                case PATH_PARAM: {
                    PathParamItem pathParam = (PathParamItem)item;
                    this.addPathParam(creator, target, pathParam.getPathParamName(), pathParam.extract(creator, param), pathParam.getParamType(), client, creator.readArrayValue(creator.readStaticField(methodGenericTypeField.get()), paramIdx), creator.readArrayValue(creator.readStaticField(methodParamAnnotationsField.get()), paramIdx));
                    continue block8;
                }
                case FORM_PARAM: {
                    FormParamItem formParam = (FormParamItem)item;
                    this.addFormParam(creator, formParam.getFormParamName(), formParam.extract(creator, param), formParam.getParamType(), restClientInterfaceClassName, client, formParams, creator.readArrayValue(creator.readStaticField(methodGenericTypeField.get()), paramIdx), creator.readArrayValue(creator.readStaticField(methodParamAnnotationsField.get()), paramIdx));
                    continue block8;
                }
            }
            throw new IllegalStateException("Unimplemented");
        }
    }

    private boolean areFormParamsDefinedIn(List<Item> beanParamItems) {
        for (Item item : beanParamItems) {
            switch (item.type()) {
                case FORM_PARAM: {
                    return true;
                }
                case BEAN_PARAM: {
                    if (!this.areFormParamsDefinedIn(((BeanParamItem)item).items())) break;
                    return true;
                }
            }
        }
        return false;
    }

    private ResultHandle addQueryParam(BytecodeCreator methodCreator, ResultHandle target, String paramName, ResultHandle queryParamHandle, org.jboss.jandex.Type type, IndexView index, ResultHandle client, ResultHandle genericType, ResultHandle paramAnnotations) {
        ResultHandle paramArray;
        String componentType = null;
        AssignableResultHandle result = methodCreator.createVariable(WebTarget.class);
        BranchResult isValueNull = methodCreator.ifNull(target);
        BytecodeCreator notNullValue = isValueNull.falseBranch();
        if (type.kind() == Type.Kind.ARRAY) {
            componentType = type.asArrayType().component().name().toString();
            paramArray = notNullValue.checkCast(queryParamHandle, Object[].class);
        } else if (this.isCollection(type, index)) {
            org.jboss.jandex.Type paramType;
            if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && (paramType = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0)).kind() == Type.Kind.CLASS) {
                componentType = paramType.name().toString();
            }
            if (componentType == null) {
                componentType = DotNames.OBJECT.toString();
            }
            paramArray = notNullValue.invokeStaticMethod(MethodDescriptor.ofMethod(ToObjectArray.class, (String)"collection", Object[].class, (Class[])new Class[]{Collection.class}), new ResultHandle[]{queryParamHandle});
        } else {
            componentType = type.name().toString();
            paramArray = notNullValue.invokeStaticMethod(MethodDescriptor.ofMethod(ToObjectArray.class, (String)"value", Object[].class, (Class[])new Class[]{Object.class}), new ResultHandle[]{queryParamHandle});
        }
        paramArray = notNullValue.invokeVirtualMethod(MethodDescriptor.ofMethod(RestClientBase.class, (String)"convertParamArray", Object[].class, (Class[])new Class[]{Object[].class, Class.class, Type.class, Annotation[].class}), client, new ResultHandle[]{paramArray, notNullValue.loadClass(componentType), genericType, paramAnnotations});
        notNullValue.assign(result, notNullValue.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"queryParam", WebTarget.class, (Class[])new Class[]{String.class, Object[].class}), target, new ResultHandle[]{notNullValue.load(paramName), paramArray}));
        BytecodeCreator nullValue = isValueNull.trueBranch();
        nullValue.assign(result, nullValue.loadNull());
        return result;
    }

    private boolean isCollection(org.jboss.jandex.Type type, IndexView index) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return false;
        }
        ClassInfo classInfo = index.getClassByName(type.name());
        if (classInfo == null) {
            return false;
        }
        return classInfo.interfaceNames().stream().anyMatch(arg_0 -> ((DotName)DotName.createSimple((String)Collection.class.getName())).equals(arg_0));
    }

    private void addHeaderParam(BytecodeCreator invoBuilderEnricher, AssignableResultHandle invocationBuilder, String paramName, ResultHandle headerParamHandle, String paramType, ResultHandle client, FieldDescriptor methodGenericTypeField, FieldDescriptor methodParamAnnotationsField, int paramIdx) {
        BytecodeCreator notNullValue = invoBuilderEnricher.ifNull(headerParamHandle).falseBranch();
        ResultHandle genericType = notNullValue.readArrayValue(notNullValue.readStaticField(methodGenericTypeField), paramIdx);
        ResultHandle parameterAnnotations = notNullValue.readArrayValue(notNullValue.readStaticField(methodParamAnnotationsField), paramIdx);
        headerParamHandle = notNullValue.invokeVirtualMethod(MethodDescriptor.ofMethod(RestClientBase.class, (String)"convertParam", Object.class, (Class[])new Class[]{Object.class, Class.class, Type.class, Annotation[].class}), client, new ResultHandle[]{headerParamHandle, notNullValue.loadClass(paramType), genericType, parameterAnnotations});
        notNullValue.assign(invocationBuilder, notNullValue.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"header", Invocation.Builder.class, (Class[])new Class[]{String.class, Object.class}), (ResultHandle)invocationBuilder, new ResultHandle[]{notNullValue.load(paramName), headerParamHandle}));
    }

    private void addPathParam(BytecodeCreator methodCreator, AssignableResultHandle methodTarget, String paramName, ResultHandle pathParamHandle, String parameterType, ResultHandle client, ResultHandle genericType, ResultHandle parameterAnnotations) {
        ResultHandle handle = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(RestClientBase.class, (String)"convertParam", Object.class, (Class[])new Class[]{Object.class, Class.class, Type.class, Annotation[].class}), client, new ResultHandle[]{pathParamHandle, methodCreator.loadClass(parameterType), genericType, parameterAnnotations});
        methodCreator.assign(methodTarget, methodCreator.invokeInterfaceMethod(WEB_TARGET_RESOLVE_TEMPLATE_METHOD, (ResultHandle)methodTarget, new ResultHandle[]{methodCreator.load(paramName), handle}));
    }

    private void addFormParam(BytecodeCreator methodCreator, String paramName, ResultHandle formParamHandle, String parameterType, String restClientInterfaceClassName, ResultHandle client, AssignableResultHandle formParams, ResultHandle genericType, ResultHandle parameterAnnotations) {
        BytecodeCreator notNullValue = methodCreator.ifNull(formParamHandle).falseBranch();
        ResultHandle convertedFormParam = notNullValue.invokeVirtualMethod(MethodDescriptor.ofMethod(RestClientBase.class, (String)"convertParam", Object.class, (Class[])new Class[]{Object.class, Class.class, Type.class, Annotation[].class}), client, new ResultHandle[]{formParamHandle, notNullValue.loadClassFromTCCL(parameterType), genericType, parameterAnnotations});
        ResultHandle isString = notNullValue.instanceOf(convertedFormParam, String.class);
        BranchResult isStringBranch = notNullValue.ifTrue(isString);
        isStringBranch.falseBranch().throwException(IllegalStateException.class, "Form parameter '" + paramName + "' could not be converted to 'String' for REST Client interface '" + restClientInterfaceClassName + "'. A proper implementation of '" + ParamConverter.class.getName() + "' needs to be returned by a '" + ParamConverterProvider.class.getName() + "' that is registered with the client via the @RegisterProvider annotation on the REST Client interface.");
        isStringBranch.trueBranch().invokeInterfaceMethod(MULTIVALUED_MAP_ADD, (ResultHandle)formParams, new ResultHandle[]{notNullValue.load(paramName), convertedFormParam});
    }

    private void addCookieParam(BytecodeCreator invoBuilderEnricher, AssignableResultHandle invocationBuilder, String paramName, ResultHandle cookieParamHandle, String paramType, ResultHandle client, FieldDescriptor methodGenericTypeField, FieldDescriptor methodParamAnnotationsField, int paramIdx) {
        BytecodeCreator notNullValue = invoBuilderEnricher.ifNull(cookieParamHandle).falseBranch();
        ResultHandle genericType = notNullValue.readArrayValue(notNullValue.readStaticField(methodGenericTypeField), paramIdx);
        ResultHandle parameterAnnotations = notNullValue.readArrayValue(notNullValue.readStaticField(methodParamAnnotationsField), paramIdx);
        cookieParamHandle = notNullValue.invokeVirtualMethod(MethodDescriptor.ofMethod(RestClientBase.class, (String)"convertParam", Object.class, (Class[])new Class[]{Object.class, Class.class, Type.class, Annotation[].class}), client, new ResultHandle[]{cookieParamHandle, notNullValue.loadClass(paramType), genericType, parameterAnnotations});
        notNullValue.assign(invocationBuilder, notNullValue.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"cookie", Invocation.Builder.class, (Class[])new Class[]{String.class, String.class}), (ResultHandle)invocationBuilder, new ResultHandle[]{notNullValue.load(paramName), cookieParamHandle}));
    }

    private static enum ReturnCategory {
        BLOCKING,
        COMPLETION_STAGE,
        UNI,
        MULTI,
        COROUTINE;

    }
}

