/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kogito.deployment;

import io.quarkus.dev.CompilationProvider;
import io.quarkus.dev.JavaCompilationProvider;
import io.quarkus.kogito.deployment.KogitoCompilerException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.di.CDIDependencyInjectionAnnotator;
import org.kie.kogito.codegen.di.DependencyInjectionAnnotator;

public abstract class KogitoCompilationProvider
extends JavaCompilationProvider {
    protected static Map<Path, Path> classToSource = new HashMap<Path, Path>();
    private String appPackageName = System.getProperty("kogito.codegen.packageName", "org.kie.kogito.app");

    public Set<String> handledSourcePaths() {
        return Collections.singleton("src" + File.separator + "main" + File.separator + "resources");
    }

    public final void compile(Set<File> filesToCompile, CompilationProvider.Context context) {
        File outputDirectory = context.getOutputDirectory();
        try {
            ApplicationGenerator appGen = new ApplicationGenerator(this.appPackageName, outputDirectory).withDependencyInjection((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator());
            Generator generator = this.addGenerator(appGen, filesToCompile, context);
            Collection generatedFiles = generator.generate();
            HashSet<File> generatedSourceFiles = new HashSet<File>();
            for (GeneratedFile file : generatedFiles) {
                Path path = this.pathOf(outputDirectory.getPath(), file.relativePath());
                Files.write(path, file.contents(), new OpenOption[0]);
                generatedSourceFiles.add(path.toFile());
            }
            super.compile(generatedSourceFiles, context);
        }
        catch (IOException e) {
            throw new KogitoCompilerException(e);
        }
    }

    public Path getSourcePath(Path classFilePath, Set<String> sourcePaths, String classesPath) {
        if (classToSource.containsKey(classFilePath)) {
            return classToSource.get(classFilePath);
        }
        return null;
    }

    protected abstract Generator addGenerator(ApplicationGenerator var1, Set<File> var2, CompilationProvider.Context var3) throws IOException;

    private Path pathOf(String path, String relativePath) {
        Path p = Paths.get(path, relativePath);
        p.getParent().toFile().mkdirs();
        return p;
    }
}

